/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.client.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.hawkular.metrics.client.common.SingleMetric;

public final class MetricBuffer {
    private final int capacity;
    private final Deque<SingleMetric> buffer;

    public MetricBuffer(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity: " + capacity);
        }
        this.capacity = capacity;
        this.buffer = new ArrayDeque<SingleMetric>(capacity);
    }

    public int size() {
        return this.buffer.size();
    }

    public int remainingCapacity() {
        return this.capacity - this.buffer.size();
    }

    public void insert(SingleMetric metric) {
        if (metric == null) {
            return;
        }
        if (this.remainingCapacity() == 0) {
            this.buffer.removeLast();
        }
        this.buffer.addFirst(metric);
    }

    public List<SingleMetric> remove(int batchSize) {
        if (batchSize < 0) {
            throw new IllegalArgumentException("batchSize: " + batchSize);
        }
        int count = Math.min(this.buffer.size(), batchSize);
        ArrayList<SingleMetric> metrics = new ArrayList<SingleMetric>(count);
        for (int i = 0; i < count; ++i) {
            metrics.add(this.buffer.removeLast());
        }
        return metrics;
    }

    public void reInsert(List<SingleMetric> metrics) {
        if (metrics == null || metrics.isEmpty()) {
            return;
        }
        int remainingCapacity = this.remainingCapacity();
        if (remainingCapacity < metrics.size()) {
            metrics = metrics.subList(metrics.size() - remainingCapacity, metrics.size());
        }
        for (int i = metrics.size(); i > 0; --i) {
            SingleMetric metric = metrics.get(i - 1);
            if (metric == null) continue;
            this.buffer.addLast(metric);
        }
    }
}

