/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.scheduler;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.InventoryListener;
import org.hawkular.agent.monitor.api.SamplingService;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.scheduler.MeasurementScheduler;
import org.hawkular.agent.monitor.scheduler.SchedulerConfiguration;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.hawkular.agent.monitor.storage.AvailBufferedStorageDispatcher;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.MetricBufferedStorageDispatcher;
import org.hawkular.agent.monitor.storage.MetricDataPoint;
import org.hawkular.agent.monitor.storage.PingStorageDispatcher;
import org.hawkular.agent.monitor.storage.StorageAdapter;
import org.hawkular.agent.monitor.util.ThreadFactoryGenerator;

public class SchedulerService
implements InventoryListener {
    private static final MsgLogger log = AgentLoggers.getLogger(SchedulerService.class);
    private final Diagnostics diagnostics;
    private final MeasurementScheduler<Object, MetricType<Object>, MetricDataPoint> metricScheduler;
    private final MeasurementScheduler<Object, AvailType<Object>, AvailDataPoint> availScheduler;
    private final ScheduledThreadPoolExecutor pingScheduler;
    private final MetricBufferedStorageDispatcher metricStorage;
    private final AvailBufferedStorageDispatcher availStorage;
    private final PingStorageDispatcher pingStorage;
    private ScheduledFuture<?> pingJob;
    protected volatile ServiceStatus status = ServiceStatus.INITIAL;

    public SchedulerService(SchedulerConfiguration configuration, Diagnostics diagnostics, StorageAdapter storageAdapter) {
        this.diagnostics = diagnostics;
        this.metricStorage = new MetricBufferedStorageDispatcher(configuration, storageAdapter, diagnostics);
        this.metricScheduler = MeasurementScheduler.forMetrics("Hawkular-WildFly-Agent-Scheduler-Metrics", this.metricStorage);
        this.availStorage = new AvailBufferedStorageDispatcher(configuration, storageAdapter, diagnostics);
        this.availScheduler = MeasurementScheduler.forAvails("Hawkular-WildFly-Agent-Scheduler-Avail", this.availStorage);
        this.pingStorage = new PingStorageDispatcher(configuration, storageAdapter, diagnostics);
        ThreadFactory threadFactory = ThreadFactoryGenerator.generateFactory(true, "Hawkular-WildFly-Scheduler-Ping");
        this.pingScheduler = new ScheduledThreadPoolExecutor(1, threadFactory);
    }

    public void start() {
        this.status.assertInitialOrStopped(this.getClass(), "start()");
        this.status = ServiceStatus.STARTING;
        log.infoStartingScheduler();
        int pingPeriod = this.pingStorage.getConfig().getPingDispatcherPeriodSeconds();
        if (pingPeriod > 0) {
            this.pingJob = this.pingScheduler.scheduleAtFixedRate(this.pingStorage, 0L, pingPeriod, TimeUnit.SECONDS);
        }
        this.metricStorage.start();
        this.metricScheduler.start();
        this.availStorage.start();
        this.availScheduler.start();
        this.status = ServiceStatus.RUNNING;
    }

    public void stop() {
        this.status.assertRunning(this.getClass(), "stop()");
        this.status = ServiceStatus.STOPPING;
        log.infoStoppingScheduler();
        this.metricStorage.shutdown();
        this.availStorage.shutdown();
        this.metricScheduler.stop();
        this.availScheduler.stop();
        if (null != this.pingJob) {
            this.pingJob.cancel(true);
        }
        this.status = ServiceStatus.STOPPED;
    }

    @Override
    public <L> void receivedEvent(InventoryEvent<L> event) {
        List<Resource<L>> added = event.getAddedOrModified();
        List<Resource<L>> removed = event.getRemoved();
        SamplingService<L> service = event.getSamplingService();
        log.debugf("Scheduling jobs for [%d] new resources for endpoint [%s]", added.size(), service.getMonitoredEndpoint());
        this.metricScheduler.schedule(service, added);
        this.availScheduler.schedule(service, added);
        log.debugf("Unscheduling jobs for [%d] obsolete resources for endpoint [%s]", removed.size(), service.getMonitoredEndpoint());
        this.unschedule(service, removed);
    }

    public <L> void unschedule(SamplingService<L> service, Collection<Resource<L>> resources) {
        this.metricScheduler.unschedule(service, resources);
        this.availScheduler.unschedule(service, resources);
    }
}

