/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.util.Map;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.SegmentType;

@ApiModel(description="A relationship between two entities.")
public final class Relationship
extends AbstractElement {
    public static final SegmentType SEGMENT_TYPE = SegmentType.rl;
    private final String id;
    private final String name;
    private final CanonicalPath source;
    private final CanonicalPath target;

    private Relationship() {
        this(null, null, null, null, null);
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitRelationship(this, parameter);
    }

    public Relationship(String id, String name, CanonicalPath source, CanonicalPath target, Map<String, Object> properties) {
        super((CanonicalPath)((CanonicalPath.RelationshipBuilder)CanonicalPath.of().relationship(id)).get(), properties);
        this.id = id;
        this.name = name;
        this.source = source;
        this.target = target;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public CanonicalPath getSource() {
        return this.source;
    }

    public CanonicalPath getTarget() {
        return this.target;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder(this.getClass().getSimpleName());
        bld.append("[id='").append(this.id).append('\'');
        bld.append(", name='").append(this.name).append('\'');
        bld.append(", source=").append(this.source);
        bld.append(" --").append(this.name).append("--> ");
        bld.append(" target=").append(this.target);
        bld.append(']');
        return bld.toString();
    }

    @ApiModel(value="RelationshipBlueprint")
    public static final class Blueprint
    extends AbstractElement.Blueprint {
        private final String name;
        private final Path otherEnd;
        private final Relationships.Direction direction;

        public static Builder builder() {
            return new Builder();
        }

        private Blueprint() {
            this(null, null, null, null);
        }

        public Blueprint(Relationships.Direction direction, String name, Path otherEnd, Map<String, Object> properties) {
            super(properties);
            this.name = name;
            this.otherEnd = otherEnd;
            this.direction = direction == null ? Relationships.Direction.outgoing : direction;
        }

        public String getName() {
            return this.name;
        }

        public Relationships.Direction getDirection() {
            return this.direction;
        }

        public Path getOtherEnd() {
            return this.otherEnd;
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitRelationship(this, parameter);
        }

        public static final class Builder
        extends AbstractElement.Blueprint.Builder<Blueprint, Builder> {
            private String name;
            private Path otherEnd;
            private Relationships.Direction direction = Relationships.Direction.outgoing;

            public Builder withName(String name) {
                this.name = name;
                return this;
            }

            public Builder withOtherEnd(Path path) {
                this.otherEnd = path;
                return this;
            }

            public Builder withDirection(Relationships.Direction direction) {
                this.direction = direction;
                return this;
            }

            @Override
            public Blueprint build() {
                return new Blueprint(this.direction, this.name, this.otherEnd, this.properties);
            }
        }
    }
}

