/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationBuilder;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class LocalCacheBuilder
extends CacheConfigurationBuilder {
    private final InjectedValue<TransactionConfiguration> transaction = new InjectedValue();
    private final InjectedValue<LockingConfiguration> locking = new InjectedValue();
    private final InjectedValue<PersistenceConfiguration> persistence = new InjectedValue();
    private final String containerName;
    private final String cacheName;

    LocalCacheBuilder(String containerName, String cacheName) {
        super(containerName, cacheName);
        this.containerName = containerName;
        this.cacheName = cacheName;
        if (InfinispanLogger.ROOT_LOGGER.isTraceEnabled()) {
            InfinispanLogger.ROOT_LOGGER.tracef("LocalCacheBuilder will be configured for container '%s', cache '%s'", containerName, cacheName);
        }
    }

    @Override
    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        return super.build(target).addDependency(CacheComponent.TRANSACTION.getServiceName(this.containerName, this.cacheName), TransactionConfiguration.class, this.transaction).addDependency(CacheComponent.LOCKING.getServiceName(this.containerName, this.cacheName), LockingConfiguration.class, this.locking).addDependency(CacheComponent.PERSISTENCE.getServiceName(this.containerName, this.cacheName), PersistenceConfiguration.class, this.persistence);
    }

    @Override
    public ConfigurationBuilder createConfigurationBuilder() {
        ConfigurationBuilder builder = super.createConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.LOCAL);
        TransactionConfiguration transaction = (TransactionConfiguration)this.transaction.getValue();
        LockingConfiguration locking = (LockingConfiguration)this.locking.getValue();
        PersistenceConfiguration persistence = (PersistenceConfiguration)this.persistence.getValue();
        boolean simpleCache = !transaction.transactionMode().isTransactional() && !persistence.usingStores();
        builder.simpleCache(simpleCache);
        if (InfinispanLogger.ROOT_LOGGER.isTraceEnabled()) {
            InfinispanLogger.ROOT_LOGGER.tracef("LocalCacheBuilder is creating configuration builder for container '%s', cache '%s', simpleCache '%b'", this.containerName, this.cacheName, simpleCache);
        }
        if (transaction.lockingMode() == LockingMode.OPTIMISTIC && locking.isolationLevel() == IsolationLevel.REPEATABLE_READ) {
            builder.locking().writeSkewCheck(true);
            builder.versioning().enable().scheme(VersioningScheme.SIMPLE);
        }
        return builder;
    }
}

