/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.ctx;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.SunxacmlUtil;
import org.jboss.security.xacml.sunxacml.UnknownIdentifierException;
import org.jboss.security.xacml.sunxacml.attr.AttributeFactory;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.DateTimeAttribute;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute {
    private URI id;
    private URI type;
    private String issuer = null;
    private DateTimeAttribute issueInstant = null;
    private List<AttributeValue> attributeValues = new ArrayList<AttributeValue>();

    public Attribute(URI id, String issuer, DateTimeAttribute issueInstant, AttributeValue value) {
        this.id = id;
        this.issuer = issuer;
        this.issueInstant = issueInstant;
        if (this.attributeValues == null) {
            this.attributeValues = new ArrayList<AttributeValue>();
        }
        this.attributeValues.add(value);
        if (value != null) {
            this.type = value.getType();
        }
    }

    public Attribute(URI id, URI type, String issuer, DateTimeAttribute issueInstant, Set<AttributeValue> values) {
        this.id = id;
        this.type = type;
        this.issuer = issuer;
        this.issueInstant = issueInstant;
        this.attributeValues.addAll(values);
    }

    public Attribute(URI id, URI type, String issuer, DateTimeAttribute issueInstant, List<AttributeValue> values) {
        this.id = id;
        this.type = type;
        this.issuer = issuer;
        this.issueInstant = issueInstant;
        this.attributeValues.addAll(values);
    }

    public Attribute(URI id, URI type, String issuer, DateTimeAttribute issueInstant, AttributeValue value) {
        this(id, issuer, issueInstant, value);
        this.type = type;
    }

    public static Attribute getInstance(Node root) throws ParsingException {
        URI id = null;
        URI type = null;
        String issuer = null;
        DateTimeAttribute issueInstant = null;
        AttributeValue value = null;
        HashSet<AttributeValue> valueSet = null;
        AttributeFactory attrFactory = AttributeFactory.getInstance();
        if (!SunxacmlUtil.getNodeName(root).equals("Attribute")) {
            throw new ParsingException("Attribute object cannot be created with root node of type: " + SunxacmlUtil.getNodeName(root));
        }
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute AttributeId in AttributeType", e);
        }
        try {
            type = new URI(attrs.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute DataType in AttributeType", e);
        }
        try {
            Node instantNode;
            Node issuerNode = attrs.getNamedItem("Issuer");
            if (issuerNode != null) {
                issuer = issuerNode.getNodeValue();
            }
            if ((instantNode = attrs.getNamedItem("IssueInstant")) != null) {
                issueInstant = DateTimeAttribute.getInstance(instantNode.getNodeValue());
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing optional AttributeType attribute", e);
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!SunxacmlUtil.getNodeName(node).equals("AttributeValue")) continue;
            try {
                value = attrFactory.createValue(node, type);
            }
            catch (UnknownIdentifierException uie) {
                throw new ParsingException("Unknown AttributeId", uie);
            }
            if (valueSet == null) {
                valueSet = new HashSet<AttributeValue>();
            }
            valueSet.add(value);
        }
        if (value == null) {
            throw new ParsingException("Attribute must contain a value");
        }
        return new Attribute(id, type, issuer, issueInstant, valueSet);
    }

    public URI getId() {
        return this.id;
    }

    public URI getType() {
        return this.type;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public DateTimeAttribute getIssueInstant() {
        return this.issueInstant;
    }

    public List<AttributeValue> getValues() {
        return this.attributeValues;
    }

    public AttributeValue getValue() {
        if (this.attributeValues != null) {
            return this.attributeValues.iterator().next();
        }
        return null;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        String indent = indenter.makeString();
        PrintStream out = new PrintStream(output);
        out.println(indent + this.encode());
    }

    public String encode() {
        String encoded = "<Attribute AttributeId=\"" + this.id.toString() + "\" " + "DataType=\"" + this.type.toString() + "\"";
        if (this.issuer != null) {
            encoded = encoded + " Issuer=\"" + this.issuer + "\"";
        }
        if (this.issueInstant != null) {
            encoded = encoded + " IssueInstant=\"" + this.issueInstant.encode() + "\"";
        }
        encoded = encoded + ">";
        if (this.attributeValues != null) {
            for (AttributeValue value : this.attributeValues) {
                encoded = encoded + value.encodeWithTags(false);
            }
        }
        encoded = encoded + "</Attribute>";
        return encoded;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeValues == null ? 0 : ((Object)this.attributeValues).hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.issueInstant == null ? 0 : this.issueInstant.hashCode());
        result = 31 * result + (this.issuer == null ? 0 : this.issuer.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (this.attributeValues == null ? other.attributeValues != null : !((Object)this.attributeValues).equals(other.attributeValues)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.issueInstant == null ? other.issueInstant != null : !this.issueInstant.equals(other.issueInstant)) {
            return false;
        }
        if (this.issuer == null ? other.issuer != null : !this.issuer.equals(other.issuer)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

