/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner.logging;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import org.jboss.as.server.deployment.scanner.logging.DeploymentScannerLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class DeploymentScannerLogger_$logger
extends DelegatingBasicLogger
implements DeploymentScannerLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = DeploymentScannerLogger_$logger.class.getName();
    private static final String cannotDeleteDeploymentProgressMarker = "WFLYDS0001: Cannot delete deployment progress marker file %s";
    private static final String cannotRemoveDeploymentMarker = "WFLYDS0002: Cannot remove extraneous deployment marker file %s";
    private static final String deploymentNotFound = "WFLYDS0003: Deployment of '%s' requested, but the deployment is not present";
    private static final String deploymentTriggered = "WFLYDS0004: Found %1$s in deployment directory. To trigger deployment create a file called %1$s%2$s";
    private static final String errorWritingDeploymentMarker = "WFLYDS0005: Caught exception writing deployment marker file %s";
    private static final String explodedAutoDeploymentContentWarning = "WFLYDS0006: Reliable deployment behaviour is not possible when auto-deployment of exploded content is enabled (i.e. deployment without use of \"%s\"' marker files). Configuration of auto-deployment of exploded content is not recommended in any situation where reliability is desired. Configuring the deployment scanner's %s setting to \"false\" is recommended.";
    private static final String explodedDeploymentContentDeleted = "WFLYDS0007: The deployment scanner found that the content for exploded deployment %1$s has been deleted, but auto-deploy/undeploy for exploded deployments is not enabled and the %1$s%2$s marker file for this deployment has not been removed. As a result, the deployment is not being undeployed, but resources needed by the deployment may have been deleted and application errors may occur. Deleting the %1$s%2$s marker file to trigger undeploy is recommended.";
    private static final String failedCheckingZipFile = "WFLYDS0008: Failed checking whether %s was a complete zip";
    private static final String fileSystemDeploymentFailed = "WFLYDS0009: File system deployment service failed";
    private static final String incompleteContent = "WFLYDS0010: Scan found incompletely copied file content for deployment %s. Deployment changes will not be processed until all content is complete.";
    private static final String invalidExplodedDeploymentDirectory = "WFLYDS0011: The deployment scanner found a directory named %1$s that was not inside a directory whose name ends with .ear, .jar, .rar, .sar or .war. This is likely the result of unzipping an archive directly inside the %2$s directory, which is a user error. The %1$s directory will not be scanned for deployments, but it is possible that the scanner may find other files from the unzipped archive and attempt to deploy them, leading to errors.";
    private static final String scanException = "WFLYDS0012: Scan of %s threw Exception";
    private static final String started = "WFLYDS0013: Started %s for directory %s";
    private static final String unsafeAutoDeploy = "WFLYDS0014: Scan found content configured for auto-deploy that could not be safely auto-deployed. See details above. Deployment changes will not be processed until all problematic content is either removed or whether to deploy the content or not is indicated via a %s or %s marker file. Problematic deployments are %s";
    private static final String reattemptingFailedDeployment = "WFLYDS0015: Re-attempting failed deployment %s";
    private static final String failedCheckingXMLFile = "WFLYDS0016: Failed checking whether %s was a complete XML";
    private static final String initialScanFailed = "WFLYDS0017: Initial deployment scan failed";
    private static final String scannerDeploymentUndeployedButNotByScanner = "WFLYDS0018: Deployment %s was previously deployed by this scanner but has been undeployed by another management tool. Marker file %s is being added to record this fact.";
    private static final String scannerDeploymentRemovedButNotByScanner = "WFLYDS0019: Deployment %s was previously deployed by this scanner but has been removed from the server deployment list by another management tool. Marker file %s is being added to record this fact.";
    private static final String cannotRemoveSubsystem = "WFLYDS0020: Cannot remove subsystem while it still has scanners configured. Remove all scanners first.";
    private static final String deploymentContentIncomplete = "WFLYDS0021: Deployment content %s appears to be incomplete and is not progressing toward completion. This content cannot be auto-deployed.%s";
    private static final String deploymentTimeout = "WFLYDS0022: Did not receive a response to the deployment operation within the allowed timeout period [%d seconds]. Check the server configuration file and the server logs to find more about the status of the deployment.";
    private static final String directoryDoesNotExist = "WFLYDS0023: %s does not exist";
    private static final String directoryNotWritable = "WFLYDS0024: %s is not writable";
    private static final String invalidZipFileFormat = "WFLYDS0025: File %s cannot be scanned because it does not begin with a ZIP file format local file header signature";
    private static final String invalidZip64FileFormat = "WFLYDS0026: File %s cannot be scanned because it uses the currently unsupported ZIP64 format";
    private static final String notADirectory = "WFLYDS0027: %s is not a directory";
    private static final String nullVar = "WFLYDS0028: %s is null";
    private static final String previousContentDeployed = " A previous version of this content was deployed and remains deployed.";
    private static final String scannerNotConfigured = "WFLYDS0029: scanner not configured";
    private static final String unsafeAutoDeploy2 = "WFLYDS0030: File %2$s was configured for auto-deploy but could not be safely auto-deployed. The reason the file could not be auto-deployed was: %1$s.  To enable deployment of this file create a file called %2$s%3$s";
    private static final String deploymentScannerNotForDomainMode = "WFLYDS0031: Extension with module 'org.jboss.as.deployment-scanner' cannot be installed in a managed domain. Please remove it and any subsystem referencing it";
    private static final String cannotListDirectoryFiles = "WFLYDS0032: Failed to list files in directory %s. Check that the contents of the directory are readable.";
    private static final String scannerDeploymentRedeployedButNotByScanner = "WFLYDS0033: Deployment %s was previously undeployed by this scanner but has been redeployed by another management tool. Marker file %s is being removed to record this fact.";
    private static final String failedStatusSynchronization = "WFLYDS0034: Failed synchronizing status of deployment %s.";
    private static final String invalidXmlFileFound = "WFLYDS0035: Scan found %s which is not well-formed at lineNumber: %s, columnNumber: %s. Either the file was incompletely copied at the time of the scanning or it is just wrong.";
    private static final String deployModelOperationFailed = "WFLYDS0036: Deployment model operation failed. %s";

    public DeploymentScannerLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void cannotDeleteDeploymentProgressMarker(File file) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotDeleteDeploymentProgressMarker$str(), (Object)file);
    }

    protected String cannotDeleteDeploymentProgressMarker$str() {
        return cannotDeleteDeploymentProgressMarker;
    }

    @Override
    public final void cannotRemoveDeploymentMarker(String fileName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotRemoveDeploymentMarker$str(), (Object)fileName);
    }

    protected String cannotRemoveDeploymentMarker$str() {
        return cannotRemoveDeploymentMarker;
    }

    @Override
    public final void cannotRemoveDeploymentMarker(File file) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotRemoveDeploymentMarker$str(), (Object)file);
    }

    @Override
    public final void deploymentNotFound(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.deploymentNotFound$str(), (Object)deploymentName);
    }

    protected String deploymentNotFound$str() {
        return deploymentNotFound;
    }

    @Override
    public final void deploymentTriggered(String fileName, String marker) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.deploymentTriggered$str(), (Object)fileName, (Object)marker);
    }

    protected String deploymentTriggered$str() {
        return deploymentTriggered;
    }

    @Override
    public final void errorWritingDeploymentMarker(Throwable cause, String markerFile) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorWritingDeploymentMarker$str(), (Object)markerFile);
    }

    protected String errorWritingDeploymentMarker$str() {
        return errorWritingDeploymentMarker;
    }

    @Override
    public final void explodedAutoDeploymentContentWarning(String marker, String elementName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.explodedAutoDeploymentContentWarning$str(), (Object)marker, (Object)elementName);
    }

    protected String explodedAutoDeploymentContentWarning$str() {
        return explodedAutoDeploymentContentWarning;
    }

    @Override
    public final void explodedDeploymentContentDeleted(String fileName, String marker) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.explodedDeploymentContentDeleted$str(), (Object)fileName, (Object)marker);
    }

    protected String explodedDeploymentContentDeleted$str() {
        return explodedDeploymentContentDeleted;
    }

    @Override
    public final void failedCheckingZipFile(Throwable cause, String fileName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedCheckingZipFile$str(), (Object)fileName);
    }

    protected String failedCheckingZipFile$str() {
        return failedCheckingZipFile;
    }

    @Override
    public final void fileSystemDeploymentFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.fileSystemDeploymentFailed$str(), new Object[0]);
    }

    protected String fileSystemDeploymentFailed$str() {
        return fileSystemDeploymentFailed;
    }

    @Override
    public final void incompleteContent(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.incompleteContent$str(), (Object)name);
    }

    protected String incompleteContent$str() {
        return incompleteContent;
    }

    @Override
    public final void invalidExplodedDeploymentDirectory(String fileName, String deploymentDir) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.invalidExplodedDeploymentDirectory$str(), (Object)fileName, (Object)deploymentDir);
    }

    protected String invalidExplodedDeploymentDirectory$str() {
        return invalidExplodedDeploymentDirectory;
    }

    @Override
    public final void scanException(Throwable cause, String fileName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.scanException$str(), (Object)fileName);
    }

    protected String scanException$str() {
        return scanException;
    }

    @Override
    public final void started(String className, String deploymentPath) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.started$str(), (Object)className, (Object)deploymentPath);
    }

    protected String started$str() {
        return started;
    }

    @Override
    public final void unsafeAutoDeploy(String marker1, String marker2, Set<String> problems) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsafeAutoDeploy$str(), (Object)marker1, (Object)marker2, problems);
    }

    protected String unsafeAutoDeploy$str() {
        return unsafeAutoDeploy;
    }

    @Override
    public final void reattemptingFailedDeployment(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.reattemptingFailedDeployment$str(), (Object)deploymentName);
    }

    protected String reattemptingFailedDeployment$str() {
        return reattemptingFailedDeployment;
    }

    @Override
    public final void failedCheckingXMLFile(Throwable cause, String fileName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedCheckingXMLFile$str(), (Object)fileName);
    }

    protected String failedCheckingXMLFile$str() {
        return failedCheckingXMLFile;
    }

    @Override
    public final void initialScanFailed(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.initialScanFailed$str(), new Object[0]);
    }

    protected String initialScanFailed$str() {
        return initialScanFailed;
    }

    @Override
    public final void scannerDeploymentUndeployedButNotByScanner(String deploymentName, File marker) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.scannerDeploymentUndeployedButNotByScanner$str(), (Object)deploymentName, (Object)marker);
    }

    protected String scannerDeploymentUndeployedButNotByScanner$str() {
        return scannerDeploymentUndeployedButNotByScanner;
    }

    @Override
    public final void scannerDeploymentRemovedButNotByScanner(String deploymentName, File marker) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.scannerDeploymentRemovedButNotByScanner$str(), (Object)deploymentName, (Object)marker);
    }

    protected String scannerDeploymentRemovedButNotByScanner$str() {
        return scannerDeploymentRemovedButNotByScanner;
    }

    protected String cannotRemoveSubsystem$str() {
        return cannotRemoveSubsystem;
    }

    @Override
    public final String cannotRemoveSubsystem() {
        return String.format(this.cannotRemoveSubsystem$str(), new Object[0]);
    }

    protected String deploymentContentIncomplete$str() {
        return deploymentContentIncomplete;
    }

    @Override
    public final String deploymentContentIncomplete(File file, String suffix) {
        return String.format(this.deploymentContentIncomplete$str(), file, suffix);
    }

    protected String deploymentTimeout$str() {
        return deploymentTimeout;
    }

    @Override
    public final String deploymentTimeout(long timeout) {
        return String.format(this.deploymentTimeout$str(), timeout);
    }

    protected String directoryDoesNotExist$str() {
        return directoryDoesNotExist;
    }

    @Override
    public final IllegalArgumentException directoryDoesNotExist(String path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.directoryDoesNotExist$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String directoryNotWritable$str() {
        return directoryNotWritable;
    }

    @Override
    public final IllegalArgumentException directoryNotWritable(String path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.directoryNotWritable$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidZipFileFormat$str() {
        return invalidZipFileFormat;
    }

    @Override
    public final String invalidZipFileFormat(String fileName) {
        return String.format(this.invalidZipFileFormat$str(), fileName);
    }

    protected String invalidZip64FileFormat$str() {
        return invalidZip64FileFormat;
    }

    @Override
    public final String invalidZip64FileFormat(String fileName) {
        return String.format(this.invalidZip64FileFormat$str(), fileName);
    }

    protected String notADirectory$str() {
        return notADirectory;
    }

    @Override
    public final IllegalArgumentException notADirectory(String path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.notADirectory$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullVar$str() {
        return nullVar;
    }

    @Override
    public final IllegalArgumentException nullVar(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.nullVar$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String previousContentDeployed$str() {
        return previousContentDeployed;
    }

    @Override
    public final String previousContentDeployed() {
        return String.format(this.previousContentDeployed$str(), new Object[0]);
    }

    protected String scannerNotConfigured$str() {
        return scannerNotConfigured;
    }

    @Override
    public final String scannerNotConfigured() {
        return String.format(this.scannerNotConfigured$str(), new Object[0]);
    }

    protected String unsafeAutoDeploy2$str() {
        return unsafeAutoDeploy2;
    }

    @Override
    public final String unsafeAutoDeploy2(String errorMsg, String fileName, String marker) {
        return String.format(this.unsafeAutoDeploy2$str(), errorMsg, fileName, marker);
    }

    protected String deploymentScannerNotForDomainMode$str() {
        return deploymentScannerNotForDomainMode;
    }

    @Override
    public final IllegalStateException deploymentScannerNotForDomainMode() {
        IllegalStateException result = new IllegalStateException(String.format(this.deploymentScannerNotForDomainMode$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotListDirectoryFiles$str() {
        return cannotListDirectoryFiles;
    }

    @Override
    public final RuntimeException cannotListDirectoryFiles(File directory) {
        RuntimeException result = new RuntimeException(String.format(this.cannotListDirectoryFiles$str(), directory));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void scannerDeploymentRedeployedButNotByScanner(String deploymentName, File marker) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.scannerDeploymentRedeployedButNotByScanner$str(), (Object)deploymentName, (Object)marker);
    }

    protected String scannerDeploymentRedeployedButNotByScanner$str() {
        return scannerDeploymentRedeployedButNotByScanner;
    }

    @Override
    public final void failedStatusSynchronization(Throwable cause, String deploymentName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedStatusSynchronization$str(), (Object)deploymentName);
    }

    protected String failedStatusSynchronization$str() {
        return failedStatusSynchronization;
    }

    @Override
    public final void invalidXmlFileFound(String name, int lineNumber, int columnNumber) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.invalidXmlFileFound$str(), (Object)name, (Object)lineNumber, (Object)columnNumber);
    }

    protected String invalidXmlFileFound$str() {
        return invalidXmlFileFound;
    }

    protected String deployModelOperationFailed$str() {
        return deployModelOperationFailed;
    }

    @Override
    public final RuntimeException deployModelOperationFailed(String msg) {
        RuntimeException result = new RuntimeException(String.format(this.deployModelOperationFailed$str(), msg));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

