/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Pair;
import org.jboss.marshalling.Unmarshaller;

public class ChainingClassTable
implements ClassTable {
    private final List<Pair<ClassTable, ClassTable.Writer>> writers;
    private final ClassTable[] readers;

    private static Pair<ClassTable, ClassTable.Writer> pair(ClassTable classTable, ClassTable.Writer writer) {
        return Pair.create(classTable, writer);
    }

    public ChainingClassTable(ClassTable[] classTables) {
        if (classTables == null) {
            throw new NullPointerException("classTables is null");
        }
        this.readers = (ClassTable[])classTables.clone();
        if (this.readers.length > 256) {
            throw new IllegalArgumentException("Class table array is too long (limit is 256 elements)");
        }
        this.writers = new ArrayList<Pair<ClassTable, ClassTable.Writer>>();
        for (int i = 0; i < this.readers.length; ++i) {
            final ClassTable classTable = this.readers[i];
            if (classTable == null) continue;
            final int idx = i;
            this.writers.add(ChainingClassTable.pair(classTable, new ClassTable.Writer(){

                @Override
                public void writeClass(Marshaller marshaller, Class<?> clazz) throws IOException {
                    marshaller.writeByte(idx);
                    classTable.getClassWriter(clazz).writeClass(marshaller, clazz);
                }
            }));
        }
    }

    @Override
    public ClassTable.Writer getClassWriter(Class<?> clazz) throws IOException {
        for (Pair<ClassTable, ClassTable.Writer> entry : this.writers) {
            ClassTable table = entry.getA();
            ClassTable.Writer writer = entry.getB();
            if (table.getClassWriter(clazz) == null) continue;
            return writer;
        }
        return null;
    }

    @Override
    public Class<?> readClass(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int v = unmarshaller.readByte() & 0xFF;
        ClassTable table = this.readers[v];
        if (table == null) {
            throw new StreamCorruptedException(String.format("Unknown class table ID %02x encountered", v));
        }
        return table.readClass(unmarshaller);
    }
}

