/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.cursor.PageCache;
import org.apache.activemq.artemis.core.paging.impl.Page;

class PageCacheImpl
implements PageCache {
    private PagedMessage[] messages;
    private final Page page;

    public PageCacheImpl(Page page) {
        this.page = page;
    }

    @Override
    public PagedMessage getMessage(int messageNumber) {
        if (messageNumber < this.messages.length) {
            return this.messages[messageNumber];
        }
        return null;
    }

    @Override
    public long getPageId() {
        return this.page.getPageId();
    }

    @Override
    public void setMessages(PagedMessage[] messages) {
        this.messages = messages;
    }

    @Override
    public int getNumberOfMessages() {
        return this.messages.length;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isLive() {
        return false;
    }

    public String toString() {
        return "PageCacheImpl::page=" + this.page.getPageId() + " numberOfMessages = " + this.messages.length;
    }

    @Override
    public PagedMessage[] getMessages() {
        return this.messages;
    }
}

