/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class InventoryStringDataPoint
implements Serializable {
    private static final String KEY_NBCHUNKS = "chunks";
    private static final String KEY_SIZE = "size";
    @JsonProperty(value="timestamp")
    private final long timestamp;
    @JsonProperty(value="value")
    private final byte[] inventoryStructure;
    @JsonProperty(value="tags")
    private final Map<String, String> tags;

    @JsonCreator
    public InventoryStringDataPoint(@JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="value") byte[] inventoryStructure, @JsonProperty(value="tags") Map<String, String> tags) {
        this.timestamp = timestamp;
        this.inventoryStructure = inventoryStructure;
        this.tags = tags;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte[] getInventoryStructure() {
        return this.inventoryStructure;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public static InventoryStringDataPoint create(long timestamp, byte[] inventoryStructure) {
        return new InventoryStringDataPoint(timestamp, inventoryStructure, new HashMap<String, String>());
    }

    public void setMasterInfo(int nbChunks, int totalSize) {
        this.tags.put(KEY_NBCHUNKS, String.valueOf(nbChunks));
        this.tags.put(KEY_SIZE, String.valueOf(totalSize));
    }

    public Optional<String> getNbChunks() {
        return Optional.ofNullable(this.tags.get(KEY_NBCHUNKS));
    }
}

