/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import java.util.Map;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.api.AvailEvent;
import org.hawkular.agent.monitor.api.AvailListener;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.InventoryListener;
import org.hawkular.agent.monitor.api.NotificationPayloadBuilder;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.storage.StorageAdapter;
import org.hawkular.client.api.NotificationType;
import org.hawkular.inventory.paths.CanonicalPath;

public class NotificationDispatcher
implements InventoryListener,
AvailListener {
    private static final MsgLogger log = AgentLoggers.getLogger(NotificationDispatcher.class);
    StorageAdapter storageAdapter;
    String feedId;

    public NotificationDispatcher(StorageAdapter storageAdapter, String feedId) {
        this.storageAdapter = storageAdapter;
        this.feedId = feedId;
    }

    @Override
    public <L> void receivedEvent(InventoryEvent<L> event) {
        MonitoredEndpoint<AgentCoreEngineConfiguration.EndpointConfiguration> endpoint = event.getSamplingService().getMonitoredEndpoint();
        String endpointTenantId = endpoint.getEndpointConfiguration().getTenantId();
        String tenantId = null != endpointTenantId ? endpointTenantId : this.storageAdapter.getStorageAdapterConfiguration().getTenantId();
        event.getAddedOrModified().stream().filter(r -> r.getResourceType().getNotifications().contains(NotificationType.RESOURCE_ADDED)).forEach(r -> {
            CanonicalPath cp = (CanonicalPath)((CanonicalPath.ResourceBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).feed(this.feedId)).resource(r.getID().getIDString())).get();
            try {
                NotificationPayloadBuilder b = this.storageAdapter.createNotificationPayloadBuilder();
                b.addNotificationType(NotificationType.RESOURCE_ADDED);
                b.addProperty("resourceType", r.getResourceType().getName().getNameString());
                b.addProperty("resourcePath", cp.toString());
                this.storageAdapter.store(b, 0L);
            }
            catch (Exception e) {
                log.errorFailedToCreateNotification(e, NotificationType.RESOURCE_ADDED.name());
            }
        });
    }

    @Override
    public <L> void receivedEvent(AvailEvent<L> event) {
        MonitoredEndpoint<AgentCoreEngineConfiguration.EndpointConfiguration> endpoint = event.getSamplingService().getMonitoredEndpoint();
        String endpointTenantId = endpoint.getEndpointConfiguration().getTenantId();
        String tenantId = null != endpointTenantId ? endpointTenantId : this.storageAdapter.getStorageAdapterConfiguration().getTenantId();
        this.processAvailEvents(event.getChanged(), NotificationType.AVAIL_CHANGE, tenantId);
        this.processAvailEvents(event.getStarted(), NotificationType.AVAIL_STARTING, tenantId);
    }

    private <L> void processAvailEvents(Map<MeasurementInstance<L, AvailType<L>>, Avail> avails, NotificationType notificationType, String tenantId) {
        avails.keySet().stream().filter(mi -> mi.getResource().getResourceType().getNotifications().contains(notificationType)).forEach(mi -> {
            CanonicalPath cp = (CanonicalPath)((CanonicalPath.ResourceBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).feed(this.feedId)).resource(mi.getResource().getID().getIDString())).get();
            try {
                NotificationPayloadBuilder b = this.storageAdapter.createNotificationPayloadBuilder();
                b.addNotificationType(notificationType);
                b.addProperty("resourceType", mi.getResource().getResourceType().getName().getNameString());
                b.addProperty("resourcePath", cp.toString());
                b.addProperty("availType", ((AvailType)mi.getType()).getName().getNameString());
                b.addProperty("newAvail", ((Avail)((Object)((Object)avails.get(mi)))).name());
                this.storageAdapter.store(b, 0L);
            }
            catch (Exception e) {
                log.errorFailedToCreateNotification(e, notificationType.name());
            }
        });
    }
}

