/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrame;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.core.function.ChannelFunction;
import io.undertow.websockets.core.function.ChannelFunctionFileChannel;
import io.undertow.websockets.core.protocol.version07.Masker;
import io.undertow.websockets.core.protocol.version07.UTF8Checker;
import io.undertow.websockets.extensions.ExtensionFunction;
import io.undertow.websockets.extensions.NoopExtensionFunction;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.xnio.channels.StreamSinkChannel;

public abstract class StreamSourceFrameChannel
extends AbstractFramedStreamSourceChannel<WebSocketChannel, StreamSourceFrameChannel, StreamSinkFrameChannel> {
    protected final WebSocketFrameType type;
    private boolean finalFragment;
    private final int rsv;
    private final ChannelFunction[] functions;
    private final ExtensionFunction extensionFunction;
    private Masker masker;
    private UTF8Checker checker;

    protected StreamSourceFrameChannel(WebSocketChannel wsChannel, WebSocketFrameType type, PooledByteBuffer pooled, long frameLength) {
        this(wsChannel, type, 0, true, pooled, frameLength, null, new ChannelFunction[0]);
    }

    protected StreamSourceFrameChannel(WebSocketChannel wsChannel, WebSocketFrameType type, int rsv, boolean finalFragment, PooledByteBuffer pooled, long frameLength, Masker masker, ChannelFunction ... functions) {
        super(wsChannel, pooled, frameLength);
        this.type = type;
        this.finalFragment = finalFragment;
        this.rsv = rsv;
        this.functions = functions;
        this.masker = masker;
        this.checker = null;
        for (ChannelFunction func : functions) {
            if (!(func instanceof UTF8Checker)) continue;
            this.checker = (UTF8Checker)func;
        }
        this.extensionFunction = rsv > 0 ? wsChannel.getExtensionFunction() : NoopExtensionFunction.instance;
    }

    public WebSocketFrameType getType() {
        return this.type;
    }

    public boolean isFinalFragment() {
        return this.finalFragment;
    }

    public int getRsv() {
        return this.rsv;
    }

    int getWebSocketFrameCount() {
        return this.getReadFrameCount();
    }

    @Override
    protected WebSocketChannel getFramedChannel() {
        return (WebSocketChannel)super.getFramedChannel();
    }

    public WebSocketChannel getWebSocketChannel() {
        return this.getFramedChannel();
    }

    public void finalFrame() {
        this.lastFrame();
        this.finalFragment = true;
    }

    @Override
    protected void handleHeaderData(FrameHeaderData headerData) {
        super.handleHeaderData(headerData);
        if (((WebSocketFrame)headerData).isFinalFragment()) {
            this.finalFrame();
        }
        if (this.masker != null) {
            this.masker.newFrame(headerData);
        }
        if (this.functions != null) {
            for (ChannelFunction func : this.functions) {
                func.newFrame(headerData);
            }
        }
    }

    @Override
    public final long transferTo(long position, long count, FileChannel target) throws IOException {
        long r = this.functions != null && this.functions.length > 0 ? super.transferTo(position, count, new ChannelFunctionFileChannel(target, this.functions)) : super.transferTo(position, count, target);
        return r;
    }

    @Override
    public final long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return WebSocketUtils.transfer((ReadableByteChannel)((Object)this), count, throughBuffer, (WritableByteChannel)target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int position = dst.position();
        int r = super.read(dst);
        if (r > 0) {
            this.checker(dst, position, dst.position() - position, false);
        } else if (r == -1) {
            this.checkComplete();
        }
        return r;
    }

    @Override
    public final long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        Bounds[] old = new Bounds[length];
        for (int i = offset; i < length; ++i) {
            ByteBuffer dst = dsts[i];
            old[i - offset] = new Bounds(dst.position(), dst.limit());
        }
        long b = super.read(dsts, offset, length);
        if (b > 0L) {
            for (int i = offset; i < length; ++i) {
                ByteBuffer dst = dsts[i];
                int oldPos = old[i - offset].position;
                this.afterRead(dst, oldPos, dst.position() - oldPos);
            }
        } else if (b == -1L) {
            this.checkComplete();
        }
        return b;
    }

    private void checkComplete() throws IOException {
        try {
            for (ChannelFunction func : this.functions) {
                func.complete();
            }
        }
        catch (UnsupportedEncodingException e) {
            this.getFramedChannel().markReadsBroken(e);
            throw e;
        }
    }

    protected void afterRead(ByteBuffer buffer, int position, int length) throws IOException {
        try {
            for (ChannelFunction func : this.functions) {
                func.afterRead(buffer, position, length);
            }
            if (this.isComplete()) {
                this.checkComplete();
            }
        }
        catch (UnsupportedEncodingException e) {
            this.getFramedChannel().markReadsBroken(e);
            throw e;
        }
    }

    protected void checker(ByteBuffer buffer, int position, int length, boolean complete) throws IOException {
        block5: {
            if (this.checker == null) {
                return;
            }
            try {
                this.checker.afterRead(buffer, position, length);
                if (!complete) break block5;
                try {
                    this.checker.complete();
                }
                catch (UnsupportedEncodingException e) {
                    this.getFramedChannel().markReadsBroken(e);
                    throw e;
                }
            }
            catch (UnsupportedEncodingException e) {
                this.getFramedChannel().markReadsBroken(e);
                throw e;
            }
        }
    }

    @Override
    protected PooledByteBuffer processFrameData(PooledByteBuffer frameData, boolean lastFragmentOfFrame) throws IOException {
        if (this.masker != null) {
            this.masker.afterRead(frameData.getBuffer(), frameData.getBuffer().position(), frameData.getBuffer().remaining());
        }
        return this.extensionFunction.transformForRead(frameData, this.getWebSocketChannel(), lastFragmentOfFrame);
    }

    private static class Bounds {
        final int position;
        final int limit;

        Bounds(int position, int limit) {
            this.position = position;
            this.limit = limit;
        }
    }
}

