/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.client.common.http;

import java.util.Map;
import java.util.function.BiFunction;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public final class HawkularJson {
    private HawkularJson() {
    }

    public static String metricsToString(Long timestamp, Map<String, Long> counters, Map<String, Double> gauges) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (!counters.isEmpty()) {
            builder.add("counters", (JsonValue)HawkularJson.metricsJson(timestamp, counters, HawkularJson::longDataPoint));
        }
        if (!gauges.isEmpty()) {
            builder.add("gauges", (JsonValue)HawkularJson.metricsJson(timestamp, gauges, HawkularJson::doubleDataPoint));
        }
        return builder.build().toString();
    }

    public static String tagsToString(Map<String, String> tags) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        tags.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)jsonObjectBuilder).add(arg_0, arg_1));
        return jsonObjectBuilder.build().toString();
    }

    private static <T> JsonArray metricsJson(Long timestamp, Map<String, T> metricsPoints, BiFunction<Long, T, JsonObject> bf) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        metricsPoints.entrySet().stream().map(e -> HawkularJson.metricJson((String)e.getKey(), (JsonObject)bf.apply(timestamp, e.getValue()))).forEach(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
        return builder.build();
    }

    private static JsonObject metricJson(String name, JsonObject dataPoint) {
        return Json.createObjectBuilder().add("id", name).add("dataPoints", (JsonValue)Json.createArrayBuilder().add((JsonValue)dataPoint).build()).build();
    }

    private static JsonObject doubleDataPoint(long timestamp, double value) {
        return Json.createObjectBuilder().add("timestamp", timestamp).add("value", value).build();
    }

    private static JsonObject longDataPoint(long timestamp, long value) {
        return Json.createObjectBuilder().add("timestamp", timestamp).add("value", value).build();
    }
}

