/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.xml.security.algorithms.JCEMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KeyUtils.class);
    private static final int MAX_SYMMETRIC_KEY_SIZE = 1024;
    private static MessageDigest digest;

    private KeyUtils() {
    }

    public static int getKeyLength(String algorithm) throws WSSecurityException {
        return JCEMapper.getKeyLengthFromURI((String)algorithm) / 8;
    }

    public static SecretKey prepareSecretKey(String algorithm, byte[] rawKey) {
        int size;
        block2: {
            size = 0;
            try {
                size = KeyUtils.getKeyLength(algorithm);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug(e.getMessage());
            }
        }
        String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithm);
        SecretKeySpec keySpec = size > 0 && !algorithm.endsWith("gcm") && !algorithm.contains("hmac-") ? new SecretKeySpec(rawKey, 0, rawKey.length > size ? size : rawKey.length, keyAlgorithm) : (rawKey.length > 1024 ? new SecretKeySpec(rawKey, 0, 1024, keyAlgorithm) : new SecretKeySpec(rawKey, keyAlgorithm));
        return keySpec;
    }

    public static KeyGenerator getKeyGenerator(String algorithm) throws WSSecurityException {
        try {
            String keyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithm);
            if (keyAlgorithm == null || "".equals(keyAlgorithm)) {
                keyAlgorithm = JCEMapper.translateURItoJCEID((String)algorithm);
            }
            KeyGenerator keyGen = KeyGenerator.getInstance(keyAlgorithm);
            if (algorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || algorithm.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes128-gcm")) {
                keyGen.init(128);
            } else if (algorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || algorithm.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes192-gcm")) {
                keyGen.init(192);
            } else if (algorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc") || algorithm.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes256-gcm")) {
                keyGen.init(256);
            }
            return keyGen;
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, e);
        }
    }

    public static Cipher getCipherInstance(String cipherAlgo) throws WSSecurityException {
        try {
            String keyAlgorithm = JCEMapper.translateURItoJCEID((String)cipherAlgo);
            String provider = JCEMapper.getProviderId();
            if (provider == null) {
                return Cipher.getInstance(keyAlgorithm);
            }
            return Cipher.getInstance(keyAlgorithm, provider);
        }
        catch (NoSuchPaddingException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, ex, "unsupportedKeyTransp", new Object[]{"No such padding: " + cipherAlgo});
        }
        catch (NoSuchAlgorithmException ex) {
            if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(cipherAlgo)) {
                try {
                    return Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
                }
                catch (Exception e) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, e, "unsupportedKeyTransp", new Object[]{"No such algorithm: " + cipherAlgo});
                }
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, ex, "unsupportedKeyTransp", new Object[]{"No such algorithm: " + cipherAlgo});
        }
        catch (NoSuchProviderException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, ex, "unsupportedKeyTransp", new Object[]{"No such provider " + JCEMapper.getProviderId() + " for: " + cipherAlgo});
        }
    }

    public static synchronized byte[] generateDigest(byte[] inputBytes) throws WSSecurityException {
        try {
            if (digest == null) {
                digest = MessageDigest.getInstance("SHA-1");
            }
            return digest.digest(inputBytes);
        }
        catch (Exception e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "empty", new Object[]{"Error in generating digest"});
        }
    }
}

