/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.module.installer;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hawkular.wildfly.module.installer.ConfigType;
import org.hawkular.wildfly.module.installer.XmlEdit;

class RegisterModuleConfiguration {
    private File targetServerConfig;
    private File sourceServerConfig;
    private URL subsystem;
    private URL socketBinding;
    private Set<String> socketBindingGroups;
    private List<XmlEdit> xmlEdits;
    private String moduleId;
    private ConfigType configType = null;
    private Set<String> profiles;
    private boolean failNoMatch;

    public String toString() {
        return "RegisterOptions: [" + ("\n  serverConfig = " + this.targetServerConfig) + ("\n  configType = " + (Object)((Object)this.configType)) + ("\n  serverConfigBackup = " + this.sourceServerConfig) + ("\n  moduleId = " + this.moduleId) + ("\n  subsystem = " + this.subsystem) + ("\n  socket-binding = " + this.socketBinding) + ("\n  socketBindingGroups = " + (this.socketBindingGroups == null ? "null" : Arrays.toString(this.socketBindingGroups.toArray()))) + ("\n  edit = " + (this.xmlEdits == null ? "null" : Arrays.toString(this.xmlEdits.toArray()))) + ("\n  failNoMatch = " + this.failNoMatch) + "\n]";
    }

    public RegisterModuleConfiguration extend(RegisterModuleConfiguration configuration) {
        this.targetServerConfig = configuration.targetServerConfig == null ? this.targetServerConfig : configuration.targetServerConfig;
        this.sourceServerConfig = configuration.sourceServerConfig == null ? this.sourceServerConfig : configuration.sourceServerConfig;
        this.subsystem = configuration.subsystem == null ? this.subsystem : configuration.subsystem;
        this.socketBinding = configuration.socketBinding == null ? this.socketBinding : configuration.socketBinding;
        this.socketBindingGroups = configuration.socketBindingGroups == null ? this.socketBindingGroups : configuration.socketBindingGroups;
        this.xmlEdits = configuration.xmlEdits == null ? this.xmlEdits : configuration.xmlEdits;
        this.moduleId = configuration.moduleId == null ? this.moduleId : configuration.moduleId;
        this.failNoMatch = configuration.failNoMatch;
        this.configType = configuration.configType == null ? this.configType : configuration.configType;
        this.profiles = configuration.profiles == null ? this.profiles : configuration.profiles;
        return this;
    }

    public RegisterModuleConfiguration failNoMatch(boolean failNoMatch) {
        this.failNoMatch = failNoMatch;
        return this;
    }

    public RegisterModuleConfiguration withExtension(String moduleId) {
        this.moduleId = moduleId;
        return this;
    }

    public RegisterModuleConfiguration sourceServerConfig(File sourceServerConfig) {
        this.sourceServerConfig = sourceServerConfig;
        return this;
    }

    public RegisterModuleConfiguration targetServerConfig(File targetServerConfig) {
        this.targetServerConfig = targetServerConfig;
        if (this.configType == null) {
            if (targetServerConfig.getName().matches(".*standalone[^/]*.xml")) {
                this.configType(ConfigType.STANDALONE);
            } else if (targetServerConfig.getName().matches(".*host[^/]*.xml")) {
                this.configType(ConfigType.HOST);
            } else if (targetServerConfig.getName().matches(".*domain[^/]*.xml")) {
                this.configType(ConfigType.DOMAIN);
            } else {
                this.configType(ConfigType.STANDALONE);
            }
        }
        return this;
    }

    public RegisterModuleConfiguration configType(ConfigType configType) {
        this.configType = configType;
        return this;
    }

    public RegisterModuleConfiguration subsystem(URL subsystem) {
        this.subsystem = subsystem;
        return this;
    }

    public RegisterModuleConfiguration socketBinding(URL socketBinding) {
        this.socketBinding = socketBinding;
        return this;
    }

    public RegisterModuleConfiguration socketBindingGroups(Set<String> socketBindingGroups) {
        this.socketBindingGroups = socketBindingGroups;
        return this;
    }

    public RegisterModuleConfiguration xmlEdits(List<XmlEdit> inserts) {
        this.xmlEdits = inserts;
        return this;
    }

    public RegisterModuleConfiguration profiles(Set<String> profiles) {
        this.profiles = profiles;
        return this;
    }

    public List<XmlEdit> getXmlEdits() {
        if (this.xmlEdits == null) {
            this.xmlEdits = new ArrayList<XmlEdit>();
        }
        return this.xmlEdits;
    }

    public File getTargetServerConfig() {
        return this.targetServerConfig;
    }

    public URL getSocketBinding() {
        return this.socketBinding;
    }

    public URL getSubsystem() {
        return this.subsystem;
    }

    public Set<String> getSocketBindingGroups() {
        return this.socketBindingGroups;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public File getSourceServerConfig() {
        return this.sourceServerConfig;
    }

    public boolean isFailNoMatch() {
        return this.failNoMatch;
    }

    public ConfigType getConfigType() {
        return this.configType;
    }

    public Set<String> getProfiles() {
        if (this.profiles == null) {
            this.profiles = new HashSet<String>();
        }
        return this.profiles;
    }
}

