/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.agent.installer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.hawkular.wildfly.agent.installer.AgentInstaller;
import org.jboss.logging.Logger;

public class InstallerConfiguration {
    private static final Logger log = Logger.getLogger(AgentInstaller.class);
    static final String OPTION_INSTALLER_CONFIG = "installer-config";
    static final String OPTION_WILDFLY_HOME = "wildfly-home";
    static final String OPTION_MODULE_DISTRIBUTION = "module-dist";
    static final String OPTION_SERVER_CONFIG = "server-config";
    static final String OPTION_HAWKULAR_SERVER_URL = "hawkular-server-url";
    static final String OPTION_KEYSTORE_PATH = "keystore-path";
    static final String OPTION_KEYSTORE_PASSWORD = "keystore-password";
    static final String OPTION_KEY_PASSWORD = "key-password";
    static final String OPTION_KEY_ALIAS = "key-alias";
    static final String OPTION_HAWKULAR_USERNAME = "hawkular-username";
    static final String OPTION_HAWKULAR_PASSWORD = "hawkular-password";
    static final String OPTION_HAWKULAR_TOKEN = "hawkular-token";
    private final Properties properties = new Properties();

    static Options buildCommandLineOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"D").hasArgs().valueSeparator('=').build());
        options.addOption(Option.builder().argName(OPTION_INSTALLER_CONFIG).longOpt(OPTION_INSTALLER_CONFIG).desc("Installer .properties configuration file").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_WILDFLY_HOME).longOpt(OPTION_WILDFLY_HOME).desc("Target WildFly home directory").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_MODULE_DISTRIBUTION).longOpt(OPTION_MODULE_DISTRIBUTION).desc("Hawkular WildFly Agent Module distribution zip file").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_HAWKULAR_SERVER_URL).longOpt(OPTION_HAWKULAR_SERVER_URL).desc("Hawkular Server URL").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_SERVER_CONFIG).longOpt(OPTION_SERVER_CONFIG).desc("Server config to write to. Can be either absolute path or relative to wildfly-home").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_KEYSTORE_PATH).longOpt(OPTION_KEYSTORE_PATH).desc("Keystore file. Required when hawkular-server-url protocol is https").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_KEYSTORE_PASSWORD).longOpt(OPTION_KEYSTORE_PASSWORD).desc("Keystore password. When hawkular-server-url protocol is https and this option is not passed, installer will ask for password").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_KEY_PASSWORD).longOpt(OPTION_KEY_PASSWORD).desc("Key password. When hawkular-server-url protocol is https and this option is not passed, installer will ask for password").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_KEY_ALIAS).longOpt(OPTION_KEY_ALIAS).desc("Key alias. Required when hawkular-server-url protocol is https").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_HAWKULAR_USERNAME).longOpt(OPTION_HAWKULAR_USERNAME).desc("User the agent will use when connecting to Hawkular Server. Ignored if a token is provided.").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_HAWKULAR_PASSWORD).longOpt(OPTION_HAWKULAR_PASSWORD).desc("Credentials agent will use when connecting to Hawkular Server. Ignored if a token is provided.").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_HAWKULAR_TOKEN).longOpt(OPTION_HAWKULAR_TOKEN).desc("Security token agent will use when connecting to Hawkular Server.").numberOfArgs(1).build());
        return options;
    }

    public InstallerConfiguration(CommandLine commandLine) throws IOException {
        Properties sysprops = commandLine.getOptionProperties("D");
        for (Map.Entry<Object, Object> sysprop : sysprops.entrySet()) {
            System.setProperty(sysprop.getKey().toString(), sysprop.getValue().toString());
        }
        String installerConfig = commandLine.getOptionValue(OPTION_INSTALLER_CONFIG, "classpath:/hawkular-wildfly-agent-installer.properties");
        log.debug((Object)("Installer configuration file: " + installerConfig));
        if (installerConfig.startsWith("classpath:")) {
            if (!(installerConfig = installerConfig.substring(10)).startsWith("/")) {
                installerConfig = "/" + installerConfig;
            }
            this.properties.load(InstallerConfiguration.class.getResourceAsStream(installerConfig));
        } else {
            if (installerConfig.matches("(http|https|file):.*")) {
                URL installerConfigUrl = new URL(installerConfig);
                try (InputStream is = installerConfigUrl.openStream();){
                    this.properties.load(is);
                }
            }
            File installerConfigFile = new File(installerConfig);
            try (FileInputStream fis = new FileInputStream(installerConfigFile);){
                this.properties.load(fis);
            }
        }
        this.setProperty(this.properties, commandLine, OPTION_WILDFLY_HOME);
        this.setProperty(this.properties, commandLine, OPTION_MODULE_DISTRIBUTION);
        this.setProperty(this.properties, commandLine, OPTION_SERVER_CONFIG);
        this.setProperty(this.properties, commandLine, OPTION_HAWKULAR_SERVER_URL);
        this.setProperty(this.properties, commandLine, OPTION_KEYSTORE_PATH);
        this.setProperty(this.properties, commandLine, OPTION_KEYSTORE_PASSWORD);
        this.setProperty(this.properties, commandLine, OPTION_KEY_PASSWORD);
        this.setProperty(this.properties, commandLine, OPTION_KEY_ALIAS);
        this.setProperty(this.properties, commandLine, OPTION_HAWKULAR_USERNAME);
        this.setProperty(this.properties, commandLine, OPTION_HAWKULAR_PASSWORD);
        this.setProperty(this.properties, commandLine, OPTION_HAWKULAR_TOKEN);
    }

    private void setProperty(Properties props, CommandLine commandLine, String option) {
        String value = commandLine.getOptionValue(option);
        if (value != null) {
            this.properties.setProperty(option, value);
        }
    }

    public String getInstallerConfig() {
        return this.properties.getProperty(OPTION_INSTALLER_CONFIG);
    }

    public String getWildFlyHome() {
        return this.properties.getProperty(OPTION_WILDFLY_HOME);
    }

    public String getModuleDistribution() {
        return this.properties.getProperty(OPTION_MODULE_DISTRIBUTION);
    }

    public String getServerConfig() {
        return this.properties.getProperty(OPTION_SERVER_CONFIG);
    }

    public String getHawkularServerUrl() {
        return this.properties.getProperty(OPTION_HAWKULAR_SERVER_URL);
    }

    public String getKeystorePath() {
        return this.properties.getProperty(OPTION_KEYSTORE_PATH);
    }

    public String getKeystorePassword() {
        return this.properties.getProperty(OPTION_KEYSTORE_PASSWORD);
    }

    public String getKeyPassword() {
        return this.properties.getProperty(OPTION_KEY_PASSWORD);
    }

    public String getKeyAlias() {
        return this.properties.getProperty(OPTION_KEY_ALIAS);
    }

    public String getHawkularUsername() {
        return this.properties.getProperty(OPTION_HAWKULAR_USERNAME);
    }

    public String getHawkularPassword() {
        return this.properties.getProperty(OPTION_HAWKULAR_PASSWORD);
    }

    public String getHawkularToken() {
        return this.properties.getProperty(OPTION_HAWKULAR_TOKEN);
    }
}

