/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.agent.installer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.hawkular.wildfly.agent.installer.AgentInstaller;
import org.hawkular.wildfly.agent.installer.EncoderDecoder;
import org.jboss.logging.Logger;

public class InstallerConfiguration {
    private static final Logger log = Logger.getLogger(AgentInstaller.class);
    static final String OPTION_INSTALLER_CONFIG = "installer-config";
    static final String OPTION_ENCRYPTION_KEY = "encryption-key";
    static final String OPTION_ENCRYPTION_SALT = "encryption-salt";
    static final String OPTION_ENABLED = "enabled";
    static final String OPTION_TARGET_LOCATION = "target-location";
    static final String OPTION_MODULE_DISTRIBUTION = "module-dist";
    static final String OPTION_TARGET_CONFIG = "target-config";
    static final String OPTION_SUBSYSTEM_SNIPPET = "subsystem-snippet";
    static final String OPTION_SERVER_URL = "server-url";
    static final String OPTION_KEYSTORE_PATH = "keystore-path";
    static final String OPTION_KEYSTORE_PASSWORD = "keystore-password";
    static final String OPTION_KEY_PASSWORD = "key-password";
    static final String OPTION_KEY_ALIAS = "key-alias";
    static final String OPTION_USERNAME = "username";
    static final String OPTION_PASSWORD = "password";
    static final String OPTION_SECURITY_KEY = "security-key";
    static final String OPTION_SECURITY_SECRET = "security-secret";
    static final String OPTION_MANAGED_SERVER_NAME = "managed-server-name";
    private final Properties properties = new Properties();

    static Options buildCommandLineOptions() {
        Options options = new Options();
        options.addOption(Option.builder("D").hasArgs().valueSeparator('=').build());
        options.addOption(Option.builder().argName(OPTION_INSTALLER_CONFIG).longOpt(OPTION_INSTALLER_CONFIG).desc("Installer .properties configuration file").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_ENCRYPTION_KEY).longOpt(OPTION_ENCRYPTION_KEY).desc("If specified, this is used to decode the properties that were encrypted. If you do not provide a value with the option, you will be prompted for one.").numberOfArgs(1).optionalArg(true).build());
        options.addOption(Option.builder().argName(OPTION_ENCRYPTION_SALT).longOpt(OPTION_ENCRYPTION_SALT).desc("The salt used for generating the key. Recommended, if encryption is used. If not specified, the same value as the key will be used.").numberOfArgs(1).optionalArg(true).build());
        options.addOption(Option.builder().argName(OPTION_ENABLED).longOpt(OPTION_ENABLED).desc("Indicates if the agent should be enabled at startup").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_TARGET_LOCATION).longOpt(OPTION_TARGET_LOCATION).desc("Target home directory of the application server where the agent is to be installed").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_MODULE_DISTRIBUTION).longOpt(OPTION_MODULE_DISTRIBUTION).desc("Hawkular WildFly Agent Module distribution zip file").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_SERVER_URL).longOpt(OPTION_SERVER_URL).desc("Server URL where the agent will send its monitoring data").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_TARGET_CONFIG).longOpt(OPTION_TARGET_CONFIG).desc("The target configuration file to write to. Can be either absolute path or relative to target-location").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_SUBSYSTEM_SNIPPET).longOpt(OPTION_SUBSYSTEM_SNIPPET).desc("Customized subsystem XML content that overrides the default subsystem configuration").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_MANAGED_SERVER_NAME).longOpt(OPTION_MANAGED_SERVER_NAME).desc("The agent will use this name to refer to the server where it is deployed and locally managing.").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_KEYSTORE_PATH).longOpt(OPTION_KEYSTORE_PATH).desc("Keystore file. Required when server-url protocol is https").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_KEYSTORE_PASSWORD).longOpt(OPTION_KEYSTORE_PASSWORD).desc("Keystore password. When server-url protocol is https and this option is not passed, installer will ask for password").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_KEY_PASSWORD).longOpt(OPTION_KEY_PASSWORD).desc("Key password. When server-url protocol is https and this option is not passed, installer will ask for password").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_KEY_ALIAS).longOpt(OPTION_KEY_ALIAS).desc("Key alias. Required when server-url protocol is https").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_USERNAME).longOpt(OPTION_USERNAME).desc("User the agent will use when connecting to Hawkular Server. Ignored if security-key is provided.").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_PASSWORD).longOpt(OPTION_PASSWORD).desc("Credentials agent will use when connecting to Hawkular Server. Ignored if security-key is provided.").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_SECURITY_KEY).longOpt(OPTION_SECURITY_KEY).desc("Security key that the agent will use when authenticating with Hawkular Server.").numberOfArgs(1).build());
        options.addOption(Option.builder().argName(OPTION_SECURITY_SECRET).longOpt(OPTION_SECURITY_SECRET).desc("Security secret that the agent will use when authenticating with Hawkular Server.").numberOfArgs(1).build());
        return options;
    }

    public InstallerConfiguration(CommandLine commandLine) throws Exception {
        Properties sysprops = commandLine.getOptionProperties("D");
        for (Map.Entry<Object, Object> sysprop : sysprops.entrySet()) {
            System.setProperty(sysprop.getKey().toString(), sysprop.getValue().toString());
        }
        String installerConfig = commandLine.getOptionValue(OPTION_INSTALLER_CONFIG, "classpath:/hawkular-wildfly-agent-installer.properties");
        log.debug("Installer configuration file: " + installerConfig);
        if (installerConfig.startsWith("classpath:")) {
            if (!(installerConfig = installerConfig.substring(10)).startsWith("/")) {
                installerConfig = "/" + installerConfig;
            }
            this.properties.load(InstallerConfiguration.class.getResourceAsStream(installerConfig));
        } else {
            if (installerConfig.matches("(http|https|file):.*")) {
                URL installerConfigUrl = new URL(installerConfig);
                try (InputStream is = installerConfigUrl.openStream();){
                    this.properties.load(is);
                }
            }
            File installerConfigFile = new File(installerConfig);
            try (FileInputStream fis = new FileInputStream(installerConfigFile);){
                this.properties.load(fis);
            }
        }
        this.setProperty(this.properties, commandLine, OPTION_ENABLED);
        this.setProperty(this.properties, commandLine, OPTION_TARGET_LOCATION);
        this.setProperty(this.properties, commandLine, OPTION_MODULE_DISTRIBUTION);
        this.setProperty(this.properties, commandLine, OPTION_TARGET_CONFIG);
        this.setProperty(this.properties, commandLine, OPTION_SUBSYSTEM_SNIPPET);
        this.setProperty(this.properties, commandLine, OPTION_MANAGED_SERVER_NAME);
        this.setProperty(this.properties, commandLine, OPTION_SERVER_URL);
        this.setProperty(this.properties, commandLine, OPTION_KEYSTORE_PATH);
        this.setProperty(this.properties, commandLine, OPTION_KEYSTORE_PASSWORD);
        this.setProperty(this.properties, commandLine, OPTION_KEY_PASSWORD);
        this.setProperty(this.properties, commandLine, OPTION_KEY_ALIAS);
        this.setProperty(this.properties, commandLine, OPTION_USERNAME);
        this.setProperty(this.properties, commandLine, OPTION_PASSWORD);
        this.setProperty(this.properties, commandLine, OPTION_SECURITY_KEY);
        this.setProperty(this.properties, commandLine, OPTION_SECURITY_SECRET);
    }

    private void setProperty(Properties props, CommandLine commandLine, String option) {
        String value = commandLine.getOptionValue(option);
        if (value != null) {
            this.properties.setProperty(option, value);
        }
    }

    public void decodeProperties(String encryptionKey, byte[] salt) throws Exception {
        this.decodeProperty(this.properties, OPTION_KEYSTORE_PASSWORD, encryptionKey, salt);
        this.decodeProperty(this.properties, OPTION_KEY_PASSWORD, encryptionKey, salt);
        this.decodeProperty(this.properties, OPTION_PASSWORD, encryptionKey, salt);
        this.decodeProperty(this.properties, OPTION_SECURITY_SECRET, encryptionKey, salt);
    }

    private void decodeProperty(Properties prop, String option, String key, byte[] salt) throws Exception {
        String value = this.properties.getProperty(option, null);
        if (value != null) {
            value = EncoderDecoder.decode(value, key, salt);
            this.properties.setProperty(option, value);
        }
    }

    public String getInstallerConfig() {
        return this.properties.getProperty(OPTION_INSTALLER_CONFIG);
    }

    public boolean isEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(OPTION_ENABLED, "true"));
    }

    public String getTargetLocation() {
        return this.properties.getProperty(OPTION_TARGET_LOCATION);
    }

    public String getModuleDistribution() {
        return this.properties.getProperty(OPTION_MODULE_DISTRIBUTION);
    }

    public String getTargetConfig() {
        return this.properties.getProperty(OPTION_TARGET_CONFIG);
    }

    public String getSubsystemSnippet() {
        return this.properties.getProperty(OPTION_SUBSYSTEM_SNIPPET);
    }

    public String getServerUrl() {
        return this.properties.getProperty(OPTION_SERVER_URL);
    }

    public String getKeystorePath() {
        return this.properties.getProperty(OPTION_KEYSTORE_PATH);
    }

    public String getKeystorePassword() {
        return this.properties.getProperty(OPTION_KEYSTORE_PASSWORD);
    }

    public String getKeyPassword() {
        return this.properties.getProperty(OPTION_KEY_PASSWORD);
    }

    public String getKeyAlias() {
        return this.properties.getProperty(OPTION_KEY_ALIAS);
    }

    public String getUsername() {
        return this.properties.getProperty(OPTION_USERNAME);
    }

    public String getPassword() {
        return this.properties.getProperty(OPTION_PASSWORD);
    }

    public String getSecurityKey() {
        return this.properties.getProperty(OPTION_SECURITY_KEY);
    }

    public String getSecuritySecret() {
        return this.properties.getProperty(OPTION_SECURITY_SECRET);
    }

    public String getManagedServerName() {
        return this.properties.getProperty(OPTION_MANAGED_SERVER_NAME);
    }
}

