/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.agent.installer;

import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.hawkular.wildfly.agent.installer.InstallerConfiguration;
import org.hawkular.wildfly.module.installer.DeploymentConfiguration;
import org.hawkular.wildfly.module.installer.ExtensionDeployer;
import org.hawkular.wildfly.module.installer.XmlEdit;
import org.jboss.logging.Logger;

public class AgentInstaller {
    private static final Logger log = Logger.getLogger(AgentInstaller.class);
    private static final String SECURITY_REALM_NAME = "HawkularRealm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Options options = null;
        ArrayList<File> filesToDelete = new ArrayList<File>();
        try {
            String targetConfig;
            URL moduleZipUrl;
            File moduleTempFile;
            String hawkularServerPort;
            String hawkularServerHost;
            String hawkularServerProtocol;
            String jbossHome;
            options = InstallerConfiguration.buildCommandLineOptions();
            CommandLine commandLine = new DefaultParser().parse(options, args);
            InstallerConfiguration installerConfig = new InstallerConfiguration(commandLine);
            boolean passwordsEncrypted = commandLine.hasOption("encryption-key");
            if (passwordsEncrypted) {
                boolean saltSpecified;
                String key = commandLine.getOptionValue("encryption-key", null);
                String saltAsString = commandLine.getOptionValue("encryption-salt", null);
                if (key == null) {
                    key = AgentInstaller.readPasswordFromStdin("Encryption key:");
                }
                if (!(saltSpecified = commandLine.hasOption("encryption-salt"))) {
                    saltAsString = key;
                }
                if (saltAsString == null) {
                    saltAsString = AgentInstaller.readPasswordFromStdin("Salt:");
                }
                assert (saltAsString != null);
                assert (key != null);
                byte[] salt = saltAsString.getBytes("UTF-8");
                installerConfig.decodeProperties(key, salt);
            }
            if ((jbossHome = installerConfig.getTargetLocation()) == null) {
                File jbossHomeFile = new File(".").getCanonicalFile();
                if (!(jbossHomeFile.exists() && jbossHomeFile.isDirectory() && jbossHomeFile.canRead() && new File(jbossHomeFile, "modules").isDirectory())) {
                    throw new MissingOptionException("target-location must be specified");
                }
                jbossHome = jbossHomeFile.getCanonicalPath();
            }
            if (!(installerConfig.getUsername() != null && installerConfig.getPassword() != null || installerConfig.getSecurityKey() != null && installerConfig.getSecuritySecret() != null)) {
                throw new MissingOptionException("You must provide credentials (username/password or key/secret) in installer configuration");
            }
            try {
                URL hawkularServerUrl = new URL(installerConfig.getServerUrl());
                hawkularServerProtocol = hawkularServerUrl.getProtocol();
                hawkularServerHost = hawkularServerUrl.getHost();
                hawkularServerPort = String.valueOf(hawkularServerUrl.getPort());
            }
            catch (MalformedURLException mue) {
                Matcher m = Pattern.compile("(https?)://(.*):(\\d+)").matcher(installerConfig.getServerUrl());
                if (!m.matches()) {
                    throw mue;
                }
                try {
                    hawkularServerProtocol = m.group(1);
                    hawkularServerHost = m.group(2);
                    hawkularServerPort = m.group(3);
                }
                catch (Exception e) {
                    throw mue;
                }
            }
            String moduleZip = installerConfig.getModuleDistribution();
            if (moduleZip == null) {
                moduleTempFile = AgentInstaller.downloadModuleZip(AgentInstaller.getHawkularServerAgentDownloadUrl(installerConfig));
                if (moduleTempFile == null) {
                    throw new IOException("Failed to retrieve module dist from server, You can use option [module-dist] to supply your own");
                }
                filesToDelete.add(moduleTempFile);
                moduleZipUrl = moduleTempFile.toURI().toURL();
            } else if (moduleZip.startsWith("classpath:")) {
                String resourceUrl = moduleZip.substring(10);
                if (!resourceUrl.startsWith("/")) {
                    resourceUrl = "/" + resourceUrl;
                }
                if ((moduleZipUrl = AgentInstaller.class.getResource(resourceUrl)) == null) {
                    throw new IOException("Unable to load module.zip from classpath [" + resourceUrl + "]");
                }
            } else if (moduleZip.matches("(http|https|file):.*")) {
                moduleTempFile = AgentInstaller.downloadModuleZip(new URL(moduleZip));
                if (moduleTempFile == null) {
                    throw new IOException("Failed to retrieve agent module from server, option [module-dist] is now required but it was not supplied");
                }
                filesToDelete.add(moduleTempFile);
                moduleZipUrl = moduleTempFile.toURI().toURL();
            } else {
                moduleZipUrl = new File(moduleZip).toURI().toURL();
            }
            File socketBindingSnippetFile = AgentInstaller.createSocketBindingSnippet(hawkularServerHost, hawkularServerPort);
            filesToDelete.add(socketBindingSnippetFile);
            DeploymentConfiguration.Builder configurationBldr = DeploymentConfiguration.builder().jbossHome(new File(jbossHome)).module(moduleZipUrl).socketBinding(socketBindingSnippetFile.toURI().toURL());
            if (installerConfig.getSubsystemSnippet() != null) {
                try {
                    configurationBldr.subsystem(new URL(installerConfig.getSubsystemSnippet()));
                }
                catch (MalformedURLException mue) {
                    File file = new File(installerConfig.getSubsystemSnippet());
                    if (file.exists()) {
                        configurationBldr.subsystem(file.getAbsoluteFile().toURI().toURL());
                    }
                    throw new FileNotFoundException("Subsystem snippet not found at [" + installerConfig.getSubsystemSnippet() + "]");
                }
            }
            if ((targetConfig = installerConfig.getTargetConfig()) != null) {
                configurationBldr.serverConfig(targetConfig);
            } else {
                targetConfig = DeploymentConfiguration.DEFAULT_SERVER_CONFIG;
            }
            if (hawkularServerProtocol.equals("https")) {
                File keystoreSrcFile;
                String keystorePath = installerConfig.getKeystorePath();
                String keystorePass = installerConfig.getKeystorePassword();
                String keyPass = installerConfig.getKeyPassword();
                String keyAlias = installerConfig.getKeyAlias();
                if (keystorePath == null || keyAlias == null) {
                    throw new ParseException(String.format("When using https protocol, the following keystore command-line options are required: %s, %s", "keystore-path", "key-alias"));
                }
                if (keystorePass == null && ((keystorePass = AgentInstaller.readPasswordFromStdin("Keystore password:")) == null || keystorePass.isEmpty())) {
                    keystorePass = "";
                    log.warn("keystore-password was not provided; using empty password");
                }
                if (keyPass == null && ((keyPass = AgentInstaller.readPasswordFromStdin("Key password:")) == null || keyPass.isEmpty())) {
                    keyPass = "";
                    log.warn("key-password was not provided; using empty password");
                }
                if (!(keystoreSrcFile = new File(keystorePath)).isFile() || !keystoreSrcFile.canRead()) {
                    throw new FileNotFoundException("Cannot read " + keystoreSrcFile.getAbsolutePath());
                }
                File targetConfigDir = new File(targetConfig).isAbsolute() ? new File(targetConfig).getParentFile() : new File(jbossHome, targetConfig).getParentFile();
                Path keystoreDst = Paths.get(targetConfigDir.getAbsolutePath(), new String[0]).resolve(keystoreSrcFile.getName());
                if (!keystoreDst.toFile().exists()) {
                    log.info("Copy [" + keystoreSrcFile.getAbsolutePath() + "] to [" + keystoreDst.toString() + "]");
                    Files.copy(Paths.get(keystoreSrcFile.getAbsolutePath(), new String[0]), keystoreDst, new CopyOption[0]);
                }
                String securityRealm = AgentInstaller.createSecurityRealm(keystoreSrcFile.getName(), keystorePass, keyPass, keyAlias);
                configurationBldr.addXmlEdit(new XmlEdit("/server/management/security-realms", securityRealm));
                configurationBldr.addXmlEdit(AgentInstaller.createStorageAdapter(true, installerConfig));
            } else {
                configurationBldr.addXmlEdit(AgentInstaller.createStorageAdapter(false, installerConfig));
            }
            configurationBldr.addXmlEdit(AgentInstaller.createManagedServers(installerConfig));
            configurationBldr.addXmlEdit(AgentInstaller.setEnableFlag(installerConfig));
            configurationBldr.modulesHome("modules");
            new ExtensionDeployer().install(configurationBldr.build());
        }
        catch (ParseException pe) {
            log.error(pe);
            AgentInstaller.printHelp(options);
            if (Boolean.getBoolean("org.hawkular.wildfly.agent.installer.throw-exception-on-error")) {
                throw pe;
            }
        }
        catch (Exception ex) {
            log.error(ex);
            if (Boolean.getBoolean("org.hawkular.wildfly.agent.installer.throw-exception-on-error")) {
                throw ex;
            }
        }
        finally {
            for (File fileToDelete : filesToDelete) {
                if (fileToDelete.delete()) continue;
                log.warn("Failed to delete temporary file: " + fileToDelete);
            }
        }
    }

    private static String readPasswordFromStdin(String message) {
        Console console = System.console();
        if (console == null) {
            return null;
        }
        console.writer().write(message);
        console.writer().flush();
        return String.valueOf(console.readPassword());
    }

    private static String createSecurityRealm(String keystoreFile, String keystorePass, String keyPass, String keyAlias) {
        return "<security-realm name=\"HawkularRealm\">" + "<server-identities><ssl>" + ("<keystore path=\"" + keystoreFile + "\"") + " relative-to=\"jboss.server.config.dir\"" + (" keystore-password=\"" + keystorePass + "\"") + (" key-password=\"" + keyPass + "\"") + (" alias=\"" + keyAlias + "\"") + " /></ssl></server-identities></security-realm>";
    }

    private static XmlEdit createStorageAdapter(boolean withHttps, InstallerConfiguration installerConfig) {
        String select = "/server/profile/*[namespace-uri()='urn:org.hawkular.agent:agent:1.0']/";
        StringBuilder xml = new StringBuilder("<storage-adapter").append(" type=\"HAWKULAR\"");
        if (withHttps) {
            xml.append(" securityRealm=\"HawkularRealm\"").append(" useSSL=\"true\"");
        }
        if (installerConfig.getUsername() != null && !installerConfig.getUsername().isEmpty()) {
            xml.append(" username=\"" + installerConfig.getUsername() + "\"");
        }
        if (installerConfig.getPassword() != null && !installerConfig.getPassword().isEmpty()) {
            xml.append(" password=\"" + installerConfig.getPassword() + "\"");
        }
        if (installerConfig.getSecurityKey() != null && !installerConfig.getSecurityKey().isEmpty()) {
            xml.append(" securityKey=\"" + installerConfig.getSecurityKey() + "\"");
        }
        if (installerConfig.getSecuritySecret() != null && !installerConfig.getSecuritySecret().isEmpty()) {
            xml.append(" securitySecret=\"" + installerConfig.getSecuritySecret() + "\"");
        }
        xml.append(" serverOutboundSocketBindingRef=\"hawkular\"");
        xml.append("/>");
        return new XmlEdit(select, xml.toString()).withAttribute("type");
    }

    private static File createSocketBindingSnippet(String host, String port) throws IOException {
        StringBuilder xml = new StringBuilder("<outbound-socket-binding name=\"hawkular\">\n").append("  <remote-destination host=\"" + host + "\" port=\"" + port + "\" />\n").append("</outbound-socket-binding>");
        Path tempFile = Files.createTempFile("hawkular-wildfly-module-installer-outbound-socket-binding", ".xml", new FileAttribute[0]);
        Files.write(tempFile, xml.toString().getBytes(), new OpenOption[0]);
        return tempFile.toFile();
    }

    private static XmlEdit createManagedServers(InstallerConfiguration config) {
        String select = "/server/profile/*[namespace-uri()='urn:org.hawkular.agent:agent:1.0']/";
        String managedServerName = config.getManagedServerName();
        if (managedServerName == null || managedServerName.trim().isEmpty()) {
            managedServerName = "Local";
        }
        StringBuilder xml = new StringBuilder("<managed-servers>").append("<local-dmr name=\"" + managedServerName + "\" enabled=\"true\" " + "resourceTypeSets=\"Main,Deployment,Web Component,EJB,Datasource," + "XA Datasource,JDBC Driver,Transaction Manager,Hawkular\" />").append("</managed-servers>");
        return new XmlEdit(select, xml.toString());
    }

    private static XmlEdit setEnableFlag(InstallerConfiguration config) {
        String select = "/server/profile/*[namespace-uri()='urn:org.hawkular.agent:agent:1.0'][@enabled]";
        String isEnabled = String.valueOf(config.isEnabled());
        return new XmlEdit(select, isEnabled).withIsAttributeContent(true).withAttribute("enabled");
    }

    private static URL getHawkularServerAgentDownloadUrl(InstallerConfiguration config) throws MalformedURLException {
        String serverUrl = String.format("%s/hawkular-wildfly-agent/download", config.getServerUrl());
        return new URL(serverUrl);
    }

    /*
     * Exception decompiling
     */
    private static File downloadModuleZip(URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void printHelp(Options options) {
        if (options == null) {
            throw new RuntimeException("Cannot print help - options is null");
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(120);
        formatter.setOptionComparator(null);
        formatter.printHelp("hawkular-wildfly-agent-installer", options);
    }
}

