/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.inventory.ConnectionData;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.TypeSets;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.PlatformNodeLocation;

public class MonitorServiceConfiguration {
    private static final MsgLogger log = AgentLoggers.getLogger(MonitorServiceConfiguration.class);
    private static final String FEED_ID_AUTOGENERATE = "autogenerate";
    private final GlobalConfiguration globalConfiguration;
    private final DiagnosticsConfiguration diagnostics;
    private final StorageAdapterConfiguration storageAdapter;
    private final ProtocolConfiguration<DMRNodeLocation> dmrConfiguration;
    private final ProtocolConfiguration<JMXNodeLocation> jmxConfiguration;
    private final ProtocolConfiguration<PlatformNodeLocation> platformConfiguration;

    public MonitorServiceConfiguration(GlobalConfiguration globalConfiguration, DiagnosticsConfiguration diagnostics, StorageAdapterConfiguration storageAdapter, ProtocolConfiguration<DMRNodeLocation> dmrConfiguration, ProtocolConfiguration<JMXNodeLocation> jmxConfiguration, ProtocolConfiguration<PlatformNodeLocation> platformConfiguration) {
        this.globalConfiguration = globalConfiguration;
        this.diagnostics = diagnostics;
        this.storageAdapter = storageAdapter;
        this.dmrConfiguration = dmrConfiguration;
        this.jmxConfiguration = jmxConfiguration;
        this.platformConfiguration = platformConfiguration;
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public StorageAdapterConfiguration getStorageAdapter() {
        return this.storageAdapter;
    }

    public DiagnosticsConfiguration getDiagnostics() {
        return this.diagnostics;
    }

    public boolean isSubsystemEnabled() {
        return this.globalConfiguration.subsystemEnabled;
    }

    public String getApiJndi() {
        return this.globalConfiguration.apiJndi;
    }

    public int getAutoDiscoveryScanPeriodSeconds() {
        return this.globalConfiguration.autoDiscoveryScanPeriodSeconds;
    }

    public int getNumDmrSchedulerThreads() {
        return this.globalConfiguration.numDmrSchedulerThreads;
    }

    public int getMetricDispatcherBufferSize() {
        return this.globalConfiguration.metricDispatcherBufferSize;
    }

    public int getMetricDispatcherMaxBatchSize() {
        return this.globalConfiguration.metricDispatcherMaxBatchSize;
    }

    public int getAvailDispatcherBufferSize() {
        return this.globalConfiguration.availDispatcherBufferSize;
    }

    public int getAvailDispatcherMaxBatchSize() {
        return this.globalConfiguration.availDispatcherMaxBatchSize;
    }

    public int getPingDispatcherPeriodSeconds() {
        return this.globalConfiguration.pingDispatcherPeriodSeconds;
    }

    public MonitorServiceConfiguration cloneWith(StorageAdapterConfiguration newStorageAdapter) {
        return new MonitorServiceConfiguration(this.globalConfiguration, this.diagnostics, newStorageAdapter, this.dmrConfiguration, this.jmxConfiguration, this.platformConfiguration);
    }

    public ProtocolConfiguration<DMRNodeLocation> getDmrConfiguration() {
        return this.dmrConfiguration;
    }

    public ProtocolConfiguration<JMXNodeLocation> getJmxConfiguration() {
        return this.jmxConfiguration;
    }

    public ProtocolConfiguration<PlatformNodeLocation> getPlatformConfiguration() {
        return this.platformConfiguration;
    }

    public static class EndpointConfiguration
    extends AbstractEndpointConfiguration {
        private final Collection<Name> resourceTypeSets;
        private final Avail setAvailOnShutdown;

        public EndpointConfiguration(String name, boolean enabled, Collection<Name> resourceTypeSets, ConnectionData connectionData, String securityRealm, Avail setAvailOnShutdown, String tenantId, String metricIdTemplate, Map<String, String> metricTags, Map<String, ? extends Object> customData) {
            super(name, enabled, connectionData, securityRealm, tenantId, metricIdTemplate, metricTags, customData);
            this.resourceTypeSets = resourceTypeSets;
            this.setAvailOnShutdown = setAvailOnShutdown;
        }

        public Collection<Name> getResourceTypeSets() {
            return this.resourceTypeSets;
        }

        public Avail getSetAvailOnShutdown() {
            return this.setAvailOnShutdown;
        }
    }

    public static class AbstractEndpointConfiguration {
        private final String name;
        private final boolean enabled;
        private final ConnectionData connectionData;
        private final String securityRealm;
        private final String tenantId;
        private final String metricIdTemplate;
        private final Map<String, String> metricTags;
        private final Map<String, ? extends Object> customData;

        public AbstractEndpointConfiguration(String name, boolean enabled, ConnectionData connectionData, String securityRealm, String tenantId, String metricIdTemplate, Map<String, String> metricTags, Map<String, ? extends Object> customData) {
            this.name = name;
            this.enabled = enabled;
            this.connectionData = connectionData;
            this.securityRealm = securityRealm;
            this.tenantId = tenantId;
            this.metricIdTemplate = metricIdTemplate;
            this.metricTags = metricTags;
            this.customData = customData != null ? Collections.unmodifiableMap(customData) : Collections.emptyMap();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getName() {
            return this.name;
        }

        public ConnectionData getConnectionData() {
            return this.connectionData;
        }

        public String getSecurityRealm() {
            return this.securityRealm;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public String getMetricIdTemplate() {
            return this.metricIdTemplate;
        }

        public Map<String, String> getMetricTags() {
            return this.metricTags;
        }

        public Map<String, ? extends Object> getCustomData() {
            return this.customData;
        }

        public boolean isLocal() {
            return this.connectionData == null;
        }
    }

    public static class ProtocolConfiguration<L> {
        private final TypeSets<L> typeSets;
        private final Map<String, EndpointConfiguration> endpoints;

        public static <L> Builder<L> builder() {
            return new Builder();
        }

        public ProtocolConfiguration(TypeSets<L> typeSets, Map<String, EndpointConfiguration> managedServers) {
            this.typeSets = typeSets;
            this.endpoints = managedServers;
        }

        public TypeSets<L> getTypeSets() {
            return this.typeSets;
        }

        public Map<String, EndpointConfiguration> getEndpoints() {
            return this.endpoints;
        }

        public static class Builder<L> {
            private TypeSets<L> typeSets;
            private Map<String, EndpointConfiguration> endpoints = new LinkedHashMap<String, EndpointConfiguration>();

            public Builder<L> endpoint(EndpointConfiguration endpoint) {
                this.endpoints.put(endpoint.getName(), endpoint);
                return this;
            }

            public Builder<L> typeSets(TypeSets<L> typeSets) {
                this.typeSets = typeSets;
                return this;
            }

            public ProtocolConfiguration<L> build() {
                for (EndpointConfiguration server : this.endpoints.values()) {
                    if (server.getResourceTypeSets() == null) continue;
                    for (Name resourceTypeSetName : server.getResourceTypeSets()) {
                        if (this.typeSets.getResourceTypeSets().containsKey(resourceTypeSetName)) continue;
                        log.warnResourceTypeSetDoesNotExist(server.getName().toString(), resourceTypeSetName.toString());
                    }
                }
                return new ProtocolConfiguration<L>(this.typeSets, this.endpoints);
            }
        }
    }

    public static class GlobalConfiguration {
        private final boolean subsystemEnabled;
        private final String apiJndi;
        private final int autoDiscoveryScanPeriodSeconds;
        private final int numDmrSchedulerThreads;
        private final int metricDispatcherBufferSize;
        private final int metricDispatcherMaxBatchSize;
        private final int availDispatcherBufferSize;
        private final int availDispatcherMaxBatchSize;
        private final int pingDispatcherPeriodSeconds;

        public GlobalConfiguration(boolean subsystemEnabled, String apiJndi, int autoDiscoveryScanPeriodSeconds, int numDmrSchedulerThreads, int metricDispatcherBufferSize, int metricDispatcherMaxBatchSize, int availDispatcherBufferSize, int availDispatcherMaxBatchSize, int pingDispatcherPeriodSeconds) {
            this.subsystemEnabled = subsystemEnabled;
            this.apiJndi = apiJndi;
            this.autoDiscoveryScanPeriodSeconds = autoDiscoveryScanPeriodSeconds;
            this.numDmrSchedulerThreads = numDmrSchedulerThreads;
            this.metricDispatcherBufferSize = metricDispatcherBufferSize;
            this.metricDispatcherMaxBatchSize = metricDispatcherMaxBatchSize;
            this.availDispatcherBufferSize = availDispatcherBufferSize;
            this.availDispatcherMaxBatchSize = availDispatcherMaxBatchSize;
            this.pingDispatcherPeriodSeconds = pingDispatcherPeriodSeconds;
        }
    }

    public static class DiagnosticsConfiguration {
        public static final DiagnosticsConfiguration EMPTY = new DiagnosticsConfiguration(false, null, 0, null);
        private final boolean enabled;
        private final DiagnosticsReportTo reportTo;
        private final int interval;
        private final TimeUnit timeUnits;

        public DiagnosticsConfiguration(boolean enabled, DiagnosticsReportTo reportTo, int interval, TimeUnit timeUnits) {
            this.enabled = enabled;
            this.reportTo = reportTo;
            this.interval = interval;
            this.timeUnits = timeUnits;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public DiagnosticsReportTo getReportTo() {
            return this.reportTo;
        }

        public int getInterval() {
            return this.interval;
        }

        public TimeUnit getTimeUnits() {
            return this.timeUnits;
        }
    }

    public static class StorageAdapterConfiguration {
        private final StorageReportTo type;
        private final String username;
        private final String password;
        private final String tenantId;
        private final String feedId;
        private final String url;
        private final boolean useSSL;
        private final String serverOutboundSocketBindingRef;
        private final String inventoryContext;
        private final String metricsContext;
        private final String feedcommContext;
        private final String keystorePath;
        private final String keystorePassword;
        private final String securityRealm;
        private final int connectTimeoutSeconds;
        private final int readTimeoutSeconds;

        public StorageAdapterConfiguration(StorageReportTo type, String username, String password, String tenantId, String feedId, String url, boolean useSSL, String serverOutboundSocketBindingRef, String inventoryContext, String metricsContext, String feedcommContext, String keystorePath, String keystorePassword, String securityRealm, int connectTimeoutSeconds, int readTimeoutSeconds) {
            this.type = type;
            this.username = username;
            this.password = password;
            this.tenantId = tenantId;
            this.feedId = MonitorServiceConfiguration.FEED_ID_AUTOGENERATE.equalsIgnoreCase(feedId) ? null : feedId;
            this.url = url;
            this.useSSL = useSSL;
            this.serverOutboundSocketBindingRef = serverOutboundSocketBindingRef;
            this.inventoryContext = inventoryContext;
            this.metricsContext = metricsContext;
            this.feedcommContext = feedcommContext;
            this.keystorePath = keystorePath;
            this.keystorePassword = keystorePassword;
            this.securityRealm = securityRealm;
            this.connectTimeoutSeconds = connectTimeoutSeconds;
            this.readTimeoutSeconds = readTimeoutSeconds;
        }

        public StorageReportTo getType() {
            return this.type;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public String getFeedId() {
            return this.feedId;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isUseSSL() {
            return this.useSSL;
        }

        public String getServerOutboundSocketBindingRef() {
            return this.serverOutboundSocketBindingRef;
        }

        public String getInventoryContext() {
            return this.inventoryContext;
        }

        public String getMetricsContext() {
            return this.metricsContext;
        }

        public String getFeedcommContext() {
            return this.feedcommContext;
        }

        public String getKeystorePath() {
            return this.keystorePath;
        }

        public String getKeystorePassword() {
            return this.keystorePassword;
        }

        public String getSecurityRealm() {
            return this.securityRealm;
        }

        public int getConnectTimeoutSeconds() {
            return this.connectTimeoutSeconds;
        }

        public int getReadTimeoutSeconds() {
            return this.readTimeoutSeconds;
        }
    }

    public static enum DiagnosticsReportTo {
        LOG,
        STORAGE;

    }

    public static enum StorageReportTo {
        HAWKULAR,
        METRICS;

    }
}

