/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.dmr.api;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hawkular.dmr.api.DmrApiException;
import org.hawkular.dmr.api.DmrApiLoggers;
import org.hawkular.dmr.api.DmrNodePath;
import org.hawkular.dmr.api.MsgLogger;
import org.hawkular.dmr.api.OperationFailureException;
import org.hawkular.dmr.api.SubsystemDatasourceConstants;
import org.hawkular.dmr.api.SubsystemLoggingConstants;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.descriptions.ModelDescriptionConstants;
import org.jboss.dmr.ModelNode;

public class OperationBuilder
implements SubsystemDatasourceConstants,
SubsystemLoggingConstants {
    private static final MsgLogger log = DmrApiLoggers.getLogger(OperationBuilder.class);

    public static AddOperationBuilder<AddOperationBuilder<?>> add() {
        return new AddOperationBuilder(null);
    }

    public static AddressBuilder<AddressBuilder<?, AbstractSingleOperationBuilder<?, ?>>, AbstractSingleOperationBuilder<?, ?>> address() {
        return new AddressBuilder(null, null);
    }

    public static CompositeOperationBuilder<CompositeOperationBuilder<?>> composite() {
        return new CompositeOperationBuilder();
    }

    public static MapPutOperationBuilder<MapPutOperationBuilder<?>> mapPut() {
        return new MapPutOperationBuilder(null);
    }

    public static ReadAttributeOperationBuilder<ReadAttributeOperationBuilder<?>> readAttribute() {
        return new ReadAttributeOperationBuilder(null);
    }

    public static ReadChildrenNamesOperationBuilder<ReadChildrenNamesOperationBuilder<?>> readChildrenNames() {
        return new ReadChildrenNamesOperationBuilder(null);
    }

    public static ReadChildrenResourcesOperationBuilder<ReadChildrenResourcesOperationBuilder<?>> readChildrenResources() {
        return new ReadChildrenResourcesOperationBuilder(null);
    }

    public static ReadResourceOperationBuilder<ReadResourceOperationBuilder<?>> readResource() {
        return new ReadResourceOperationBuilder(null);
    }

    public static ReloadOperationBuilder<ReloadOperationBuilder<?>> reload() {
        return new ReloadOperationBuilder(null);
    }

    public static RemoveOperationBuilder<RemoveOperationBuilder<?>> remove() {
        return new RemoveOperationBuilder(null);
    }

    public static WriteAttributeOperationBuilder<WriteAttributeOperationBuilder<?>> writeAttribute() {
        return new WriteAttributeOperationBuilder(null);
    }

    public static ByNameOperationBuilder<ByNameOperationBuilder<?>> byName(String operationName) {
        return new ByNameOperationBuilder(null, operationName);
    }

    public static class ByNameOperationBuilder<T extends ByNameOperationBuilder<?>>
    extends AbstractSingleOperationBuilder<T, OperationResult<?>> {
        public ByNameOperationBuilder(CompositeOperationBuilder<CompositeOperationBuilder<?>> bb, String operationName) {
            super(bb, operationName);
        }

        public T attribute(String name, String value) {
            if (value != null) {
                this.baseNode.get(name).set(value);
            }
            return (T)this;
        }
    }

    public static class WriteAttributeOperationBuilder<T extends WriteAttributeOperationBuilder<?>>
    extends AbstractSingleOperationBuilder<T, OperationResult<?>> {
        private WriteAttributeOperationBuilder(CompositeOperationBuilder<CompositeOperationBuilder<?>> bb) {
            super(bb, "write-attribute");
        }

        public T attribute(String name, Integer value) {
            this.baseNode.get("name").set(name);
            if (value != null) {
                this.baseNode.get("value").set(value.intValue());
            }
            return (T)this;
        }

        public T attribute(String name, String value) {
            this.baseNode.get("name").set(name);
            if (value != null) {
                this.baseNode.get("value").set(value);
            }
            return (T)this;
        }

        public T valueAttribute(String value) {
            return this.attribute("value", value);
        }
    }

    public static class StringListOperationResult<R extends StringListOperationResult<?>>
    extends NodeListOperationResult<R> {
        private StringListOperationResult(ModelNode requestNode, ModelNode resultNode) {
            super(requestNode, resultNode);
        }

        public Set<String> getHashSet() {
            Set result = this.getNodeList().stream().map(n -> n.asString()).collect(Collectors.toSet());
            return Collections.unmodifiableSet(result);
        }

        public Set<String> getLinkedHashSet() {
            Set result = this.getNodeList().stream().map(n -> n.asString()).collect(Collectors.toCollection(LinkedHashSet::new));
            return Collections.unmodifiableSet(result);
        }

        public List<String> getList() {
            List result = this.getNodeList().stream().map(n -> n.asString()).collect(Collectors.toList());
            return Collections.unmodifiableList(result);
        }
    }

    public static class RemoveOperationBuilder<T extends RemoveOperationBuilder<?>>
    extends AbstractSingleOperationBuilder<T, OperationResult<?>> {
        private RemoveOperationBuilder(CompositeOperationBuilder<CompositeOperationBuilder<?>> bb) {
            super(bb, "remove");
        }
    }

    public static class ReloadOperationBuilder<T extends ReloadOperationBuilder<?>>
    extends AbstractSingleOperationBuilder<T, OperationResult<?>> {
        private ReloadOperationBuilder(CompositeOperationBuilder<CompositeOperationBuilder<?>> bb) {
            super(bb, "reload");
        }

        public T adminOnly(boolean adminOnly) {
            this.baseNode.get("admin-only").set(adminOnly);
            return (T)this;
        }

        public T useCurrentServerConfig(boolean useCurrentServerConfig) {
            this.baseNode.get("use-current-server-config").set(useCurrentServerConfig);
            return (T)this;
        }
    }

    public static class ReadResourceOperationBuilder<T extends ReadResourceOperationBuilder<?>>
    extends AbstractSingleOperationBuilder<T, OperationResult<?>> {
        private ReadResourceOperationBuilder(CompositeOperationBuilder<CompositeOperationBuilder<?>> bb) {
            super(bb, "read-resource");
        }

        public T excludeDefaults() {
            return this.includeDefaults(false);
        }

        public T excludeRuntime() {
            return this.includeRuntime(false);
        }

        public T includeDefaults() {
            return this.includeDefaults(true);
        }

        public T includeDefaults(boolean includeDefaults) {
            this.baseNode.get("include-defaults").set(includeDefaults);
            return (T)this;
        }

        public T includeRuntime() {
            return this.includeRuntime(true);
        }

        public T includeRuntime(boolean includeRuntime) {
            this.baseNode.get("include-runtime").set(includeRuntime);
            return (T)this;
        }

        public T proxies() {
            this.baseNode.get("proxies").set(true);
            return (T)this;
        }

        public T recursive() {
            this.baseNode.get("recursive").set(true);
            return (T)this;
        }

        public T recursiveDepth(int depth) {
            this.baseNode.get("recursive").set(true);
            this.baseNode.get("recursive-depth").set(depth);
            return (T)this;
        }
    }

    public static class ReadChildrenResourcesOperationBuilder<T extends ReadChildrenResourcesOperationBuilder<?>>
    extends AbstractSingleOperationBuilder<T, NodeListOperationResult<?>> {
        private ReadChildrenResourcesOperationBuilder(CompositeOperationBuilder<CompositeOperationBuilder<?>> bb) {
            super(bb, "read-children-resources");
        }

        public T childType(String childType) {
            this.baseNode.get("child-type").set(childType);
            return (T)this;
        }

        @Override
        protected NodeListOperationResult<NodeListOperationResult<?>> createResult(ModelNode request, ModelNode result) {
            return new NodeListOperationResult(request, result);
        }

        public T excludeDefaults() {
            return this.includeDefaults(false);
        }

        public T excludeRuntime() {
            return this.includeRuntime(false);
        }

        public T includeDefaults() {
            return this.includeDefaults(true);
        }

        public T includeDefaults(boolean includeDefaults) {
            this.baseNode.get("include-defaults").set(includeDefaults);
            return (T)this;
        }

        public T includeRuntime() {
            return this.includeRuntime(true);
        }

        public T includeRuntime(boolean includeRuntime) {
            this.baseNode.get("include-runtime").set(includeRuntime);
            return (T)this;
        }

        public T proxies() {
            this.baseNode.get("proxies").set(true);
            return (T)this;
        }

        public T recursive() {
            this.baseNode.get("recursive").set(true);
            return (T)this;
        }

        public T recursiveDepth(int depth) {
            this.baseNode.get("recursive").set(true);
            this.baseNode.get("recursive-depth").set(depth);
            return (T)this;
        }
    }

    public static class ReadChildrenNamesOperationBuilder<T extends ReadChildrenNamesOperationBuilder<?>>
    extends AbstractSingleOperationBuilder<T, StringListOperationResult<?>> {
        private ReadChildrenNamesOperationBuilder(CompositeOperationBuilder<CompositeOperationBuilder<?>> bb) {
            super(bb, "read-children-names");
        }

        public T childType(String childType) {
            this.baseNode.get("child-type").set(childType);
            return (T)this;
        }

        @Override
        protected StringListOperationResult<StringListOperationResult<?>> createResult(ModelNode request, ModelNode result) {
            return new StringListOperationResult(request, result);
        }
    }

    public static class ReadAttributeOperationBuilder<T extends ReadAttributeOperationBuilder<?>>
    extends AbstractSingleOperationBuilder<T, OperationResult<?>> {
        private ReadAttributeOperationBuilder(CompositeOperationBuilder<CompositeOperationBuilder<?>> batch) {
            super(batch, "read-attribute");
        }

        public T excludeDefaults() {
            return this.includeDefaults(false);
        }

        public T includeDefaults() {
            return this.includeDefaults(true);
        }

        public T includeDefaults(boolean includeDefaults) {
            this.baseNode.get("include-defaults").set(includeDefaults);
            return (T)this;
        }

        public T name(String name) {
            this.baseNode.get("name").set(name);
            return (T)this;
        }

        public T resolveExpressions() {
            return this.resolveExpressions(true);
        }

        public T resolveExpressions(boolean resolveExpressions) {
            try {
                Field resolveExpressionField = ModelDescriptionConstants.class.getField("RESOLVE_EXPRESSIONS");
                String resolveExpressionFieldValue = (String)resolveExpressionField.get(null);
                this.baseNode.get(resolveExpressionFieldValue).set(resolveExpressions);
            }
            catch (NoSuchFieldException e) {
                this.baseNode.get("resolve-expressions").set(resolveExpressions);
                if (resolveExpressions) {
                    log.warnf("The local app server instance does not support resolving expressions.", new Object[0]);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return (T)this;
        }
    }

    public static class OperationResult<R extends OperationResult<?>> {
        protected final ModelNode requestNode;
        protected final ModelNode responseNode;

        private OperationResult(ModelNode requestNode, ModelNode responseNode) {
            this.requestNode = requestNode;
            this.responseNode = responseNode;
        }

        public R assertSuccess() {
            if (this.responseNode == null) {
                throw new IllegalStateException("responseNode cannot be null during assertSuccess()");
            }
            if (!this.responseNode.hasDefined("outcome")) {
                String msg = String.format("No [%s] field in responseNode [%s]", "outcome", this.responseNode.toString());
                throw new IllegalStateException(msg);
            }
            if (!this.responseNode.get("outcome").asString().equals("success")) {
                String msg = String.format("Could not perform operation [%s]: %s", this.requestNode.get("operation").asString(), this.responseNode.get("failure-description").asString());
                throw new OperationFailureException(msg);
            }
            return (R)this;
        }

        public ModelNode getRequestNode() {
            return this.requestNode;
        }

        public ModelNode getResponseNode() {
            return this.responseNode;
        }

        public ModelNode getResultNode() {
            return this.responseNode.get("result");
        }

        public Optional<ModelNode> getOptionalResultNode() {
            if (this.responseNode.hasDefined("result")) {
                return Optional.of(this.responseNode.get("result"));
            }
            return Optional.empty();
        }

        public Optional<ModelNode> getOptionalResponseHeaders() {
            if (this.responseNode.hasDefined("response-headers")) {
                return Optional.of(this.responseNode.get("response-headers"));
            }
            return Optional.empty();
        }

        public Optional<String> getOptionalProcessState() {
            Optional<ModelNode> responseHeaders = this.getOptionalResponseHeaders();
            if (responseHeaders.isPresent()) {
                if (responseHeaders.get().hasDefined("process-state")) {
                    return Optional.of(responseHeaders.get().get("process-state").asString());
                }
                return Optional.empty();
            }
            return Optional.empty();
        }
    }

    public static class NodeListOperationResult<R extends NodeListOperationResult<?>>
    extends OperationResult<R> {
        private NodeListOperationResult(ModelNode requestNode, ModelNode resultNode) {
            super(requestNode, resultNode);
        }

        public List<ModelNode> getNodeList() {
            if (!this.responseNode.hasDefined("result")) {
                return Collections.emptyList();
            }
            return this.responseNode.get("result").asList();
        }
    }

    public static class MapPutOperationBuilder<T extends MapPutOperationBuilder<?>>
    extends AbstractSingleOperationBuilder<T, OperationResult<?>> {
        private MapPutOperationBuilder(CompositeOperationBuilder<CompositeOperationBuilder<?>> batch) {
            super(batch, "map-put");
        }

        public T key(String key) {
            this.baseNode.get("key").set(key);
            return (T)this;
        }

        public T name(String name) {
            this.baseNode.get("name").set(name);
            return (T)this;
        }

        public T value(String value) {
            this.baseNode.get("value").set(value);
            return (T)this;
        }
    }

    public static class CompositeOperationBuilder<T extends CompositeOperationBuilder<?>>
    extends AbstractOperationBuilder<T, OperationResult<?>> {
        private ModelNode steps;

        private CompositeOperationBuilder() {
            this.baseNode.get("operation").set("composite");
            this.baseNode.get("address").setEmptyList();
            this.steps = this.baseNode.get("steps");
        }

        public AddOperationBuilder<AddOperationBuilder<?>> add() {
            return new AddOperationBuilder(this);
        }

        public MapPutOperationBuilder<MapPutOperationBuilder<?>> mapPut() {
            return new MapPutOperationBuilder(this);
        }

        public T operation(ModelNode op) {
            this.steps.add(op);
            return (T)this;
        }

        public ReadAttributeOperationBuilder<ReadAttributeOperationBuilder<?>> readAttribute() {
            return new ReadAttributeOperationBuilder(this);
        }

        public ReadChildrenResourcesOperationBuilder<ReadChildrenResourcesOperationBuilder<?>> readReadChildrenResources() {
            return new ReadChildrenResourcesOperationBuilder(this);
        }

        public ReadResourceOperationBuilder<ReadResourceOperationBuilder<?>> readResource() {
            return new ReadResourceOperationBuilder(this);
        }

        public ReloadOperationBuilder<ReloadOperationBuilder<?>> reload() {
            return new ReloadOperationBuilder(this);
        }

        public RemoveOperationBuilder<RemoveOperationBuilder<?>> remove() {
            return new RemoveOperationBuilder(this);
        }

        public WriteAttributeOperationBuilder<WriteAttributeOperationBuilder<?>> writeAttribute() {
            return new WriteAttributeOperationBuilder(this);
        }

        public ByNameOperationBuilder<ByNameOperationBuilder<?>> byNameOperation(String operationName) {
            return new ByNameOperationBuilder(this, operationName);
        }
    }

    public static class BooleanOperationResult<R extends BooleanOperationResult<?>>
    extends OperationResult<R> {
        private BooleanOperationResult(ModelNode requestNode, ModelNode resultNode) {
            super(requestNode, resultNode);
        }

        public boolean getBoolean() {
            if (!this.responseNode.hasDefined("result")) {
                throw new IllegalStateException(String.format("Need [%s] to return boolean", "result"));
            }
            return this.responseNode.get("result").asBoolean();
        }
    }

    public static class AddressBuilder<T extends AddressBuilder<?, P>, P extends AbstractSingleOperationBuilder<?, ?>> {
        private final DmrNodePath.Builder pathBuilder = DmrNodePath.builder();
        private final P parentBuilder;

        private AddressBuilder(P parentBuilder) {
            this.parentBuilder = parentBuilder;
        }

        public ModelNode build() {
            return this.pathBuilder.build().asModelNode();
        }

        public T datasource(String datasourceName) {
            this.segment("data-source", datasourceName);
            return (T)this;
        }

        public P parentBuilder() {
            ((AbstractSingleOperationBuilder)this.parentBuilder).address(this.build());
            return this.parentBuilder;
        }

        public T segment(String key, String value) {
            this.pathBuilder.segment(key, value);
            return (T)this;
        }

        public T segments(ModelNode address) {
            this.pathBuilder.segments(address);
            return (T)this;
        }

        public T segments(String path) {
            this.pathBuilder.segments(path);
            return (T)this;
        }

        public T segments(String parent, String path) {
            if (path.startsWith("/") && path.length() > 1) {
                return this.segments(path);
            }
            if (parent != null) {
                this.segments(parent);
            }
            return this.segments(path);
        }

        public T subsystem(String subsystem) {
            return this.segment("subsystem", subsystem);
        }

        public T subsystemDatasources() {
            return this.segment("subsystem", "datasources");
        }

        public T subsystemLogging() {
            return this.segment("subsystem", "logging");
        }

        public T xaDatasource(String xaDatasourceName) {
            return this.segment("data-source", xaDatasourceName);
        }

        public String toAddressString() {
            return this.pathBuilder.build().toString();
        }

        /* synthetic */ AddressBuilder(AbstractSingleOperationBuilder x0, 1 x1) {
            this(x0);
        }
    }

    public static class AddOperationBuilder<T extends AddOperationBuilder<?>>
    extends AbstractSingleOperationBuilder<T, OperationResult<?>> {
        private AddOperationBuilder(CompositeOperationBuilder<CompositeOperationBuilder<?>> batch) {
            super(batch, "add");
        }

        public T attribute(String name, boolean value) {
            this.baseNode.get(name).set(value);
            return (T)this;
        }

        public T attribute(String name, Integer value) {
            if (value != null) {
                this.baseNode.get(name).set(value.intValue());
            }
            return (T)this;
        }

        public T attribute(String name, String value) {
            if (value != null) {
                this.baseNode.get(name).set(value);
            }
            return (T)this;
        }

        public T valueAttribute(String value) {
            return this.attribute("value", value);
        }
    }

    public static abstract class AbstractSingleOperationBuilder<T extends AbstractSingleOperationBuilder<?, R>, R extends OperationResult<?>>
    extends AbstractOperationBuilder<T, R> {
        protected final CompositeOperationBuilder<CompositeOperationBuilder<?>> batch;

        private AbstractSingleOperationBuilder(CompositeOperationBuilder<CompositeOperationBuilder<?>> batch, String operationName) {
            this.batch = batch;
            this.baseNode.get("operation").set(operationName);
        }

        public AddressBuilder<AddressBuilder<?, T>, T> address() {
            return new AddressBuilder(this, null);
        }

        public T address(ModelNode addess) {
            this.baseNode.get("address").set(addess);
            return (T)this;
        }

        public T address(PathAddress path) {
            this.baseNode.get("address").set(path.toModelNode());
            return (T)this;
        }

        public CompositeOperationBuilder<?> parentBuilder() {
            return this.batch.operation(this.build());
        }
    }

    public static abstract class AbstractOperationBuilder<T extends AbstractOperationBuilder<?, R>, R extends OperationResult<?>> {
        protected final ModelNode baseNode = new ModelNode();

        public T allowResourceServiceRestart() {
            return this.allowResourceServiceRestart(true);
        }

        public T allowResourceServiceRestart(boolean allow) {
            return this.operationHeader("allow-resource-service-restart", allow);
        }

        public ModelNode build() {
            return this.baseNode;
        }

        protected R createResult(ModelNode request, ModelNode result) {
            return (R)new OperationResult(request, result);
        }

        public R execute(ModelControllerClient client) {
            ModelNode result;
            ModelNode request = this.build();
            try {
                result = client.execute(request);
            }
            catch (IOException e) {
                throw new DmrApiException(e);
            }
            log.tracef("Executed [%s] built by [%s] with result [%s]", request, this.getClass().getName(), result);
            return this.createResult(request, result);
        }

        public T operationHeader(String key, boolean value) {
            this.baseNode.get("operation-headers").get(key).set(value);
            return (T)this;
        }

        public T operationHeader(String key, String value) {
            this.baseNode.get("operation-headers").get(key).set(value);
            return (T)this;
        }
    }
}

