/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.extension.FileStoresDefinition;
import org.hawkular.agent.monitor.extension.MemoryDefinition;
import org.hawkular.agent.monitor.extension.MonitorPersistentResourceDefinition;
import org.hawkular.agent.monitor.extension.MonitorServiceWriteAttributeHandler;
import org.hawkular.agent.monitor.extension.PlatformAdd;
import org.hawkular.agent.monitor.extension.PlatformAttributes;
import org.hawkular.agent.monitor.extension.PlatformRemove;
import org.hawkular.agent.monitor.extension.PowerSourcesDefinition;
import org.hawkular.agent.monitor.extension.ProcessorsDefinition;
import org.hawkular.agent.monitor.extension.SubsystemExtension;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.protocol.ProtocolServices;
import org.hawkular.agent.monitor.scheduler.SchedulerService;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.hawkular.agent.wildfly.util.Util;
import org.hawkular.agent.wildfly.util.WildflyCompatibilityUtils;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;

public class PlatformDefinition
extends MonitorPersistentResourceDefinition {
    public static final PlatformDefinition INSTANCE = new PlatformDefinition();
    static final String PLATFORM = "platform";

    private PlatformDefinition() {
        super(PathElement.pathElement((String)PLATFORM, (String)"default"), (ResourceDescriptionResolver)SubsystemExtension.getResourceDescriptionResolver(PLATFORM), (OperationStepHandler)PlatformAdd.INSTANCE, (OperationStepHandler)PlatformRemove.INSTANCE, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_NONE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(PlatformAttributes.ATTRIBUTES);
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return Arrays.asList(new MonitorPersistentResourceDefinition[]{FileStoresDefinition.INSTANCE, MemoryDefinition.INSTANCE, ProcessorsDefinition.INSTANCE, PowerSourcesDefinition.INSTANCE});
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)PlatformAttributes.ENABLED, null, (OperationStepHandler)new MonitorServiceWriteAttributeHandler<Void>(new AttributeDefinition[0]){

            @Override
            protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
                if (context.isBooting()) {
                    return false;
                }
                super.applyUpdateToRuntime(context, operation, attributeName, newValue, currentValue, handbackHolder);
                boolean currBool = PlatformAttributes.ENABLED.resolveValue(context, currentValue).asBoolean();
                boolean newBool = PlatformAttributes.ENABLED.resolveValue(context, newValue).asBoolean();
                if (currBool == newBool) {
                    return false;
                }
                MonitorService monitorService = this.getMonitorService(context);
                if (monitorService == null || monitorService.getStatus() == ServiceStatus.STARTING) {
                    return true;
                }
                ProtocolService platformService = monitorService.getProtocolServices().getPlatformProtocolService();
                String thisEndpointName = WildflyCompatibilityUtils.getCurrentAddressValue(context, operation);
                if (newBool) {
                    AgentCoreEngineConfiguration config = Util.getMonitorServiceConfiguration(context);
                    ProtocolServices newServices = monitorService.createProtocolServicesBuilder().platformProtocolService(config.getPlatformConfiguration()).build();
                    EndpointService endpointService = (EndpointService)newServices.getPlatformProtocolService().getEndpointServices().get(thisEndpointName);
                    platformService.add(endpointService);
                } else {
                    SchedulerService schedulerService = monitorService.getSchedulerService();
                    platformService.remove(thisEndpointName, schedulerService);
                }
                return false;
            }

            protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode originalValue, ModelNode newBadValue, Void handback) throws OperationFailedException {
            }
        });
    }
}

