/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.service;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.hawkular.agent.monitor.api.HawkularAgentContext;
import org.hawkular.agent.monitor.cmd.Command;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.protocol.dmr.DMREndpointService;
import org.hawkular.agent.monitor.protocol.dmr.ModelControllerClientFactory;
import org.hawkular.agent.monitor.service.AgentCoreEngine;
import org.hawkular.agent.wildfly.cmd.UpdateCollectionIntervalsCommand;
import org.hawkular.agent.wildfly.log.AgentLoggers;
import org.hawkular.agent.wildfly.log.MsgLogger;
import org.hawkular.agent.wildfly.util.WildflyCompatibilityUtils;
import org.hawkular.bus.common.BasicMessage;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.SSLContextService;
import org.jboss.as.host.controller.DomainModelControllerService;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class MonitorService
extends AgentCoreEngine
implements Service<MonitorService> {
    private static final MsgLogger log = AgentLoggers.getLogger(MonitorService.class);
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final InjectedValue<ServerEnvironment> serverEnvironmentValue = new InjectedValue();
    private final InjectedValue<ControlledProcessStateService> processStateValue = new InjectedValue();
    private final InjectedValue<SocketBinding> httpSocketBindingValue = new InjectedValue();
    private final InjectedValue<SocketBinding> httpsSocketBindingValue = new InjectedValue();
    private final InjectedValue<OutboundSocketBinding> serverOutboundSocketBindingValue = new InjectedValue();
    private final Map<String, InjectedValue<SSLContext>> trustOnlySSLContextInjectedValues = new HashMap<String, InjectedValue<SSLContext>>();
    private final Map<String, InjectedValue<TrustManager[]>> trustOnlyTrustManagersInjectedValue = new HashMap<String, InjectedValue<TrustManager[]>>();
    private PropertyChangeListener serverStateListener;
    private AgentCoreEngineConfiguration bootConfiguration;
    private final ProcessType processType;

    private static AgentCoreEngineConfiguration buildRuntimeConfiguration(AgentCoreEngineConfiguration bootConfiguration, InjectedValue<SocketBinding> httpSocketBindingValue, InjectedValue<SocketBinding> httpsSocketBindingValue, InjectedValue<OutboundSocketBinding> serverOutboundSocketBindingValue) {
        AgentCoreEngineConfiguration.StorageAdapterConfiguration bootStorageAdapter = bootConfiguration.getStorageAdapter();
        log.infoStorageAdapterMode(bootStorageAdapter.getType());
        log.infoTenantId(bootStorageAdapter.getTenantId());
        if (bootConfiguration.getGlobalConfiguration().isImmutable()) {
            log.infoAgentIsImmutable();
        }
        if (bootStorageAdapter.getUrl() != null) {
            return bootConfiguration;
        }
        String useUrl = bootStorageAdapter.getUrl();
        if (useUrl == null) {
            try {
                int port;
                String address;
                if (bootStorageAdapter.getServerOutboundSocketBindingRef() == null) {
                    SocketBinding socketBinding = bootStorageAdapter.isUseSSL() ? (SocketBinding)httpsSocketBindingValue.getValue() : (SocketBinding)httpSocketBindingValue.getValue();
                    address = socketBinding.getAddress().getHostName();
                    if (address.equals("0.0.0.0") || address.equals("::/128")) {
                        address = InetAddress.getLocalHost().getCanonicalHostName();
                    }
                    port = socketBinding.getAbsolutePort();
                } else {
                    OutboundSocketBinding serverBinding = (OutboundSocketBinding)serverOutboundSocketBindingValue.getValue();
                    address = WildflyCompatibilityUtils.outboundSocketBindingGetResolvedDestinationAddress(serverBinding).getHostName();
                    port = serverBinding.getDestinationPort();
                }
                String protocol = bootStorageAdapter.isUseSSL() ? "https" : "http";
                useUrl = String.format("%s://%s:%d", protocol, address, port);
            }
            catch (UnknownHostException uhe) {
                throw new IllegalArgumentException("Cannot determine Hawkular server host", uhe);
            }
        }
        log.infoUsingServerSideUrl(useUrl);
        AgentCoreEngineConfiguration.StorageAdapterConfiguration runtimeStorageAdapter = new AgentCoreEngineConfiguration.StorageAdapterConfiguration(bootStorageAdapter.getType(), bootStorageAdapter.getUsername(), bootStorageAdapter.getPassword(), bootStorageAdapter.getTenantId(), bootStorageAdapter.getFeedId(), useUrl, bootStorageAdapter.isUseSSL(), bootStorageAdapter.getServerOutboundSocketBindingRef(), bootStorageAdapter.getMetricsContext(), bootStorageAdapter.getFeedcommContext(), bootStorageAdapter.getHawkularContext(), bootStorageAdapter.getKeystorePath(), bootStorageAdapter.getKeystorePassword(), bootStorageAdapter.getSecurityRealm(), bootStorageAdapter.getConnectTimeoutSeconds(), bootStorageAdapter.getReadTimeoutSeconds());
        return bootConfiguration.cloneWith(runtimeStorageAdapter);
    }

    public MonitorService(AgentCoreEngineConfiguration bootConfiguration, ProcessType processType) {
        super(bootConfiguration);
        this.bootConfiguration = bootConfiguration;
        this.processType = processType;
    }

    public MonitorService getValue() {
        return this;
    }

    public void addDependencies(ServiceTarget target, ServiceBuilder<MonitorService> bldr) {
        boolean bindJndi;
        String securityRealm;
        if (this.processType.isManagedDomain()) {
            bldr.addDependency(DomainModelControllerService.SERVICE_NAME, ModelController.class, this.modelControllerValue);
        } else {
            bldr.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.serverEnvironmentValue);
            bldr.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, this.modelControllerValue);
        }
        bldr.addDependency(ControlledProcessStateService.SERVICE_NAME, ControlledProcessStateService.class, this.processStateValue);
        AgentCoreEngineConfiguration.StorageAdapterConfiguration storageAdapterConfig = this.bootConfiguration.getStorageAdapter();
        if (storageAdapterConfig.getUrl() == null || storageAdapterConfig.getUrl().isEmpty()) {
            if (storageAdapterConfig.getServerOutboundSocketBindingRef() == null || storageAdapterConfig.getServerOutboundSocketBindingRef().isEmpty()) {
                if (this.processType.isManagedDomain()) {
                    throw new IllegalStateException("Do not know where the external Hawkular server is. Aborting.");
                }
                bldr.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{"http"}), SocketBinding.class, this.httpSocketBindingValue);
                bldr.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{"https"}), SocketBinding.class, this.httpsSocketBindingValue);
            } else {
                if (this.processType.isManagedDomain()) {
                    throw new IllegalStateException("When deployed in host controller, you must use the URL attribute and not the outbound socket binding. See bug https://issues.jboss.org/browse/WFCORE-1505 for more.");
                }
                bldr.addDependency(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{storageAdapterConfig.getServerOutboundSocketBindingRef()}), OutboundSocketBinding.class, this.serverOutboundSocketBindingValue);
            }
        }
        if (storageAdapterConfig.getSecurityRealm() != null) {
            InjectedValue iv = new InjectedValue();
            this.trustOnlySSLContextInjectedValues.put(storageAdapterConfig.getSecurityRealm(), (InjectedValue<SSLContext>)iv);
            boolean trustStoreOnly = true;
            SSLContextService.ServiceUtil.addDependency(bldr, (Injector)iv, (ServiceName)SecurityRealm.ServiceUtil.createServiceName((String)storageAdapterConfig.getSecurityRealm()), (boolean)trustStoreOnly);
        }
        for (AgentCoreEngineConfiguration.EndpointConfiguration endpoint : this.bootConfiguration.getDmrConfiguration().getEndpoints().values()) {
            securityRealm = endpoint.getSecurityRealm();
            if (securityRealm == null) continue;
            this.addSslContext(securityRealm, bldr);
        }
        for (AgentCoreEngineConfiguration.EndpointConfiguration endpoint : this.bootConfiguration.getJmxConfiguration().getEndpoints().values()) {
            securityRealm = endpoint.getSecurityRealm();
            if (securityRealm == null) continue;
            this.addSslContext(securityRealm, bldr);
        }
        String jndiName = this.bootConfiguration.getGlobalConfiguration().getApiJndi();
        boolean bl = bindJndi = jndiName != null && !jndiName.isEmpty() && !this.processType.isManagedDomain();
        if (bindJndi) {
            HawkularAgentContext jndiObject = this.getHawkularAgentContext();
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
            BinderService binderService = new BinderService(bindInfo.getBindName());
            Injector<ManagedReferenceFactory> managedObjectInjector = WildflyCompatibilityUtils.getManagedObjectInjectorFromBinderService(binderService);
            Injector<ServiceBasedNamingStore> namingStoreInjector = WildflyCompatibilityUtils.getNamingStoreInjectorFromBinderService(binderService);
            ManagedReferenceFactory valueMRF = WildflyCompatibilityUtils.getImmediateManagedReferenceFactory(jndiObject);
            String jndiObjectClassName = HawkularAgentContext.class.getName();
            ServiceName binderServiceName = bindInfo.getBinderServiceName();
            class JndiBindListener
            extends AbstractServiceListener<Object> {
                private final String jndiName;
                private final String jndiObjectClassName;

                public JndiBindListener(String jndiName, String jndiObjectClassName) {
                    this.jndiName = jndiName;
                    this.jndiObjectClassName = jndiObjectClassName;
                }

                public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                    switch (transition) {
                        case STARTING_to_UP: {
                            log.infoBindJndiResource(this.jndiName, this.jndiObjectClassName);
                            break;
                        }
                        case START_REQUESTED_to_DOWN: {
                            log.infoUnbindJndiResource(this.jndiName);
                            break;
                        }
                        case REMOVING_to_REMOVED: {
                            log.infoUnbindJndiResource(this.jndiName);
                            break;
                        }
                    }
                }
            }
            ServiceBuilder binderBuilder = target.addService(binderServiceName, (Service)binderService).addInjection(managedObjectInjector, (Object)valueMRF).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, namingStoreInjector).addListener((ServiceListener)new JndiBindListener(jndiName, jndiObjectClassName));
            bldr.addDependency(binderServiceName);
            binderBuilder.install();
        }
    }

    public void removeInstalledServices(OperationContext context) {
        boolean bindJndi;
        String jndiName = this.bootConfiguration.getGlobalConfiguration().getApiJndi();
        boolean bl = bindJndi = jndiName != null && !jndiName.isEmpty() && !this.processType.isManagedDomain();
        if (bindJndi) {
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
            context.removeService(bindInfo.getBinderServiceName());
        }
    }

    private void addSslContext(String securityRealm, ServiceBuilder<MonitorService> bldr) {
        if (securityRealm != null && !this.trustOnlySSLContextInjectedValues.containsKey(securityRealm)) {
            InjectedValue iv = new InjectedValue();
            this.trustOnlySSLContextInjectedValues.put(securityRealm, (InjectedValue<SSLContext>)iv);
            boolean trustStoreOnly = true;
            SSLContextService.ServiceUtil.addDependency(bldr, (Injector)iv, (ServiceName)SecurityRealm.ServiceUtil.createServiceName((String)securityRealm), (boolean)trustStoreOnly);
        }
    }

    public void start(StartContext startContext) throws StartException {
        final AtomicReference startThread = new AtomicReference();
        ServiceContainer serviceContainer = startContext.getController().getServiceContainer();
        for (String realmName : this.trustOnlySSLContextInjectedValues.keySet()) {
            ServiceName sn = SSLContextService.ServiceUtil.createServiceName((ServiceName)SecurityRealm.ServiceUtil.createServiceName((String)realmName), (boolean)true);
            SSLContextService sslContextService = (SSLContextService)serviceContainer.getRequiredService(sn).getService();
            this.trustOnlyTrustManagersInjectedValue.put(realmName, (InjectedValue<TrustManager[]>)sslContextService.getTrustManagerInjector());
        }
        ControlledProcessStateService stateService = (ControlledProcessStateService)this.processStateValue.getValue();
        class CustomPropertyChangeListener
        implements PropertyChangeListener {
            CustomPropertyChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Thread oldThread;
                if (this.isRunning(evt.getNewValue())) {
                    this.startNow();
                } else if (ControlledProcessState.State.STOPPING.equals(evt.getNewValue()) && (oldThread = (Thread)startThread.get()) != null) {
                    oldThread.interrupt();
                }
            }

            private void startNow() {
                Thread newThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MonitorService.this.startHawkularAgent();
                        }
                        catch (Throwable t) {
                            log.debug("Agent start thread aborted within start method", t);
                        }
                    }
                }, "Hawkular WildFly Agent Startup Thread");
                newThread.setDaemon(true);
                Thread oldThread = startThread.getAndSet(newThread);
                if (oldThread != null) {
                    oldThread.interrupt();
                }
                newThread.start();
            }

            private boolean isRunning(Object state) {
                return state == ControlledProcessState.State.RUNNING || state == ControlledProcessState.State.RELOAD_REQUIRED || state == ControlledProcessState.State.RESTART_REQUIRED;
            }
        }
        CustomPropertyChangeListener listener = new CustomPropertyChangeListener();
        this.serverStateListener = listener;
        stateService.addPropertyChangeListener(this.serverStateListener);
        if (listener.isRunning(stateService.getCurrentState())) {
            listener.startNow();
        }
    }

    public void stop(StopContext stopContext) {
        this.stopHawkularAgent();
    }

    protected AgentCoreEngineConfiguration loadRuntimeConfiguration(AgentCoreEngineConfiguration config) {
        return MonitorService.buildRuntimeConfiguration(config, this.httpSocketBindingValue, this.httpsSocketBindingValue, this.serverOutboundSocketBindingValue);
    }

    protected ModelControllerClientFactory buildLocalModelControllerClientFactory() {
        return ModelControllerClientFactory.createLocal((ModelController)((ModelController)this.modelControllerValue.getValue()));
    }

    protected Map<String, SSLContext> buildTrustOnlySSLContextValues(AgentCoreEngineConfiguration config) {
        HashMap<String, SSLContext> map = new HashMap<String, SSLContext>(this.trustOnlySSLContextInjectedValues.size());
        for (Map.Entry<String, InjectedValue<SSLContext>> entry : this.trustOnlySSLContextInjectedValues.entrySet()) {
            map.put(entry.getKey(), (SSLContext)entry.getValue().getOptionalValue());
        }
        return map;
    }

    protected Map<String, TrustManager[]> buildTrustOnlyTrustManagersValues(AgentCoreEngineConfiguration config) {
        HashMap<String, TrustManager[]> map = new HashMap<String, TrustManager[]>(this.trustOnlyTrustManagersInjectedValue.size());
        for (Map.Entry<String, InjectedValue<TrustManager[]>> entry : this.trustOnlyTrustManagersInjectedValue.entrySet()) {
            map.put(entry.getKey(), (TrustManager[])entry.getValue().getOptionalValue());
        }
        return map;
    }

    protected void cleanupDuringStop() {
        if (this.serverStateListener != null) {
            ((ControlledProcessStateService)this.processStateValue.getValue()).removePropertyChangeListener(this.serverStateListener);
            this.serverStateListener = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String autoGenerateFeedId() throws Exception {
        ModelControllerClientFactory clientFactory = this.buildLocalModelControllerClientFactory();
        if (clientFactory == null) throw new IllegalStateException("Not running in a container where feed ID can be determined - you must set the feed ID explicitly in the configuration");
        try (ModelControllerClient c = clientFactory.createClient();){
            String string = DMREndpointService.lookupServerIdentifier((ModelControllerClient)c);
            return string;
        }
        catch (Exception e) {
            throw new Exception("Could not obtain local feed ID", e);
        }
    }

    protected Map<String, Class<? extends Command<? extends BasicMessage, ? extends BasicMessage>>> buildAdditionalCommands() {
        return Collections.singletonMap(UpdateCollectionIntervalsCommand.REQUEST_CLASS.getName(), UpdateCollectionIntervalsCommand.class);
    }
}

