/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.wildfly.log;

import javax.management.MalformedObjectNameException;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HAWKMONITOR")
@ValidIdRange(min=20000, max=29999)
public interface MsgLogger
extends BasicLogger {
    public static final MsgLogger LOG = (MsgLogger)Logger.getMessageLogger(MsgLogger.class, (String)"org.hawkular.agent.monitor");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20002, value="Hawkular WildFly Agent subsystem is disabled; service will not be started")
    public void infoSubsystemDisabled();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20003, value="JNDI binding [%s]: bound to object of type [%s]")
    public void infoBindJndiResource(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20004, value="JNDI binding [%s]: unbound")
    public void infoUnbindJndiResource(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20005, value="No diagnostics configuration - diagnostics will be disabled")
    public void infoNoDiagnosticsConfig();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20006, value="There are no enabled %s metric sets")
    public void infoNoEnabledMetricsConfigured(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20007, value="There are no enabled %s availability check sets")
    public void infoNoEnabledAvailsConfigured(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20015, value="Comma in name! This will interfere with comma-separators in lists. [%s]")
    public void warnCommaInName(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20021, value="There are no enabled %s resource type sets")
    public void infoNoEnabledResourceTypesConfigured(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20025, value="Will talk to Hawkular at URL [%s]")
    public void infoUsingServerSideUrl(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20031, value="The storage adapter URL is explicitly specified [%s], so useSSL will be set to [%s]")
    public void infoUsingSSL(String var1, boolean var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20045, value="No platform configuration - platform metrics will be disabled")
    public void infoNoPlatformConfig();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20048, value="Malformed JMX object name: [%s]")
    public void warnMalformedJMXObjectName(String var1, @Cause MalformedObjectNameException var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20050, value="Tenant ID [%s]")
    public void infoTenantId(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20059, value="Agent is using storage adapter mode [%s]")
    public void infoStorageAdapterMode(AgentCoreEngineConfiguration.StorageReportTo var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20076, value="Cannot register feed under tenant ID [%s] for new managed server [%s]: %s")
    public void warnCannotRegisterFeedForNewManagedServer(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20080, value="Agent has been configured to be immutable")
    public void infoAgentIsImmutable();
}

