/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.client.common;

import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.hawkular.metrics.client.common.SingleMetric;

public class BoundMetricFifo
extends AbstractQueue<SingleMetric>
implements Queue<SingleMetric> {
    private final int maxSize;
    Deque<SingleMetric> contents;
    final Object mutex;

    public BoundMetricFifo(int initialSize, int maxSize) {
        if (initialSize > maxSize) {
            initialSize = maxSize;
        }
        this.contents = new ArrayDeque<SingleMetric>(initialSize);
        this.maxSize = maxSize;
        this.mutex = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<SingleMetric> iterator() {
        Object object = this.mutex;
        synchronized (object) {
            return this.contents.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.contents.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(SingleMetric singleMetric) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.contents.size() == this.maxSize) {
                this.contents.removeLast();
            }
            this.contents.offerFirst(singleMetric);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SingleMetric poll() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.contents.size() == 0) {
                return null;
            }
            return this.contents.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SingleMetric peek() {
        Object object = this.mutex;
        synchronized (object) {
            return this.contents.peekLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanout(SingleMetric metric) {
        if (metric == null) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.contents.remove(metric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanout(Collection<SingleMetric> metrics) {
        if (metrics == null || metrics.isEmpty()) {
            return false;
        }
        boolean removed = true;
        Object object = this.mutex;
        synchronized (object) {
            for (SingleMetric metric : metrics) {
                removed &= this.contents.remove(metric);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SingleMetric> getList() {
        Object object = this.mutex;
        synchronized (object) {
            return new ArrayList<SingleMetric>(this.contents);
        }
    }
}

