/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hawkular.agent.monitor.api.SamplingService;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.inventory.ResourceTypeManager;

public class InventoryEvent<L> {
    private final SamplingService<L> samplingService;
    private final ResourceManager<L> resourceManager;
    private final Optional<ResourceTypeManager<L>> resourceTypeManager;
    private final Map<String, Resource<L>> addedOrModifiedRootResources;
    private final Map<String, Resource<L>> removedRootResources;
    private final List<Resource<L>> addedOrModified;
    private final List<Resource<L>> removed;

    private InventoryEvent(SamplingService<L> samplingService, ResourceManager<L> resourceManager, Optional<ResourceTypeManager<L>> resourceTypeManager, List<Resource<L>> addedOrModified, List<Resource<L>> removed) {
        if (samplingService == null) {
            throw new IllegalArgumentException("Sampling service cannot be null");
        }
        if (resourceManager == null) {
            throw new IllegalArgumentException("Resource manager cannot be null");
        }
        if (resourceTypeManager == null) {
            throw new IllegalArgumentException("Resource type manager cannot be null");
        }
        this.samplingService = samplingService;
        this.resourceManager = resourceManager;
        this.resourceTypeManager = resourceTypeManager;
        this.addedOrModified = addedOrModified;
        this.removed = removed;
        this.addedOrModifiedRootResources = new HashMap<String, Resource<L>>();
        this.removedRootResources = new HashMap<String, Resource<L>>();
        addedOrModified.forEach(r -> {
            Resource root = InventoryEvent.getRootResource(r);
            this.addedOrModifiedRootResources.put(root.getID().getIDString(), root);
        });
        removed.forEach(r -> {
            if (r.getParent() == null) {
                this.removedRootResources.put(r.getID().getIDString(), (Resource<L>)r);
            } else {
                Resource root = InventoryEvent.getRootResource(r);
                this.addedOrModifiedRootResources.put(root.getID().getIDString(), root);
            }
        });
    }

    public static <L> InventoryEvent<L> removed(SamplingService<L> samplingService, ResourceManager<L> resourceManager, List<Resource<L>> removed) {
        return new InventoryEvent<L>(samplingService, resourceManager, Optional.empty(), new ArrayList<Resource<L>>(), removed);
    }

    public static <L> InventoryEvent<L> addedOrModified(SamplingService<L> samplingService, ResourceManager<L> resourceManager, List<Resource<L>> addedOrModified) {
        return new InventoryEvent<L>(samplingService, resourceManager, Optional.empty(), addedOrModified, new ArrayList<Resource<L>>());
    }

    public static <L> InventoryEvent<L> discovery(SamplingService<L> samplingService, ResourceManager<L> resourceManager, ResourceTypeManager<L> resourceTypeManager, List<Resource<L>> addedOrModified, List<Resource<L>> removed) {
        return new InventoryEvent<L>(samplingService, resourceManager, Optional.of(resourceTypeManager), addedOrModified, removed);
    }

    private static <T> Resource<T> getRootResource(Resource<T> resource) {
        if (resource.getParent() == null) {
            return resource;
        }
        return InventoryEvent.getRootResource(resource.getParent());
    }

    public SamplingService<L> getSamplingService() {
        return this.samplingService;
    }

    public ResourceManager<L> getResourceManager() {
        return this.resourceManager;
    }

    public Optional<ResourceTypeManager<L>> getResourceTypeManager() {
        return this.resourceTypeManager;
    }

    public Collection<Resource<L>> getAddedOrModifiedRootResources() {
        return this.addedOrModifiedRootResources.values();
    }

    public Collection<Resource<L>> getRemovedRootResources() {
        return this.removedRootResources.values();
    }

    public List<Resource<L>> getAddedOrModified() {
        return this.addedOrModified;
    }

    public List<Resource<L>> getRemoved() {
        return this.removed;
    }
}

