/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.diagnostics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.text.DateFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.storage.MetricDataPoint;
import org.hawkular.agent.monitor.storage.NumericMetricDataPoint;
import org.hawkular.agent.monitor.storage.StorageAdapter;
import org.hawkular.metrics.client.common.MetricType;

public class StorageReporter
extends ScheduledReporter {
    private final AgentCoreEngineConfiguration.DiagnosticsConfiguration diagnosticsConfig;
    private final StorageAdapter storageAdapter;
    private final Locale locale;
    private final Clock clock;
    private final DateFormat dateFormat;
    private final String feedId;

    private StorageReporter(String feedId, MetricRegistry registry, Locale locale, Clock clock, TimeZone timeZone, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, AgentCoreEngineConfiguration.DiagnosticsConfiguration diagnosticsConfig, StorageAdapter storageAdapter) {
        super(registry, "storage-reporter", filter, rateUnit, durationUnit);
        this.feedId = feedId;
        this.locale = locale;
        this.clock = clock;
        this.diagnosticsConfig = diagnosticsConfig;
        this.storageAdapter = storageAdapter;
        this.dateFormat = DateFormat.getDateTimeInstance(3, 2, locale);
        this.dateFormat.setTimeZone(timeZone);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        String key;
        HashSet<MetricDataPoint> samples;
        String ourName = "_self";
        if (!gauges.isEmpty()) {
            samples = new HashSet<MetricDataPoint>(gauges.size());
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                Gauge gauge = entry.getValue();
                key = this.feedId + "." + ourName + "." + entry.getKey();
                samples.add(new NumericMetricDataPoint(key, System.currentTimeMillis(), ((Integer)gauge.getValue()).intValue(), MetricType.GAUGE, null));
            }
            this.storageAdapter.storeMetrics(samples, 0L);
        }
        if (!counters.isEmpty()) {
            samples = new HashSet(counters.size());
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                String key2 = this.feedId + "." + ourName + "." + entry.getKey();
                samples.add(new NumericMetricDataPoint(key2, System.currentTimeMillis(), ((Counter)entry.getValue()).getCount(), MetricType.COUNTER, null));
            }
            this.storageAdapter.storeMetrics(samples, 0L);
        }
        if (!meters.isEmpty()) {
            samples = new HashSet(meters.size());
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                Meter meter = (Meter)entry.getValue();
                key = this.feedId + "." + ourName + "." + entry.getKey();
                samples.add(new NumericMetricDataPoint(key, System.currentTimeMillis(), meter.getOneMinuteRate(), MetricType.GAUGE, null));
            }
            this.storageAdapter.storeMetrics(samples, 0L);
        }
        if (!timers.isEmpty()) {
            samples = new HashSet(timers.size());
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                Timer timer = (Timer)entry.getValue();
                key = this.feedId + "." + ourName + "." + entry.getKey();
                samples.add(new NumericMetricDataPoint(key, System.currentTimeMillis(), timer.getSnapshot().get75thPercentile(), MetricType.GAUGE, null));
            }
            this.storageAdapter.storeMetrics(samples, 0L);
        }
    }

    public static Builder forRegistry(MetricRegistry registry, AgentCoreEngineConfiguration.DiagnosticsConfiguration diagnosticsConfig, StorageAdapter storageAdapter) {
        return new Builder(registry, diagnosticsConfig, storageAdapter);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private final AgentCoreEngineConfiguration.DiagnosticsConfiguration diagnosticsConfig;
        private final StorageAdapter storageAdapter;
        private Locale locale;
        private Clock clock;
        private TimeZone timeZone;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private String feedId;

        private Builder(MetricRegistry registry, AgentCoreEngineConfiguration.DiagnosticsConfiguration diagnosticsConfig, StorageAdapter storageAdapter) {
            this.registry = registry;
            this.diagnosticsConfig = diagnosticsConfig;
            this.storageAdapter = storageAdapter;
            this.locale = Locale.getDefault();
            this.clock = Clock.defaultClock();
            this.timeZone = TimeZone.getDefault();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder formattedFor(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder formattedFor(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder feedId(String feedId) {
            this.feedId = feedId;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public StorageReporter build() {
            return new StorageReporter(this.feedId, this.registry, this.locale, this.clock, this.timeZone, this.rateUnit, this.durationUnit, this.filter, this.diagnosticsConfig, this.storageAdapter);
        }
    }
}

