/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import java.util.HashMap;
import java.util.Map;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;

public final class AvailManager<L> {
    private Map<MeasurementInstance<L, AvailType<L>>, Avail> storage = new HashMap<MeasurementInstance<L, AvailType<L>>, Avail>();

    public AddResult<L> addAvail(MeasurementInstance<L, AvailType<L>> measurementInstance, Avail avail) {
        Avail previousAvail = this.storage.get(measurementInstance);
        AddResult.Effect effect = previousAvail == null ? AddResult.Effect.STARTING : (avail == previousAvail ? AddResult.Effect.UNCHANGED : AddResult.Effect.MODIFIED);
        this.storage.put(measurementInstance, avail);
        return new AddResult<L>(measurementInstance, avail, effect);
    }

    public static class AddResult<L> {
        private final MeasurementInstance<L, AvailType<L>> measurementInstance;
        private final Avail avail;
        private final Effect effect;

        public AddResult(MeasurementInstance<L, AvailType<L>> measurementInstance, Avail avail, Effect effect) {
            this.measurementInstance = measurementInstance;
            this.avail = avail;
            this.effect = effect;
        }

        public MeasurementInstance<L, AvailType<L>> getMeasurementInstance() {
            return this.measurementInstance;
        }

        public Avail getAvail() {
            return this.avail;
        }

        public Effect getEffect() {
            return this.effect;
        }

        public static enum Effect {
            MODIFIED,
            UNCHANGED,
            STARTING;

        }
    }
}

