/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;

@ApiModel(description="Defines an type of operation that can be executed on resources of a resource type that contains this operation type. The operation type contains \"returnType\" and \"parameterTypes\" data entities which correspond to JSON schemas of values expected during the operation execution.", parent=Entity.class)
public final class OperationType
extends Entity {
    public static final SegmentType SEGMENT_TYPE = SegmentType.ot;

    private OperationType() {
    }

    public OperationType(CanonicalPath path) {
        super(path);
    }

    public OperationType(String name, CanonicalPath path) {
        super(name, path);
    }

    public OperationType(CanonicalPath path, Map<String, Object> properties) {
        super(path, properties);
    }

    public OperationType(String name, CanonicalPath path, Map<String, Object> properties) {
        super(name, path, properties);
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitOperationType(this, parameter);
    }

    @ApiModel(value="OperationTypeBlueprint")
    public static final class Blueprint
    extends Entity.Blueprint {
        public static Builder builder() {
            return new Builder();
        }

        private Blueprint() {
        }

        public Blueprint(String id, Map<String, Object> properties) {
            super(id, properties);
        }

        public Blueprint(String id, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, properties, outgoing, incoming);
        }

        public Blueprint(String id, String name, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, name, properties, outgoing, incoming);
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitOperationType(this, parameter);
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            @Override
            public Blueprint build() {
                return new Blueprint(this.id, this.name, this.properties, this.outgoing, this.incoming);
            }
        }
    }
}

