/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;

public class InventoryIdUtil {
    public static ResourceIdParts parseResourceId(String resourceId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Invalid resource ID - cannot be null");
        }
        String[] parts = resourceId.split("~", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Cannot parse invalid ID: " + resourceId);
        }
        return new ResourceIdParts(parts[0], parts[1]);
    }

    public static ID generateResourceId(MonitoredEndpoint endpoint, String idPart) {
        ID id = new ID(String.format("%s~%s", endpoint.getName(), idPart));
        return id;
    }

    public static ID generateMetricInstanceId(String feedId, ID resourceId, MetricType<?> metricType) {
        ID id = new ID(String.format("MI~R~[%s~%s]~MT~%s", feedId, resourceId, metricType.getName()));
        return id;
    }

    public static ID generateAvailInstanceId(String feedId, ID resourceId, AvailType<?> availType) {
        ID id = new ID(String.format("AI~R~[%s~%s]~AT~%s", feedId, resourceId, availType.getName()));
        return id;
    }

    public static class ResourceIdParts {
        private final String managedServerName;
        private final String idPart;

        private ResourceIdParts(String managedServerName, String idPart) {
            this.managedServerName = managedServerName;
            this.idPart = idPart;
        }

        public String getManagedServerName() {
            return this.managedServerName;
        }

        public String getIdPart() {
            return this.idPart;
        }
    }
}

