/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.InventoryListener;
import org.hawkular.agent.monitor.api.SamplingService;
import org.hawkular.agent.monitor.diagnostics.ProtocolDiagnostics;
import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.inventory.ResourceType;
import org.hawkular.agent.monitor.inventory.ResourceTypeManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.Discovery;
import org.hawkular.agent.monitor.protocol.Driver;
import org.hawkular.agent.monitor.protocol.LocationResolver;
import org.hawkular.agent.monitor.protocol.Session;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.MetricDataPoint;
import org.hawkular.agent.monitor.util.Consumer;

public abstract class EndpointService<L, S extends Session<L>>
implements SamplingService<L> {
    private static final MsgLogger log = AgentLoggers.getLogger(EndpointService.class);
    private final MonitoredEndpoint endpoint;
    private final String feedId;
    private final InventoryListenerSupport inventoryListenerSupport = new InventoryListenerSupport();
    private final ResourceManager<L> resourceManager;
    private final ResourceTypeManager<L> resourceTypeManager;
    private final LocationResolver<L> locationResolver;
    private final ProtocolDiagnostics diagnostics;
    protected volatile ServiceStatus status = ServiceStatus.INITIAL;

    private static double toDouble(Object valueObject) {
        double value = valueObject == null ? Double.NaN : (valueObject instanceof Number ? ((Number)valueObject).doubleValue() : Double.valueOf(valueObject.toString()).doubleValue());
        return value;
    }

    public EndpointService(String feedId, MonitoredEndpoint endpoint, ResourceTypeManager<L> resourceTypeManager, LocationResolver<L> locationResolver, ProtocolDiagnostics diagnostics) {
        this.feedId = feedId;
        this.endpoint = endpoint;
        this.resourceManager = new ResourceManager();
        this.resourceTypeManager = resourceTypeManager;
        this.locationResolver = locationResolver;
        this.diagnostics = diagnostics;
    }

    public void addInventoryListener(InventoryListener listener) {
        this.status.assertInitialOrStopped(this.getClass(), "addInventoryListener()");
        this.inventoryListenerSupport.inventoryListeners.add(listener);
        log.debugf("Added inventory listener [%s] for endpoint [%s]", listener, this.getEndpoint());
    }

    public abstract S openSession();

    public void discoverAll() {
        this.status.assertRunning(this.getClass(), "discoverAll()");
        this.doDiscoverAll();
    }

    public void discoverChildren(L parentLocation, ResourceType<L> childType) {
        this.status.assertRunning(this.getClass(), "discoverChildren()");
        Discovery<L> discovery = new Discovery<L>();
        try (S session = this.openSession();){
            List<Resource<L>> parents = this.resourceManager.findResources(parentLocation, ((Session)session).getLocationResolver());
            final ArrayList added = new ArrayList();
            for (Resource<L> parent : parents) {
                discovery.discoverChildren(parent, childType, (Session<L>)session, new Consumer<Resource<L>>(){

                    @Override
                    public void accept(Resource<L> resource) {
                        EndpointService.this.resourceManager.addResource(resource);
                        added.add(resource);
                    }

                    @Override
                    public void report(Throwable e) {
                        log.errorCouldNotAccess(EndpointService.this, e);
                    }
                });
            }
            this.inventoryListenerSupport.fireResourcesAdded(Collections.unmodifiableList(added));
        }
        catch (Exception e) {
            log.errorCouldNotAccess(this, e);
        }
    }

    private void doDiscoverAll() {
        log.debugf("Being asked to discover all resources for endpoint [%s]", this.getEndpoint());
        Discovery discovery = new Discovery();
        long duration = 0L;
        final ArrayList resources = new ArrayList();
        try (S session = this.openSession();){
            long start = System.currentTimeMillis();
            discovery.discoverAllResources(session, new Consumer<Resource<L>>(){

                @Override
                public void accept(Resource<L> resource) {
                    resources.add(resource);
                }

                @Override
                public void report(Throwable e) {
                    log.errorCouldNotAccess(EndpointService.this, e);
                }
            });
            duration = System.currentTimeMillis() - start;
        }
        catch (Exception e) {
            log.errorCouldNotAccess(this, e);
        }
        this.resourceManager.replaceResources(resources);
        this.resourceManager.logTreeGraph("Discovered all resources for [" + this.endpoint + "]", duration);
        this.inventoryListenerSupport.fireDiscoverAllFinished(resources);
    }

    private String generateMeasurementKey(MeasurementInstance<L, ?> instance) {
        String key = instance.getID().getIDString();
        return key;
    }

    @Override
    public MonitoredEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getFeedId() {
        return this.feedId;
    }

    public ResourceManager<L> getResourceManager() {
        return this.resourceManager;
    }

    public ResourceTypeManager<L> getResourceTypeManager() {
        return this.resourceTypeManager;
    }

    public LocationResolver<L> getLocationResolver() {
        return this.locationResolver;
    }

    public ProtocolDiagnostics getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    public void measureAvails(Collection<MeasurementInstance<L, AvailType<L>>> instances, Consumer<AvailDataPoint> consumer) {
        this.status.assertRunning(this.getClass(), "measureAvails()");
        log.debugf("Checking [%d] avails for endpoint [%s]", instances.size(), this.getEndpoint());
        try (S session = this.openSession();){
            Driver driver = ((Session)session).getDriver();
            for (MeasurementInstance<L, AvailType<L>> instance : instances) {
                AttributeLocation location = instance.getAttributeLocation();
                Object o = driver.fetchAttribute(location);
                Pattern pattern = ((AvailType)instance.getType()).getUpPattern();
                Avail avail = null;
                if (o instanceof List) {
                    List list = (List)o;
                    for (Object item : list) {
                        Avail a = this.toAvail(pattern, item);
                        if (avail == null) {
                            avail = a;
                            continue;
                        }
                        avail = a == Avail.DOWN ? Avail.DOWN : avail;
                    }
                } else {
                    avail = this.toAvail(((AvailType)instance.getType()).getUpPattern(), o);
                }
                long ts = System.currentTimeMillis();
                String key = this.generateMeasurementKey(instance);
                AvailDataPoint dataPoint = new AvailDataPoint(key, ts, avail);
                consumer.accept(dataPoint);
            }
        }
        catch (Exception e) {
            log.errorCouldNotAccess(this, e);
        }
    }

    @Override
    public void measureMetrics(Collection<MeasurementInstance<L, MetricType<L>>> instances, Consumer<MetricDataPoint> consumer) {
        this.status.assertRunning(this.getClass(), "measureMetrics()");
        log.debugf("Collecting [%d] metrics for endpoint [%s]", instances.size(), this.getEndpoint());
        try (S session = this.openSession();){
            Driver driver = ((Session)session).getDriver();
            for (MeasurementInstance<L, MetricType<L>> instance : instances) {
                AttributeLocation location = instance.getAttributeLocation();
                Object o = driver.fetchAttribute(location);
                double value = 0.0;
                if (o instanceof List) {
                    List list = (List)o;
                    for (Object item : list) {
                        double num = EndpointService.toDouble(item);
                        value += num;
                    }
                } else {
                    value = EndpointService.toDouble(o);
                }
                long ts = System.currentTimeMillis();
                String key = this.generateMeasurementKey(instance);
                MetricDataPoint dataPoint = new MetricDataPoint(key, ts, value, ((MetricType)instance.getType()).getMetricType());
                consumer.accept(dataPoint);
            }
        }
        catch (Exception e) {
            log.errorCouldNotAccess(this, e);
        }
    }

    public void removeInventoryListener(InventoryListener listener) {
        this.status.assertInitialOrStopped(this.getClass(), "removeInventoryListener()");
        this.inventoryListenerSupport.inventoryListeners.remove(listener);
        log.debugf("Removed inventory listener [%s] for endpoint [%s]", listener, this.getEndpoint());
    }

    public void removeResources(L location) {
        this.status.assertRunning(this.getClass(), "removeResources()");
        try (S session = this.openSession();){
            List<Resource<L>> removed = this.resourceManager.removeResources(location, ((Session)session).getLocationResolver());
            this.inventoryListenerSupport.fireResourcesRemoved(removed);
        }
        catch (Exception e) {
            log.errorCouldNotAccess(this, e);
        }
    }

    public final void start() {
        this.status.assertInitialOrStopped(this.getClass(), "start()");
        this.status = ServiceStatus.STARTING;
        this.doDiscoverAll();
        this.status = ServiceStatus.RUNNING;
        log.debugf("Started [%s]", this.toString());
    }

    public void stop() {
        this.status.assertRunning(this.getClass(), "stop()");
        this.status = ServiceStatus.STOPPING;
        this.status = ServiceStatus.STOPPED;
        log.debugf("Stopped [%s]", this.toString());
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.getEndpoint());
    }

    private Avail toAvail(Pattern pattern, Object value) {
        if (pattern == null) {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? Avail.UP : Avail.DOWN;
            }
            if (value instanceof String) {
                return AvailType.getDefaultUpPattern().matcher((String)value).matches() ? Avail.UP : Avail.DOWN;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue() == 0 ? Avail.DOWN : Avail.UP;
            }
            throw new RuntimeException("Cannot handle an availability value of type [" + value.getClass().getName() + "]");
        }
        return pattern.matcher(String.valueOf(value)).matches() ? Avail.UP : Avail.DOWN;
    }

    private class InventoryListenerSupport {
        private final List<InventoryListener> inventoryListeners = new ArrayList<InventoryListener>();

        public void fireDiscoverAllFinished(List<Resource<L>> resources) {
            InventoryEvent event = new InventoryEvent(EndpointService.this.feedId, EndpointService.this.endpoint, EndpointService.this, resources);
            for (InventoryListener inventoryListener : this.inventoryListeners) {
                inventoryListener.discoverAllFinished(event);
            }
        }

        public void fireResourcesAdded(List<Resource<L>> resources) {
            InventoryEvent event = new InventoryEvent(EndpointService.this.feedId, EndpointService.this.endpoint, EndpointService.this, resources);
            for (InventoryListener inventoryListener : this.inventoryListeners) {
                inventoryListener.resourcesAdded(event);
            }
        }

        public void fireResourcesRemoved(List<Resource<L>> resources) {
            InventoryEvent event = new InventoryEvent(EndpointService.this.feedId, EndpointService.this.endpoint, EndpointService.this, resources);
            for (InventoryListener inventoryListener : this.inventoryListeners) {
                inventoryListener.resourceRemoved(event);
            }
        }
    }
}

