/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.hawkular.agent.monitor.api.InventoryListener;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.ResourceTypeManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.protocol.Session;
import org.hawkular.agent.monitor.protocol.dmr.DMREndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.agent.monitor.protocol.dmr.ModelControllerClientFactory;
import org.hawkular.agent.monitor.protocol.jmx.JMXEndpointService;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.hawkular.agent.monitor.protocol.jmx.JMXSession;
import org.hawkular.agent.monitor.protocol.platform.PlatformEndpointService;
import org.hawkular.agent.monitor.protocol.platform.PlatformNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.PlatformSession;
import org.jboss.msc.value.InjectedValue;

public class ProtocolServices {
    private static final MsgLogger log = AgentLoggers.getLogger(ProtocolServices.class);
    private final ProtocolService<DMRNodeLocation, DMRSession> dmrProtocolService;
    private final ProtocolService<JMXNodeLocation, JMXSession> jmxProtocolService;
    private final ProtocolService<PlatformNodeLocation, PlatformSession> platformProtocolService;
    private final List<ProtocolService<?, ?>> services;

    public static Builder builder(String feedId, Diagnostics diagnostics, Map<String, InjectedValue<SSLContext>> sslContexts) {
        return new Builder(feedId, sslContexts, diagnostics);
    }

    public ProtocolServices(ProtocolService<DMRNodeLocation, DMRSession> dmrProtocolService, ProtocolService<JMXNodeLocation, JMXSession> jmxProtocolService, ProtocolService<PlatformNodeLocation, PlatformSession> platformProtocolService) {
        this.dmrProtocolService = dmrProtocolService;
        this.jmxProtocolService = jmxProtocolService;
        this.platformProtocolService = platformProtocolService;
        this.services = Collections.unmodifiableList(Arrays.asList(dmrProtocolService, jmxProtocolService, platformProtocolService));
    }

    public <L, S extends Session<L>> EndpointService<L, S> getEndpointService(String endpointName) {
        for (ProtocolService<?, ?> service : this.services) {
            EndpointService<?, ?> result = service.getEndpointServices().get(endpointName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void start() {
        for (ProtocolService<?, ?> service : this.services) {
            service.start();
        }
    }

    public void discoverAll() {
        for (ProtocolService<?, ?> service : this.services) {
            service.discoverAll();
        }
    }

    public void stop() {
        for (ProtocolService<?, ?> service : this.services) {
            service.stop();
        }
    }

    public void addInventoryListener(InventoryListener listener) {
        for (ProtocolService<?, ?> service : this.services) {
            service.addInventoryListener(listener);
        }
    }

    public void removeInventoryListener(InventoryListener listener) {
        for (ProtocolService<?, ?> service : this.services) {
            service.removeInventoryListener(listener);
        }
    }

    public ProtocolService<DMRNodeLocation, DMRSession> getDmrProtocolService() {
        return this.dmrProtocolService;
    }

    public ProtocolService<JMXNodeLocation, JMXSession> getJmxProtocolService() {
        return this.jmxProtocolService;
    }

    public ProtocolService<PlatformNodeLocation, PlatformSession> getPlatformProtocolService() {
        return this.platformProtocolService;
    }

    public List<ProtocolService<?, ?>> getServices() {
        return this.services;
    }

    public static class Builder {
        private final String feedId;
        private ProtocolService<DMRNodeLocation, DMRSession> dmrProtocolService;
        private ProtocolService<JMXNodeLocation, JMXSession> jmxProtocolService;
        private ProtocolService<PlatformNodeLocation, PlatformSession> platformProtocolService;
        private final Map<String, InjectedValue<SSLContext>> sslContexts;
        private final Diagnostics diagnostics;

        public Builder(String feedId, Map<String, InjectedValue<SSLContext>> sslContexts, Diagnostics diagnostics) {
            this.feedId = feedId;
            this.sslContexts = sslContexts;
            this.diagnostics = diagnostics;
        }

        public ProtocolServices build() {
            return new ProtocolServices(this.dmrProtocolService, this.jmxProtocolService, this.platformProtocolService);
        }

        public Builder dmrProtocolService(ModelControllerClientFactory localModelControllerClientFactory, MonitorServiceConfiguration.ProtocolConfiguration<DMRNodeLocation> protocolConfig) {
            ProtocolService.Builder<DMRNodeLocation, DMRSession> builder = ProtocolService.builder();
            for (MonitorServiceConfiguration.EndpointConfiguration server : protocolConfig.getEndpoints().values()) {
                if (!server.isEnabled()) {
                    log.infoManagedServerDisabled(server.getName().toString());
                    continue;
                }
                String securityRealm = server.getSecurityRealm();
                SSLContext sslContext = securityRealm != null ? (SSLContext)this.sslContexts.get(server.getSecurityRealm()).getOptionalValue() : null;
                MonitoredEndpoint endpoint = MonitoredEndpoint.of(server, sslContext);
                ModelControllerClientFactory clientFactory = server.isLocal() ? localModelControllerClientFactory : ModelControllerClientFactory.createRemote(endpoint);
                ResourceTypeManager<DMRNodeLocation> resourceTypeManager = new ResourceTypeManager<DMRNodeLocation>(protocolConfig.getTypeSets().getResourceTypeSets(), server.getResourceTypeSets());
                DMREndpointService endpointService = new DMREndpointService(this.feedId, endpoint, resourceTypeManager, clientFactory, this.diagnostics.getDMRDiagnostics());
                builder.endpointService(endpointService);
                log.debugf("[%s] created with resource type sets [%s]", endpointService, server.getResourceTypeSets());
            }
            this.dmrProtocolService = builder.build();
            return this;
        }

        public Builder jmxProtocolService(MonitorServiceConfiguration.ProtocolConfiguration<JMXNodeLocation> protocolConfig) {
            ProtocolService.Builder<JMXNodeLocation, JMXSession> builder = ProtocolService.builder();
            for (MonitorServiceConfiguration.EndpointConfiguration server : protocolConfig.getEndpoints().values()) {
                if (!server.isEnabled()) continue;
                String securityRealm = server.getSecurityRealm();
                SSLContext sslContext = securityRealm != null ? (SSLContext)this.sslContexts.get(server.getSecurityRealm()).getOptionalValue() : null;
                MonitoredEndpoint endpoint = MonitoredEndpoint.of(server, sslContext);
                ResourceTypeManager<JMXNodeLocation> resourceTypeManager = new ResourceTypeManager<JMXNodeLocation>(protocolConfig.getTypeSets().getResourceTypeSets(), server.getResourceTypeSets());
                JMXEndpointService endpointService = new JMXEndpointService(this.feedId, endpoint, resourceTypeManager, this.diagnostics.getJMXDiagnostics());
                builder.endpointService(endpointService);
                log.debugf("[%s] created with resource type sets [%s]", endpointService, server.getResourceTypeSets());
            }
            this.jmxProtocolService = builder.build();
            return this;
        }

        public Builder platformProtocolService(MonitorServiceConfiguration.ProtocolConfiguration<PlatformNodeLocation> protocolConfig) {
            ProtocolService.Builder<PlatformNodeLocation, PlatformSession> builder = ProtocolService.builder();
            for (MonitorServiceConfiguration.EndpointConfiguration server : protocolConfig.getEndpoints().values()) {
                if (!server.isEnabled()) continue;
                String securityRealm = server.getSecurityRealm();
                SSLContext sslContext = securityRealm != null ? (SSLContext)this.sslContexts.get(server.getSecurityRealm()).getOptionalValue() : null;
                MonitoredEndpoint endpoint = MonitoredEndpoint.of(server, sslContext);
                ResourceTypeManager<PlatformNodeLocation> resourceTypeManager = new ResourceTypeManager<PlatformNodeLocation>(protocolConfig.getTypeSets().getResourceTypeSets(), server.getResourceTypeSets());
                PlatformEndpointService endpointService = new PlatformEndpointService(this.feedId, endpoint, resourceTypeManager, this.diagnostics.getPlatformDiagnostics());
                builder.endpointService(endpointService);
                log.debugf("[%s] created with resource type sets [%s]", endpointService, server.getResourceTypeSets());
            }
            this.platformProtocolService = builder.build();
            return this;
        }
    }
}

