/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.dmr;

import java.util.ArrayList;
import org.hawkular.agent.monitor.protocol.LocationResolver;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DMRLocationResolver
implements LocationResolver<DMRNodeLocation> {
    private static boolean matches(int length, PathAddress pattern, PathAddress address) {
        for (int i = 0; i < length; ++i) {
            PathElement otherElem = address.getElement(i);
            Property prop = new Property(otherElem.getKey(), new ModelNode(otherElem.getValue()));
            if (pattern.getElement(i).matches(prop)) continue;
            return false;
        }
        return true;
    }

    @Override
    public DMRNodeLocation absolutize(DMRNodeLocation base, DMRNodeLocation location) {
        if (base == null || base.getPathAddress().equals(PathAddress.EMPTY_ADDRESS)) {
            return location;
        }
        PathAddress basePath = base.getPathAddress();
        PathAddress path = location.getPathAddress();
        if (path.equals(PathAddress.EMPTY_ADDRESS)) {
            return base;
        }
        ArrayList<PathElement> segments = new ArrayList<PathElement>(basePath.size() + path.size());
        for (PathElement segment : basePath) {
            segments.add(segment);
        }
        for (PathElement segment : path) {
            segments.add(segment);
        }
        PathAddress absPath = PathAddress.pathAddress(segments);
        return new DMRNodeLocation(absPath);
    }

    @Override
    public boolean isParent(DMRNodeLocation parent, DMRNodeLocation child) {
        if (child == null) {
            throw new IllegalArgumentException("Cannot compute [" + this.getClass().getName() + "].isParent() with a null child argument");
        }
        PathAddress parentPath = parent.getPathAddress();
        PathAddress childPath = child.getPathAddress();
        int parentLength = parentPath.size();
        if (parentLength <= childPath.size()) {
            return DMRLocationResolver.matches(parentLength, parentPath, childPath);
        }
        return false;
    }

    @Override
    public boolean matches(DMRNodeLocation query, DMRNodeLocation location) {
        if (query == null) {
            throw new IllegalArgumentException("Cannot compute [" + this.getClass().getName() + "].matches() with a null query argument");
        }
        PathAddress queryPath = query.getPathAddress();
        PathAddress path = location.getPathAddress();
        int queryLength = queryPath.size();
        if (queryLength == path.size()) {
            return DMRLocationResolver.matches(queryLength, queryPath, path);
        }
        return false;
    }

    @Override
    public String applyTemplate(String nameTemplate, DMRNodeLocation location, String endpointName) {
        ArrayList<String> args = new ArrayList<String>();
        for (PathElement segment : location.getPathAddress()) {
            args.add(segment.getKey());
            args.add(segment.getValue());
        }
        nameTemplate = nameTemplate.replaceAll("%(\\d+)", "%$1\\$s");
        nameTemplate = nameTemplate.replaceAll("%(-)", "%" + args.size() + "\\$s");
        nameTemplate = nameTemplate.replaceAll("%ManagedServerName", endpointName);
        String nameStr = String.format(nameTemplate, args.toArray());
        return nameStr;
    }
}

