/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.hawkular.agent.monitor.api.SamplingService;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.Interval;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.MeasurementType;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.DataPoint;
import org.hawkular.agent.monitor.storage.MetricDataPoint;
import org.hawkular.agent.monitor.util.Consumer;
import org.hawkular.agent.monitor.util.ThreadFactoryGenerator;

public abstract class IntervalBasedScheduler<T extends MeasurementType<Object>, D extends DataPoint> {
    private static final MsgLogger log = AgentLoggers.getLogger(IntervalBasedScheduler.class);
    private final String name;
    private final ScheduledExecutorService executorService;
    private final Map<MonitoredEndpoint, List<ScheduledFuture<?>>> jobs = new HashMap();
    private final Consumer<D> completionHandler;
    protected volatile ServiceStatus status = ServiceStatus.INITIAL;

    public static IntervalBasedScheduler<MetricType<Object>, MetricDataPoint> forMetrics(String name, int schedulerThreads, Consumer<MetricDataPoint> completionHandler) {
        return new IntervalBasedScheduler<MetricType<Object>, MetricDataPoint>(name, schedulerThreads, completionHandler){

            @Override
            protected <L, MT extends MeasurementType<L>> Runnable createJob(SamplingService<L> endpointService, Collection<MeasurementInstance<L, MT>> instances, Consumer<MetricDataPoint> completionHandler) {
                Collection insts = instances;
                return new MetricsJob<L>(endpointService, insts, completionHandler);
            }

            @Override
            protected <L, MT extends MeasurementType<L>> Collection<MeasurementInstance<L, MT>> getMeasurementInstances(Resource<L> resource) {
                return resource.getMetrics();
            }
        };
    }

    public static IntervalBasedScheduler<AvailType<Object>, AvailDataPoint> forAvails(String name, int schedulerThreads, Consumer<AvailDataPoint> completionHandler) {
        return new IntervalBasedScheduler<AvailType<Object>, AvailDataPoint>(name, schedulerThreads, completionHandler){

            @Override
            protected <L, MT extends MeasurementType<L>> Runnable createJob(SamplingService<L> endpointService, Collection<MeasurementInstance<L, MT>> instances, Consumer<AvailDataPoint> completionHandler) {
                Collection insts = instances;
                return new AvailsJob<L>(endpointService, insts, completionHandler);
            }

            @Override
            protected <L, MT extends MeasurementType<L>> Collection<MeasurementInstance<L, MT>> getMeasurementInstances(Resource<L> resource) {
                return resource.getAvails();
            }
        };
    }

    private IntervalBasedScheduler(String name, int schedulerThreads, Consumer<D> completionHandler) {
        this.name = name;
        this.completionHandler = completionHandler;
        ThreadFactory threadFactory = ThreadFactoryGenerator.generateFactory(true, name);
        this.executorService = Executors.newScheduledThreadPool(schedulerThreads, threadFactory);
    }

    public <L, TT extends MeasurementType<L>> void rescheduleAll(SamplingService<L> endpointService, List<Resource<L>> resources) {
        this.status.assertRunning(this.getClass(), "rescheduleAll()");
        MonitoredEndpoint endpoint = endpointService.getEndpoint();
        List<ScheduledFuture<?>> oldJobs = this.jobs.get(endpoint);
        if (oldJobs != null) {
            log.debugf("Scheduler [%s]: canceling [%d] jobs for endpoint [%s]", this.name, oldJobs.size(), endpointService);
            for (ScheduledFuture<?> oldJob : oldJobs) {
                oldJob.cancel(false);
            }
        }
        ArrayList endpointJobs = new ArrayList();
        HashMap instancesByInterval = new HashMap();
        for (Resource<L> resource : resources) {
            Collection resourceInstances = this.getMeasurementInstances(resource);
            for (MeasurementInstance instance : resourceInstances) {
                Interval interval = ((MeasurementType)instance.getType()).getInterval();
                ArrayList instances = (ArrayList)instancesByInterval.get(interval);
                if (instances == null) {
                    instances = new ArrayList();
                    instancesByInterval.put(interval, instances);
                }
                instances.add(instance);
            }
        }
        int measurementInstances = 0;
        for (Map.Entry en : instancesByInterval.entrySet()) {
            Interval interval = (Interval)en.getKey();
            Collection instances = (Collection)en.getValue();
            ScheduledFuture<?> future = this.executorService.scheduleWithFixedDelay(this.createJob(endpointService, instances, this.completionHandler), 0L, interval.millis(), TimeUnit.MILLISECONDS);
            endpointJobs.add(future);
            measurementInstances += instances.size();
        }
        this.jobs.put(endpointService.getEndpoint(), endpointJobs);
        log.debugf("Scheduler [%s]: [%d] jobs ([%d] measurements) have been submitted for endpoint [%s]", new Object[]{this.name, endpointJobs.size(), measurementInstances, endpointService});
    }

    public <L, TT extends MeasurementType<L>> void schedule(SamplingService<L> endpointService, List<Resource<L>> resources) {
        this.status.assertRunning(this.getClass(), "schedule()");
        log.warn("TODO: SCHEDULE() IS NOT IMPLEMENTED");
    }

    public <L, TT extends MeasurementType<L>> void unschedule(SamplingService<L> endpointService, List<Resource<L>> resources) {
        this.status.assertRunning(this.getClass(), "unschedule()");
        log.warn("TODO: UNSCHEDULE() IS NOT IMPLEMENTED");
    }

    protected abstract <L, MT extends MeasurementType<L>> Runnable createJob(SamplingService<L> var1, Collection<MeasurementInstance<L, MT>> var2, Consumer<D> var3);

    protected abstract <L, MT extends MeasurementType<L>> Collection<MeasurementInstance<L, MT>> getMeasurementInstances(Resource<L> var1);

    public void start() {
        this.status.assertInitialOrStopped(this.getClass(), "start()");
        this.status = ServiceStatus.STARTING;
        this.status = ServiceStatus.RUNNING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.status.assertRunning(this.getClass(), "stop()");
        this.status = ServiceStatus.STOPPING;
        log.infof("Stopping scheduler [%s] and its [%d] jobs", this.name, this.jobs.size());
        try {
            for (List<ScheduledFuture<?>> perEndpointJobs : this.jobs.values()) {
                for (ScheduledFuture<?> job : perEndpointJobs) {
                    job.cancel(false);
                }
            }
            this.executorService.shutdown();
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            log.infof("Scheduler [%s] stopped", this.name);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.status = ServiceStatus.STOPPED;
        }
    }

    private static class AvailsJob<L>
    implements Runnable {
        private final SamplingService<L> endpointService;
        private final Collection<MeasurementInstance<L, AvailType<L>>> instances;
        private final Consumer<AvailDataPoint> completionHandler;

        public AvailsJob(SamplingService<L> endpointService, Collection<MeasurementInstance<L, AvailType<L>>> instances, Consumer<AvailDataPoint> completionHandler) {
            this.endpointService = endpointService;
            this.instances = instances;
            this.completionHandler = completionHandler;
        }

        @Override
        public void run() {
            try {
                this.endpointService.measureAvails(this.instances, new Consumer<AvailDataPoint>(){

                    @Override
                    public void accept(AvailDataPoint dataPoint) {
                        completionHandler.accept(dataPoint);
                    }

                    @Override
                    public void report(Throwable e) {
                        log.errorFailedToStoreAvails(endpointService.toString(), e);
                    }
                });
            }
            catch (IllegalStateException ise) {
                log.debugf("Cannot check avails for endpoint [%s] - not ready yet: %s", this.endpointService, ise);
            }
            catch (Throwable t) {
                log.warnf(t, "Unexpected error caught in AvailsJob for endpoint [%s]", this.endpointService);
            }
        }
    }

    private static class MetricsJob<L>
    implements Runnable {
        private final SamplingService<L> endpointService;
        private final Collection<MeasurementInstance<L, MetricType<L>>> instances;
        private final Consumer<MetricDataPoint> completionHandler;

        public MetricsJob(SamplingService<L> endpointService, Collection<MeasurementInstance<L, MetricType<L>>> instances, Consumer<MetricDataPoint> completionHandler) {
            this.endpointService = endpointService;
            this.instances = instances;
            this.completionHandler = completionHandler;
        }

        @Override
        public void run() {
            try {
                this.endpointService.measureMetrics(this.instances, new Consumer<MetricDataPoint>(){

                    @Override
                    public void accept(MetricDataPoint dataPoint) {
                        completionHandler.accept(dataPoint);
                    }

                    @Override
                    public void report(Throwable e) {
                        log.errorFailedToStoreMetrics(endpointService.toString(), e);
                    }
                });
            }
            catch (IllegalStateException ise) {
                log.debugf("Cannot collect metrics for endpoint [%s] - not ready yet: %s", this.endpointService, ise);
            }
            catch (Throwable t) {
                log.warnf(t, "Unexpected error caught in MetricsJob for endpoint [%s]", this.endpointService);
            }
        }
    }
}

