/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementTypeVisitor;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.model.Tenant;

public final class CanonicalPath
extends Path
implements Iterable<CanonicalPath>,
Serializable {
    static final Map<String, Class<?>> SHORT_NAME_TYPES = new HashMap();
    static final Map<Class<?>, String> SHORT_TYPE_NAMES = new HashMap();
    static final Map<Class<?>, List<Class<?>>> VALID_PROGRESSIONS = new HashMap();

    private CanonicalPath() {
    }

    CanonicalPath(int myIdx, List<Path.Segment> path) {
        super(0, myIdx, path);
    }

    CanonicalPath(int startIdx, int myIdx, List<Path.Segment> path) {
        this(myIdx, path);
    }

    public static Extender empty() {
        return new Extender(0, new ArrayList<Path.Segment>());
    }

    public static Builder of() {
        return new Builder((List)new ArrayList());
    }

    public static CanonicalPath fromString(String path) {
        return CanonicalPath.fromPartiallyUntypedString(path, new Path.StructuredDataHintingTypeProvider());
    }

    public static CanonicalPath fromPartiallyUntypedString(String path, Path.TypeProvider typeProvider) {
        return (CanonicalPath)Path.fromString(path, true, Extender::new, new CanonicalTypeProvider(typeProvider));
    }

    public static CanonicalPath fromPartiallyUntypedString(String path, CanonicalPath initialPosition, Class<?> intendedFinalType) {
        Path.ExtenderConstructor ctor = (idx, list) -> {
            if (initialPosition != null) {
                list.addAll(initialPosition.getPath());
            }
            return new Extender(idx, list);
        };
        return (CanonicalPath)Path.fromString(path, true, ctor, new CanonicalTypeProvider(new Path.HintedTypeProvider(intendedFinalType, new Extender(0, initialPosition == null ? new ArrayList<Path.Segment>() : new ArrayList<Path.Segment>(initialPosition.getPath())))));
    }

    public <R, P> R accept(ElementTypeVisitor<R, P> visitor, P parameter) {
        return this.getSegment().accept(visitor, parameter);
    }

    @Override
    public CanonicalPath toCanonicalPath() {
        return this;
    }

    @Override
    public RelativePath toRelativePath() {
        return ((RelativePath.Extender)RelativePath.empty().extend(this.getPath())).get();
    }

    public Iterator<CanonicalPath> ascendingIterator() {
        return super.ascendingIterator();
    }

    public Iterator<CanonicalPath> descendingIterator() {
        return super.descendingIterator();
    }

    @Override
    public CanonicalPath down() {
        return (CanonicalPath)super.down();
    }

    @Override
    public CanonicalPath down(int distance) {
        return (CanonicalPath)super.down(distance);
    }

    @Override
    protected CanonicalPath newInstance(int startIdx, int endIdx, List<Path.Segment> segments) {
        return new CanonicalPath(startIdx, endIdx, segments);
    }

    @Override
    public CanonicalPath up() {
        return (CanonicalPath)super.up();
    }

    @Override
    public CanonicalPath up(int distance) {
        return (CanonicalPath)super.up(distance);
    }

    public CanonicalPath getRoot() {
        return new CanonicalPath(1, this.path);
    }

    public CanonicalPath getLeaf() {
        return new CanonicalPath(this.path.size(), this.path);
    }

    public boolean isParentOf(CanonicalPath other) {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        if (other.path.size() <= this.path.size()) {
            return false;
        }
        for (int i = 0; i < this.path.size(); ++i) {
            Path.Segment otherSeg;
            Path.Segment mySeg = (Path.Segment)this.path.get(i);
            if (mySeg.equals(otherSeg = (Path.Segment)other.path.get(i))) continue;
            return false;
        }
        return true;
    }

    public Extender extend(Class<?> type, String id) {
        return this.modified().extend(new Path.Segment(type, id));
    }

    public Extender modified() {
        return new Extender(this.startIdx, new ArrayList<Path.Segment>(this.getPath()));
    }

    public IdExtractor ids() {
        return new IdExtractor();
    }

    @Override
    public String toString() {
        return new Path.Encoder(SHORT_TYPE_NAMES, x -> true).encode(Character.toString('/'), this);
    }

    @Override
    public Iterator<CanonicalPath> iterator() {
        return this.ascendingIterator();
    }

    static {
        SHORT_NAME_TYPES.put("t", Tenant.class);
        SHORT_NAME_TYPES.put("e", Environment.class);
        SHORT_NAME_TYPES.put("f", Feed.class);
        SHORT_NAME_TYPES.put("m", Metric.class);
        SHORT_NAME_TYPES.put("r", Resource.class);
        SHORT_NAME_TYPES.put("rt", ResourceType.class);
        SHORT_NAME_TYPES.put("mt", MetricType.class);
        SHORT_NAME_TYPES.put("rl", Relationship.class);
        SHORT_NAME_TYPES.put("d", DataEntity.class);
        SHORT_NAME_TYPES.put("ot", OperationType.class);
        SHORT_NAME_TYPES.put("mp", MetadataPack.class);
        SHORT_TYPE_NAMES.put(Tenant.class, "t");
        SHORT_TYPE_NAMES.put(Environment.class, "e");
        SHORT_TYPE_NAMES.put(Feed.class, "f");
        SHORT_TYPE_NAMES.put(Metric.class, "m");
        SHORT_TYPE_NAMES.put(Resource.class, "r");
        SHORT_TYPE_NAMES.put(ResourceType.class, "rt");
        SHORT_TYPE_NAMES.put(MetricType.class, "mt");
        SHORT_TYPE_NAMES.put(Relationship.class, "rl");
        SHORT_TYPE_NAMES.put(DataEntity.class, "d");
        SHORT_TYPE_NAMES.put(OperationType.class, "ot");
        SHORT_TYPE_NAMES.put(MetadataPack.class, "mp");
        VALID_PROGRESSIONS.put(Tenant.class, Arrays.asList(Environment.class, MetricType.class, ResourceType.class, Feed.class, MetadataPack.class));
        VALID_PROGRESSIONS.put(Environment.class, Arrays.asList(Metric.class, Resource.class));
        VALID_PROGRESSIONS.put(Feed.class, Arrays.asList(Metric.class, Resource.class, MetricType.class, ResourceType.class));
        VALID_PROGRESSIONS.put(ResourceType.class, Arrays.asList(DataEntity.class, OperationType.class));
        VALID_PROGRESSIONS.put(OperationType.class, Collections.singletonList(DataEntity.class));
        VALID_PROGRESSIONS.put(Resource.class, Arrays.asList(Resource.class, DataEntity.class));
        VALID_PROGRESSIONS.put(DataEntity.class, Collections.singletonList(StructuredData.class));
        VALID_PROGRESSIONS.put(StructuredData.class, Collections.singletonList(StructuredData.class));
        VALID_PROGRESSIONS.put(null, Arrays.asList(Tenant.class, Relationship.class));
    }

    private static class CanonicalTypeProvider
    extends Path.EnhancedTypeProvider {
        private final Path.TypeProvider wrapped;

        private CanonicalTypeProvider(Path.TypeProvider wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void segmentParsed(Path.Segment segment) {
            if (this.wrapped != null) {
                this.wrapped.segmentParsed(segment);
            }
        }

        @Override
        public Path.Segment deduceSegment(String type, String id, boolean isLast) {
            if (type != null && !type.isEmpty()) {
                if (id == null || id.isEmpty()) {
                    return null;
                }
                return new Path.Segment(SHORT_NAME_TYPES.get(type), id);
            }
            if (id == null || id.isEmpty()) {
                return null;
            }
            Class<?> cls = SHORT_NAME_TYPES.get(id);
            if (cls == null && this.wrapped != null) {
                return this.wrapped.deduceSegment(type, id, isLast);
            }
            if (cls != null) {
                return new Path.Segment(cls, id);
            }
            return null;
        }

        @Override
        public void finished() {
            if (this.wrapped != null) {
                this.wrapped.finished();
            }
        }

        @Override
        Set<String> getValidTypeName() {
            return SHORT_NAME_TYPES.keySet();
        }
    }

    public static class Extender
    extends Path.Extender {
        Extender(int from, List<Path.Segment> segments) {
            super(from, segments, true, s -> s.isEmpty() ? Arrays.asList(Tenant.class, Relationship.class) : VALID_PROGRESSIONS.get(((Path.Segment)s.get(s.size() - 1)).getElementType()));
        }

        @Override
        protected CanonicalPath newPath(int startIdx, int endIdx, List<Path.Segment> segments) {
            return new CanonicalPath(startIdx, endIdx, segments);
        }

        @Override
        public Extender extend(Path.Segment segment) {
            return (Extender)super.extend(segment);
        }

        @Override
        public Extender extend(Collection<Path.Segment> segments) {
            return (Extender)super.extend(segments);
        }

        @Override
        public Extender extend(Class<? extends AbstractElement<?, ?>> type, String id) {
            return (Extender)super.extend(type, id);
        }

        @Override
        public CanonicalPath get() {
            return (CanonicalPath)super.get();
        }
    }

    public final class IdExtractor {
        public String getTenantId() {
            return this.idIfTypeCorrect(CanonicalPath.this.getRoot(), Tenant.class);
        }

        public String getEnvironmentId() {
            return this.idIfTypeCorrect(CanonicalPath.this.getRoot().down(), Environment.class);
        }

        public String getMetricTypeId() {
            if (this.getFeedId() != null) {
                return this.idIfTypeCorrect(CanonicalPath.this.getRoot().down(2), MetricType.class);
            }
            return this.idIfTypeCorrect(CanonicalPath.this.getRoot().down(), MetricType.class);
        }

        public String getResourceTypeId() {
            if (this.getFeedId() != null) {
                return this.idIfTypeCorrect(CanonicalPath.this.getRoot().down(2), ResourceType.class);
            }
            return this.idIfTypeCorrect(CanonicalPath.this.getRoot().down(), ResourceType.class);
        }

        public String getFeedId() {
            return this.idIfTypeCorrect(CanonicalPath.this.getRoot().down(), Feed.class);
        }

        public RelativePath getResourcePath() {
            int to;
            int from;
            List path = CanonicalPath.this.path;
            for (from = CanonicalPath.this.startIdx; from < CanonicalPath.this.endIdx && !Resource.class.equals(((Path.Segment)path.get(from)).getElementType()); ++from) {
            }
            if (from == path.size()) {
                return null;
            }
            for (to = from; to < CanonicalPath.this.endIdx && Resource.class.equals(((Path.Segment)path.get(to)).getElementType()); ++to) {
            }
            return new RelativePath(from, to, CanonicalPath.this.path);
        }

        public String getMetricId() {
            return this.idIfTypeCorrect(CanonicalPath.this, Metric.class);
        }

        public String getRelationshipId() {
            return this.idIfTypeCorrect(CanonicalPath.this.getRoot(), Relationship.class);
        }

        public String getOperationTypeId() {
            return this.idIfTypeCorrect(CanonicalPath.this, OperationType.class);
        }

        public <R extends DataEntity.Role> R getDataRole() {
            CanonicalPath currentPath = CanonicalPath.this;
            while (StructuredData.class.equals(currentPath.getSegment().getElementType())) {
                currentPath = currentPath.up();
            }
            String roleStr = this.idIfTypeCorrect(currentPath, DataEntity.class);
            return (R)(roleStr == null ? null : DataEntity.Role.valueOf(roleStr));
        }

        private String idIfTypeCorrect(CanonicalPath path, Class<? extends AbstractElement<?, ?>> desiredType) {
            if (path.isDefined() && path.getSegment().getElementType().equals(desiredType)) {
                return path.getSegment().getElementId();
            }
            return null;
        }
    }

    public static final class StructuredDataBuilder
    extends Path.StructuredDataBuilder<CanonicalPath, StructuredDataBuilder> {
        private StructuredDataBuilder(List<Path.Segment> segments) {
            super(segments, CanonicalPath::new);
        }
    }

    public static final class RelationshipBuilder
    extends Path.RelationshipBuilder<CanonicalPath> {
        private RelationshipBuilder(List<Path.Segment> segments) {
            super(segments, CanonicalPath::new);
        }
    }

    public static final class FeedBuilder
    extends Path.FeedBuilder<CanonicalPath, ResourceTypeBuilder, MetricTypeBuilder, ResourceBuilder, MetricBuilder, OperationTypeBuilder, StructuredDataBuilder> {
        private FeedBuilder(List<Path.Segment> list) {
            super(list, CanonicalPath::new);
        }

        @Override
        protected ResourceTypeBuilder resourceTypeBuilder(List<Path.Segment> segments) {
            return new ResourceTypeBuilder((List)segments);
        }

        @Override
        protected MetricTypeBuilder metricTypeBuilder(List<Path.Segment> segments) {
            return new MetricTypeBuilder((List)segments);
        }

        @Override
        protected ResourceBuilder resourceBuilder(List<Path.Segment> segments) {
            return new ResourceBuilder((List)segments);
        }

        @Override
        protected MetricBuilder metricBuilder(List<Path.Segment> segments) {
            return new MetricBuilder((List)segments);
        }
    }

    public static final class MetricBuilder
    extends Path.MetricBuilder<CanonicalPath> {
        private MetricBuilder(List<Path.Segment> segments) {
            super(segments, CanonicalPath::new);
        }
    }

    public static final class ResourceBuilder
    extends Path.ResourceBuilder<CanonicalPath, ResourceBuilder, StructuredDataBuilder> {
        private ResourceBuilder(List<Path.Segment> segments) {
            super(segments, CanonicalPath::new);
        }

        @Override
        protected StructuredDataBuilder structuredDataBuilder(List<Path.Segment> segments) {
            return new StructuredDataBuilder((List)segments);
        }
    }

    public static final class OperationTypeBuilder
    extends Path.OperationTypeBuilder<CanonicalPath, StructuredDataBuilder> {
        private OperationTypeBuilder(List<Path.Segment> segments) {
            super(segments, CanonicalPath::new);
        }

        @Override
        protected StructuredDataBuilder structuredDataBuilder(List<Path.Segment> segments) {
            return new StructuredDataBuilder((List)segments);
        }
    }

    public static final class MetricTypeBuilder
    extends Path.MetricTypeBuilder<CanonicalPath> {
        private MetricTypeBuilder(List<Path.Segment> segments) {
            super(segments, CanonicalPath::new);
        }
    }

    public static final class ResourceTypeBuilder
    extends Path.ResourceTypeBuilder<CanonicalPath, OperationTypeBuilder, StructuredDataBuilder> {
        private ResourceTypeBuilder(List<Path.Segment> list) {
            super(list, CanonicalPath::new);
        }

        @Override
        protected OperationTypeBuilder operationTypeBuilder(List<Path.Segment> segments) {
            return new OperationTypeBuilder((List)segments);
        }

        @Override
        protected StructuredDataBuilder structuredDataBuilder(List<Path.Segment> segments) {
            return new StructuredDataBuilder((List)segments);
        }
    }

    public static final class EnvironmentBuilder
    extends Path.EnvironmentBuilder<CanonicalPath, ResourceBuilder, MetricBuilder, ResourceTypeBuilder, MetricTypeBuilder, OperationTypeBuilder, StructuredDataBuilder> {
        private EnvironmentBuilder(List<Path.Segment> list) {
            super(list, CanonicalPath::new);
        }

        @Override
        protected ResourceBuilder resourceBuilder(List<Path.Segment> segments) {
            return new ResourceBuilder((List)segments);
        }

        @Override
        protected MetricBuilder metricBuilder(List<Path.Segment> segments) {
            return new MetricBuilder((List)segments);
        }
    }

    public static final class MetadataPackBuilder
    extends Path.MetadataPackBuilder<CanonicalPath> {
        private MetadataPackBuilder(List<Path.Segment> segments) {
            super(segments, CanonicalPath::new);
        }
    }

    public static final class TenantBuilder
    extends Path.TenantBuilder<CanonicalPath, EnvironmentBuilder, ResourceTypeBuilder, MetricTypeBuilder, OperationTypeBuilder, StructuredDataBuilder, MetadataPackBuilder, FeedBuilder, ResourceBuilder, MetricBuilder> {
        private TenantBuilder(List<Path.Segment> list) {
            super(list, CanonicalPath::new);
        }

        @Override
        protected EnvironmentBuilder environmentBuilder(List<Path.Segment> list) {
            return new EnvironmentBuilder((List)list);
        }

        @Override
        protected FeedBuilder feedBuilder(List<Path.Segment> segments) {
            return new FeedBuilder((List)segments);
        }

        @Override
        protected ResourceTypeBuilder resourceTypeBuilder(List<Path.Segment> list) {
            return new ResourceTypeBuilder((List)list);
        }

        @Override
        protected MetricTypeBuilder metricTypeBuilder(List<Path.Segment> list) {
            return new MetricTypeBuilder((List)list);
        }

        @Override
        protected MetadataPackBuilder metadataPackBuilder(List<Path.Segment> segments) {
            return new MetadataPackBuilder((List)segments);
        }
    }

    public static final class Builder
    extends Path.Builder<CanonicalPath, TenantBuilder, EnvironmentBuilder, ResourceTypeBuilder, MetricTypeBuilder, RelationshipBuilder, OperationTypeBuilder, StructuredDataBuilder, MetadataPackBuilder, FeedBuilder, ResourceBuilder, MetricBuilder> {
        private Builder(List<Path.Segment> list) {
            super(list, CanonicalPath::new);
        }

        @Override
        protected RelationshipBuilder relationshipBuilder(List<Path.Segment> list) {
            return new RelationshipBuilder((List)list);
        }

        @Override
        protected TenantBuilder tenantBuilder(List<Path.Segment> list) {
            return new TenantBuilder((List)list);
        }
    }
}

