/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux.proc;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import oshi.software.os.OSFileStore;

public class LinuxFileSystem {
    public static OSFileStore[] getFileStores() {
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        for (FileStore store : FileSystems.getDefault().getFileStores()) {
            String path = store.toString().replace(" (" + store.name() + ")", "");
            if (path.startsWith("/proc") || path.startsWith("/sys") || path.startsWith("/run") || path.equals("/dev") || path.equals("/dev/pts")) continue;
            String name = store.name();
            if (path.equals("/")) {
                name = "/";
            }
            String description = "Mount Point";
            if (store.name().startsWith("/dev")) {
                description = "Local Disk";
            }
            try {
                fsList.add(new OSFileStore(name, description, store.getUsableSpace(), store.getTotalSpace()));
            }
            catch (IOException e) {}
        }
        return fsList.toArray(new OSFileStore[fsList.size()]);
    }
}

