/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.Memory;
import oshi.hardware.PowerSource;
import oshi.hardware.Processor;
import oshi.software.os.OSFileStore;
import oshi.software.os.mac.local.CentralProcessor;
import oshi.software.os.mac.local.GlobalMemory;
import oshi.software.os.mac.local.MacFileSystem;
import oshi.software.os.mac.local.MacPowerSource;
import oshi.software.os.mac.local.SystemB;

public class MacHardwareAbstractionLayer
implements HardwareAbstractionLayer {
    private static final Logger LOG = LoggerFactory.getLogger(MacHardwareAbstractionLayer.class);
    private Processor[] _processors;
    private Memory _memory;
    private PowerSource[] _powerSources;

    @Override
    public Processor[] getProcessors() {
        if (this._processors == null) {
            int nbCPU = 1;
            ArrayList<CentralProcessor> processors = new ArrayList<CentralProcessor>();
            com.sun.jna.Memory pNbCPU = new com.sun.jna.Memory((long)SystemB.INT_SIZE);
            if (0 != SystemB.INSTANCE.sysctlbyname("hw.logicalcpu", (Pointer)pNbCPU, new IntByReference(SystemB.INT_SIZE), null, 0)) {
                LOG.error("Failed to get number of CPUs. Error code: " + Native.getLastError());
                nbCPU = 1;
            } else {
                nbCPU = pNbCPU.getInt(0L);
            }
            for (int i = 0; i < nbCPU; ++i) {
                processors.add(new CentralProcessor(i));
            }
            this._processors = processors.toArray(new Processor[0]);
        }
        return this._processors;
    }

    @Override
    public Memory getMemory() {
        if (this._memory == null) {
            this._memory = new GlobalMemory();
        }
        return this._memory;
    }

    @Override
    public PowerSource[] getPowerSources() {
        if (this._powerSources == null) {
            this._powerSources = MacPowerSource.getPowerSources();
        }
        return this._powerSources;
    }

    @Override
    public OSFileStore[] getFileStores() {
        return MacFileSystem.getFileStores();
    }
}

