/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac.local;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.software.os.OperatingSystemVersion;
import oshi.software.os.mac.local.SystemB;

public class OSVersionInfoEx
implements OperatingSystemVersion {
    private static final Logger LOG = LoggerFactory.getLogger(OSVersionInfoEx.class);
    private String _version = null;
    private String _codeName = null;
    private String _versionStr = null;
    private String _buildNumber = null;

    public String getVersion() {
        if (this._version == null) {
            this._version = System.getProperty("os.version");
        }
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public String getCodeName() {
        if (this._codeName == null && this.getVersion() != null) {
            String[] versionSplit = this.getVersion().split("\\.");
            if (versionSplit.length > 1 && versionSplit[0].equals("10")) {
                switch (Integer.parseInt(versionSplit[1])) {
                    case 0: {
                        this._codeName = "Cheetah";
                        break;
                    }
                    case 1: {
                        this._codeName = "Puma";
                        break;
                    }
                    case 2: {
                        this._codeName = "Jaguar";
                        break;
                    }
                    case 3: {
                        this._codeName = "Panther";
                        break;
                    }
                    case 4: {
                        this._codeName = "Tiger";
                        break;
                    }
                    case 5: {
                        this._codeName = "Leopard";
                        break;
                    }
                    case 6: {
                        this._codeName = "Snow Leopard";
                        break;
                    }
                    case 7: {
                        this._codeName = "Lion";
                        break;
                    }
                    case 8: {
                        this._codeName = "Mountain Lion";
                        break;
                    }
                    case 9: {
                        this._codeName = "Mavericks";
                        break;
                    }
                    case 10: {
                        this._codeName = "Yosemite";
                        break;
                    }
                    case 11: {
                        this._codeName = "El Capitan";
                        break;
                    }
                    default: {
                        this._codeName = "";
                        break;
                    }
                }
            } else {
                this._codeName = "";
            }
        }
        return this._codeName;
    }

    public void setCodeName(String codeName) {
        this._codeName = codeName;
    }

    public String getBuildNumber() {
        if (this._buildNumber == null) {
            IntByReference size = new IntByReference();
            if (0 != SystemB.INSTANCE.sysctlbyname("kern.osversion", null, size, null, 0)) {
                LOG.error("Failed to get OS Version. Error code: " + Native.getLastError());
                return "";
            }
            Memory p = new Memory((long)(size.getValue() + 1));
            if (0 != SystemB.INSTANCE.sysctlbyname("kern.osversion", (Pointer)p, size, null, 0)) {
                LOG.error("Failed to get OS Version. Error code: " + Native.getLastError());
                return "";
            }
            this._buildNumber = p.getString(0L);
        }
        return this._buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this._buildNumber = buildNumber;
    }

    public String toString() {
        if (this._versionStr == null) {
            StringBuilder sb = new StringBuilder(this.getVersion());
            if (this.getCodeName().length() > 0) {
                sb.append(" (").append(this.getCodeName()).append(")");
            }
            sb.append(" build ").append(this.getBuildNumber());
            this._versionStr = sb.toString();
        }
        return this._versionStr;
    }
}

