/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common.consumer;

import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.hawkular.bus.common.consumer.ConsumerConnectionContext;
import org.hawkular.bus.common.log.MsgLogger;
import org.jboss.logging.Logger;

public class FutureBasicMessageListener<T extends BasicMessage>
extends BasicMessageListener<T>
implements ListenableFuture<BasicMessageWithExtraData<T>> {
    private final MsgLogger msglog = MsgLogger.LOGGER;
    private final BlockingQueue<BasicMessageWithExtraData<T>> responseQ = new ArrayBlockingQueue<BasicMessageWithExtraData<T>>(1);
    private BasicMessageWithExtraData<T> responseMessage = null;
    private State state = State.WAITING;
    private final ExecutionList executionList = new ExecutionList();

    public FutureBasicMessageListener() {
    }

    public FutureBasicMessageListener(Class<T> jsonDecoderRing) {
        super(jsonDecoderRing);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        try {
            if (mayInterruptIfRunning) {
                this.closeConsumer();
                this.state = State.CANCELLED;
            } else {
                this.msglog.errorCannotCancelRunningFuture();
            }
        }
        catch (Exception e) {
            this.msglog.errorConsumerCloseFailureOnFutureCancel();
        }
        this.executionList.execute();
        return this.state == State.CANCELLED;
    }

    public boolean isCancelled() {
        return this.state == State.CANCELLED;
    }

    public boolean isDone() {
        return this.state == State.DONE || this.state == State.CANCELLED;
    }

    public BasicMessageWithExtraData<T> get() throws InterruptedException, ExecutionException {
        if (this.state == State.CANCELLED) {
            throw new CancellationException();
        }
        if (this.responseMessage == null) {
            this.responseMessage = this.responseQ.take();
            this.state = State.DONE;
        }
        return this.responseMessage;
    }

    public BasicMessageWithExtraData<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.state == State.CANCELLED) {
            throw new CancellationException();
        }
        if (this.responseMessage == null) {
            BasicMessageWithExtraData<T> item = this.responseQ.poll(timeout, unit);
            if (item == null) {
                throw new TimeoutException();
            }
            this.responseMessage = item;
            this.state = State.DONE;
        }
        return this.responseMessage;
    }

    public void addListener(Runnable listener, Executor exec) {
        this.executionList.add(listener, exec);
    }

    @Override
    protected void onBasicMessage(BasicMessageWithExtraData<T> msgWithData) {
        if (!this.isDone()) {
            this.state = State.DONE;
            if (this.responseQ.offer(msgWithData)) {
                this.executionList.execute();
            } else {
                this.msglog.errorCannotStoreIncomingMessageFutureInvalid();
                this.state = State.CANCELLED;
            }
            try {
                this.closeConsumer();
            }
            catch (Exception e) {
                this.msglog.errorFailedToCloseFutureConsumer(e);
            }
        }
    }

    protected void closeConsumer() throws IOException {
        ConsumerConnectionContext cc = this.getConsumerConnectionContext();
        if (cc != null) {
            Logger.getLogger(this.getClass()).debugf("Future listener closing consumer on destination [%s]", (Object)cc.getDestination());
            cc.close();
        }
    }

    public String toString() {
        return super.toString() + ": STATE=" + (Object)((Object)this.state);
    }

    private static enum State {
        WAITING,
        DONE,
        CANCELLED;

    }
}

