/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.dmrclient;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.hawkular.dmrclient.Address;
import org.hawkular.dmrclient.FailureException;
import org.hawkular.dmrclient.JBossASClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlanResult;
import org.jboss.as.controller.client.helpers.domain.DomainDeploymentManager;
import org.jboss.as.controller.client.helpers.domain.impl.DomainClientImpl;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.controller.client.helpers.standalone.impl.ModelControllerClientServerDeploymentManager;
import org.jboss.dmr.ModelNode;

public class DeploymentJBossASClient
extends JBossASClient {
    public static final String SUBSYSTEM_DEPLOYMENT = "deployment";
    public static final String ENABLED = "enabled";
    public static final String CONTENT = "content";
    public static final String PATH = "path";

    public DeploymentJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public boolean isDeployment(String name) throws Exception {
        Address addr = Address.root().add(SUBSYSTEM_DEPLOYMENT, name);
        return null != this.readResource(addr);
    }

    public boolean isDeploymentEnabled(String name) throws Exception {
        Address addr = Address.root().add(SUBSYSTEM_DEPLOYMENT, name);
        ModelNode results = this.readResource(addr);
        if (results == null) {
            throw new IllegalArgumentException("There is no deployment with the name: " + name);
        }
        boolean enabledFlag = false;
        if (results.hasDefined(ENABLED)) {
            ModelNode enabled = results.get(ENABLED);
            enabledFlag = enabled.asBoolean(false);
        }
        return enabledFlag;
    }

    public void enableDeployment(String name) throws Exception {
        this.enableDisableDeployment(name, true);
    }

    public void disableDeployment(String name) throws Exception {
        this.enableDisableDeployment(name, false);
    }

    private void enableDisableDeployment(String name, boolean enable) throws Exception {
        if (this.isDeploymentEnabled(name) == enable) {
            return;
        }
        Address addr = Address.root().add(SUBSYSTEM_DEPLOYMENT, name);
        ModelNode request = DeploymentJBossASClient.createWriteAttributeRequest(ENABLED, Boolean.toString(enable), addr);
        ModelNode results = this.execute(request);
        if (!DeploymentJBossASClient.isSuccess(results)) {
            throw new FailureException(results);
        }
    }

    public String getDeploymentPath(String name) throws Exception {
        Address addr = Address.root().add(SUBSYSTEM_DEPLOYMENT, name);
        ModelNode op = DeploymentJBossASClient.createReadAttributeRequest(CONTENT, addr);
        ModelNode results = this.execute(op);
        if (DeploymentJBossASClient.isSuccess(results)) {
            ModelNode path;
            try {
                path = ((ModelNode)DeploymentJBossASClient.getResults(results).asList().get(0)).asObject().get(PATH);
            }
            catch (Exception e) {
                throw new Exception("Cannot get path associated with deployment [" + name + "]");
            }
            if (path != null) {
                return path.asString();
            }
            throw new Exception("No path associated with deployment [" + name + "]");
        }
        throw new FailureException(results, "Cannot get the deployment path");
    }

    public void deployStandalone(String deploymentName, InputStream content, boolean enabled) {
        ServerDeploymentPlanResult results;
        ModelControllerClientServerDeploymentManager deployMgr = new ModelControllerClientServerDeploymentManager(this.getModelControllerClient(), false);
        DeploymentPlan plan = enabled ? deployMgr.newDeploymentPlan().add(deploymentName, content).andDeploy().build() : deployMgr.newDeploymentPlan().add(deploymentName, content).build();
        Future future = deployMgr.execute(plan);
        try {
            results = (ServerDeploymentPlanResult)future.get();
        }
        catch (Exception e) {
            throw new FailureException("Failed to execute standalone deployment plan for [" + deploymentName + "]", (Throwable)e);
        }
        boolean success = true;
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        List actions = plan.getDeploymentActions();
        for (DeploymentAction action : actions) {
            ServerDeploymentActionResult result = results.getDeploymentActionResult(action.getId());
            switch (result.getResult()) {
                case EXECUTED: 
                case CONFIGURATION_MODIFIED_REQUIRES_RESTART: {
                    success &= true;
                    break;
                }
                case FAILED: 
                case NOT_EXECUTED: 
                case ROLLED_BACK: {
                    success = false;
                    Throwable error = result.getDeploymentException();
                    if (error == null) break;
                    exceptions.add(error);
                    break;
                }
            }
        }
        if (!success) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append("Failed to deploy [").append(deploymentName).append("]");
            int errorNumber = 1;
            for (Throwable exception : exceptions) {
                errorMsg.append('\n').append(errorNumber++).append(": ").append(exception);
            }
            throw new FailureException(errorMsg.toString());
        }
    }

    public void deployDomain(String deploymentName, InputStream content, boolean enabled) {
        org.jboss.as.controller.client.helpers.domain.DeploymentPlan plan;
        DomainClientImpl domainClient = new DomainClientImpl(this.getModelControllerClient());
        DomainDeploymentManager deployMgr = domainClient.getDeploymentManager();
        try {
            plan = enabled ? deployMgr.newDeploymentPlan().add(deploymentName, content).andDeploy().build() : deployMgr.newDeploymentPlan().add(deploymentName, content).build();
        }
        catch (Exception e) {
            throw new FailureException("Cannot build domain deployment plan for [" + deploymentName + "]", (Throwable)e);
        }
        Future future = deployMgr.execute(plan);
        try {
            DeploymentPlanResult results = (DeploymentPlanResult)future.get();
        }
        catch (Exception e) {
            throw new FailureException("Failed to execute domain deployment plan for [" + deploymentName + "]", (Throwable)e);
        }
    }
}

