/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.Memory;
import oshi.hardware.PowerSource;
import oshi.hardware.Processor;
import oshi.software.os.OSFileStore;
import oshi.software.os.linux.proc.CentralProcessor;
import oshi.software.os.linux.proc.GlobalMemory;
import oshi.software.os.linux.proc.LinuxFileSystem;
import oshi.software.os.linux.proc.LinuxPowerSource;
import oshi.util.FileUtil;

public class LinuxHardwareAbstractionLayer
implements HardwareAbstractionLayer {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxHardwareAbstractionLayer.class);
    private static final String SEPARATOR = "\\s+:\\s";
    private Processor[] _processors = null;
    private Memory _memory = null;

    @Override
    public Memory getMemory() {
        if (this._memory == null) {
            this._memory = new GlobalMemory();
        }
        return this._memory;
    }

    @Override
    public Processor[] getProcessors() {
        if (this._processors == null) {
            ArrayList<CentralProcessor> processors = new ArrayList<CentralProcessor>();
            List<String> cpuInfo = null;
            try {
                cpuInfo = FileUtil.readFile("/proc/cpuinfo");
            }
            catch (IOException e) {
                LOG.error("Problem with /proc/cpuinfo: {}", (Object)e.getMessage());
                return null;
            }
            CentralProcessor cpu = null;
            int numCPU = 0;
            for (String toBeAnalyzed : cpuInfo) {
                if (toBeAnalyzed.equals("")) {
                    if (cpu != null) {
                        processors.add(cpu);
                    }
                    cpu = null;
                    continue;
                }
                if (cpu == null) {
                    cpu = new CentralProcessor(numCPU++);
                }
                if (toBeAnalyzed.startsWith("model name\t")) {
                    cpu.setName(toBeAnalyzed.split(SEPARATOR)[1]);
                    continue;
                }
                if (toBeAnalyzed.startsWith("flags\t")) {
                    String[] flags = toBeAnalyzed.split(SEPARATOR)[1].split(" ");
                    boolean found = false;
                    for (String flag : flags) {
                        if (!flag.equalsIgnoreCase("LM")) continue;
                        found = true;
                        break;
                    }
                    cpu.setCpu64(found);
                    continue;
                }
                if (toBeAnalyzed.startsWith("cpu family\t")) {
                    cpu.setFamily(toBeAnalyzed.split(SEPARATOR)[1]);
                    continue;
                }
                if (toBeAnalyzed.startsWith("model\t")) {
                    cpu.setModel(toBeAnalyzed.split(SEPARATOR)[1]);
                    continue;
                }
                if (toBeAnalyzed.startsWith("stepping\t")) {
                    cpu.setStepping(toBeAnalyzed.split(SEPARATOR)[1]);
                    continue;
                }
                if (!toBeAnalyzed.startsWith("vendor_id")) continue;
                cpu.setVendor(toBeAnalyzed.split(SEPARATOR)[1]);
            }
            if (cpu != null) {
                processors.add(cpu);
            }
            this._processors = processors.toArray(new Processor[0]);
        }
        return this._processors;
    }

    @Override
    public PowerSource[] getPowerSources() {
        return LinuxPowerSource.getPowerSources();
    }

    @Override
    public OSFileStore[] getFileStores() {
        return LinuxFileSystem.getFileStores();
    }
}

