/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac.local;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Processor;
import oshi.software.os.mac.local.SystemB;
import oshi.util.FormatUtil;
import oshi.util.ParseUtil;

public class CentralProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(CentralProcessor.class);
    private static final java.lang.management.OperatingSystemMXBean OS_MXBEAN = ManagementFactory.getOperatingSystemMXBean();
    private static boolean sunMXBean;
    private static long tickTime;
    private static long[] prevTicks;
    private static long[] curTicks;
    private long procTickTime = System.currentTimeMillis();
    private long[] prevProcTicks = new long[4];
    private long[] curProcTicks = new long[4];
    private static int numCPU;
    private static long[][] allProcessorTicks;
    private static long allProcTickTime;
    private int processorNumber;
    private String cpuVendor;
    private String cpuName;
    private String cpuIdentifier = null;
    private String cpuStepping;
    private String cpuModel;
    private String cpuFamily;
    private Long cpuVendorFreq = null;
    private Boolean cpu64;

    public CentralProcessor(int procNo) {
        if (procNo >= numCPU) {
            throw new IllegalArgumentException("Processor number (" + procNo + ") must be less than the number of CPUs: " + numCPU);
        }
        this.processorNumber = procNo;
        CentralProcessor.updateProcessorTicks();
        System.arraycopy(allProcessorTicks[this.processorNumber], 0, this.curProcTicks, 0, this.curProcTicks.length);
        LOG.debug("Initialized Processor {}", (Object)procNo);
    }

    @Override
    public int getProcessorNumber() {
        return this.processorNumber;
    }

    @Override
    public String getVendor() {
        if (this.cpuVendor == null) {
            IntByReference size = new IntByReference();
            if (0 != SystemB.INSTANCE.sysctlbyname("machdep.cpu.vendor", null, size, null, 0)) {
                LOG.error("Failed to get Vendor. Error code: " + Native.getLastError());
                return "";
            }
            Memory p = new Memory((long)(size.getValue() + 1));
            if (0 != SystemB.INSTANCE.sysctlbyname("machdep.cpu.vendor", (Pointer)p, size, null, 0)) {
                LOG.error("Failed to get Vendor. Error code: " + Native.getLastError());
                return "";
            }
            this.cpuVendor = p.getString(0L);
        }
        return this.cpuVendor;
    }

    @Override
    public void setVendor(String vendor) {
        this.cpuVendor = vendor;
    }

    @Override
    public String getName() {
        if (this.cpuName == null) {
            IntByReference size = new IntByReference();
            if (0 != SystemB.INSTANCE.sysctlbyname("machdep.cpu.brand_string", null, size, null, 0)) {
                LOG.error("Failed to get Name. Error code: " + Native.getLastError());
                return "";
            }
            Memory p = new Memory((long)(size.getValue() + 1));
            if (0 != SystemB.INSTANCE.sysctlbyname("machdep.cpu.brand_string", (Pointer)p, size, null, 0)) {
                LOG.error("Failed to get Name. Error code: " + Native.getLastError());
                return "";
            }
            this.cpuName = p.getString(0L);
        }
        return this.cpuName;
    }

    @Override
    public void setName(String name) {
        this.cpuName = name;
    }

    @Override
    public long getVendorFreq() {
        if (this.cpuVendorFreq == null) {
            Pattern pattern = Pattern.compile("@ (.*)$");
            Matcher matcher = pattern.matcher(this.getName());
            if (matcher.find()) {
                String unit = matcher.group(1);
                this.cpuVendorFreq = ParseUtil.parseHertz(unit);
            } else {
                this.cpuVendorFreq = -1L;
            }
        }
        return this.cpuVendorFreq;
    }

    @Override
    public void setVendorFreq(long freq) {
        this.cpuVendorFreq = freq;
    }

    @Override
    public String getIdentifier() {
        if (this.cpuIdentifier == null) {
            StringBuilder sb = new StringBuilder();
            if (this.getVendor().contentEquals("GenuineIntel")) {
                sb.append(this.isCpu64bit() ? "Intel64" : "x86");
            } else {
                sb.append(this.getVendor());
            }
            sb.append(" Family ").append(this.getFamily());
            sb.append(" Model ").append(this.getModel());
            sb.append(" Stepping ").append(this.getStepping());
            this.cpuIdentifier = sb.toString();
        }
        return this.cpuIdentifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.cpuIdentifier = identifier;
    }

    @Override
    public boolean isCpu64bit() {
        if (this.cpu64 == null) {
            IntByReference size = new IntByReference(SystemB.INT_SIZE);
            Memory p = new Memory((long)size.getValue());
            if (0 != SystemB.INSTANCE.sysctlbyname("hw.cpu64bit_capable", (Pointer)p, size, null, 0)) {
                LOG.error("Failed to get 64Bit_capable. Error code: " + Native.getLastError());
                return false;
            }
            this.cpu64 = p.getInt(0L) != 0;
        }
        return this.cpu64;
    }

    @Override
    public void setCpu64(boolean cpu64) {
        this.cpu64 = cpu64;
    }

    @Override
    public String getStepping() {
        if (this.cpuStepping == null) {
            IntByReference size = new IntByReference(SystemB.INT_SIZE);
            Memory p = new Memory((long)size.getValue());
            if (0 != SystemB.INSTANCE.sysctlbyname("machdep.cpu.stepping", (Pointer)p, size, null, 0)) {
                LOG.error("Failed to get Stepping. Error code: " + Native.getLastError());
                return "";
            }
            this.cpuStepping = Integer.toString(p.getInt(0L));
        }
        return this.cpuStepping;
    }

    @Override
    public void setStepping(String stepping) {
        this.cpuStepping = stepping;
    }

    @Override
    public String getModel() {
        if (this.cpuModel == null) {
            IntByReference size = new IntByReference(SystemB.INT_SIZE);
            Memory p = new Memory((long)size.getValue());
            if (0 != SystemB.INSTANCE.sysctlbyname("machdep.cpu.model", (Pointer)p, size, null, 0)) {
                LOG.error("Failed to get Model. Error code: " + Native.getLastError());
                return "";
            }
            this.cpuModel = Integer.toString(p.getInt(0L));
        }
        return this.cpuModel;
    }

    @Override
    public void setModel(String model) {
        this.cpuModel = model;
    }

    @Override
    public String getFamily() {
        if (this.cpuFamily == null) {
            IntByReference size = new IntByReference(SystemB.INT_SIZE);
            Memory p = new Memory((long)size.getValue());
            if (0 != SystemB.INSTANCE.sysctlbyname("machdep.cpu.family", (Pointer)p, size, null, 0)) {
                LOG.error("Failed to get Family. Error code: " + Native.getLastError());
                return "";
            }
            this.cpuFamily = Integer.toString(p.getInt(0L));
        }
        return this.cpuFamily;
    }

    @Override
    public void setFamily(String family) {
        this.cpuFamily = family;
    }

    @Override
    @Deprecated
    public float getLoad() {
        return (float)this.getSystemCpuLoadBetweenTicks() * 100.0f;
    }

    @Override
    public synchronized double getSystemCpuLoadBetweenTicks() {
        boolean update;
        long now = System.currentTimeMillis();
        LOG.trace("Current time: {}  Last tick time: {}", (Object)now, (Object)tickTime);
        boolean bl = update = now - tickTime > 950L;
        if (update) {
            CentralProcessor.updateSystemTicks();
            tickTime = now;
        }
        long total = 0L;
        for (int i = 0; i < curTicks.length; ++i) {
            total += curTicks[i] - prevTicks[i];
        }
        long idle = curTicks[3] - prevTicks[3];
        LOG.trace("Total ticks: {}  Idle ticks: {}", (Object)total, (Object)idle);
        if (update) {
            System.arraycopy(curTicks, 0, prevTicks, 0, curTicks.length);
        }
        if (total > 0L && idle >= 0L) {
            return (double)(total - idle) / (double)total;
        }
        return 0.0;
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        CentralProcessor.updateSystemTicks();
        long[] ticks = new long[curTicks.length];
        System.arraycopy(curTicks, 0, ticks, 0, curTicks.length);
        return ticks;
    }

    private static void updateSystemTicks() {
        LOG.trace("Updating System Ticks");
        int machPort = SystemB.INSTANCE.mach_host_self();
        SystemB.HostCpuLoadInfo cpuLoadInfo = new SystemB.HostCpuLoadInfo();
        if (0 != SystemB.INSTANCE.host_statistics(machPort, 3, (Object)cpuLoadInfo, new IntByReference(cpuLoadInfo.size()))) {
            LOG.error("Failed to get System CPU ticks. Error code: " + Native.getLastError());
            return;
        }
        CentralProcessor.curTicks[0] = cpuLoadInfo.cpu_ticks[0];
        CentralProcessor.curTicks[1] = cpuLoadInfo.cpu_ticks[3];
        CentralProcessor.curTicks[2] = cpuLoadInfo.cpu_ticks[1];
        CentralProcessor.curTicks[3] = cpuLoadInfo.cpu_ticks[2];
    }

    @Override
    public double getSystemCpuLoad() {
        if (sunMXBean) {
            return ((OperatingSystemMXBean)OS_MXBEAN).getSystemCpuLoad();
        }
        return this.getSystemCpuLoadBetweenTicks();
    }

    @Override
    public double getSystemLoadAverage() {
        return OS_MXBEAN.getSystemLoadAverage();
    }

    @Override
    public double getProcessorCpuLoadBetweenTicks() {
        long now = System.currentTimeMillis();
        LOG.trace("Current time: {}  Last processor tick time: {}", (Object)now, (Object)this.procTickTime);
        if (now - this.procTickTime > 950L) {
            CentralProcessor.updateProcessorTicks();
            System.arraycopy(this.curProcTicks, 0, this.prevProcTicks, 0, this.curProcTicks.length);
            System.arraycopy(allProcessorTicks[this.processorNumber], 0, this.curProcTicks, 0, this.curProcTicks.length);
            this.procTickTime = now;
        }
        long total = 0L;
        for (int i = 0; i < this.curProcTicks.length; ++i) {
            total += this.curProcTicks[i] - this.prevProcTicks[i];
        }
        long idle = this.curProcTicks[3] - this.prevProcTicks[3];
        LOG.trace("Total ticks: {}  Idle ticks: {}", (Object)total, (Object)idle);
        return total > 0L && idle >= 0L ? (double)(total - idle) / (double)total : 0.0;
    }

    @Override
    public long[] getProcessorCpuLoadTicks() {
        CentralProcessor.updateProcessorTicks();
        return allProcessorTicks[this.processorNumber];
    }

    private static void updateProcessorTicks() {
        IntByReference procInfoCount;
        PointerByReference procCpuLoadInfo;
        IntByReference procCount;
        long now = System.currentTimeMillis();
        LOG.trace("Current time: {}  Last all processor tick time: {}", (Object)now, (Object)allProcTickTime);
        if (now - allProcTickTime < 100L) {
            return;
        }
        int machPort = SystemB.INSTANCE.mach_host_self();
        if (0 != SystemB.INSTANCE.host_processor_info(machPort, 2, procCount = new IntByReference(), procCpuLoadInfo = new PointerByReference(), procInfoCount = new IntByReference())) {
            LOG.error("Failed to update CPU Load. Error code: " + Native.getLastError());
            return;
        }
        int[] cpuTicks = procCpuLoadInfo.getValue().getIntArray(0L, procInfoCount.getValue());
        for (int cpu = 0; cpu < procCount.getValue(); ++cpu) {
            for (int j = 0; j < 4; ++j) {
                int offset = cpu * 4;
                CentralProcessor.allProcessorTicks[cpu][0] = FormatUtil.getUnsignedInt(cpuTicks[offset + 0]);
                CentralProcessor.allProcessorTicks[cpu][1] = FormatUtil.getUnsignedInt(cpuTicks[offset + 3]);
                CentralProcessor.allProcessorTicks[cpu][2] = FormatUtil.getUnsignedInt(cpuTicks[offset + 1]);
                CentralProcessor.allProcessorTicks[cpu][3] = FormatUtil.getUnsignedInt(cpuTicks[offset + 2]);
            }
        }
        allProcTickTime = now;
    }

    @Override
    public long getSystemUptime() {
        IntByReference size = new IntByReference();
        if (0 != SystemB.INSTANCE.sysctlbyname("kern.boottime", null, size, null, 0)) {
            LOG.error("Failed to get Boot Time. Error code: " + Native.getLastError());
            return 0L;
        }
        if (size.getValue() != 16) {
            throw new UnsupportedOperationException("sysctl kern.boottime should be 16 bytes but isn't.");
        }
        Memory p = new Memory((long)(size.getValue() + 1));
        if (0 != SystemB.INSTANCE.sysctlbyname("kern.boottime", (Pointer)p, size, null, 0)) {
            LOG.error("Failed to get Boot Time. Error code: " + Native.getLastError());
            return 0L;
        }
        return System.currentTimeMillis() / 1000L - p.getLong(0L);
    }

    public String toString() {
        return this.getName();
    }

    static {
        try {
            Class.forName("com.sun.management.OperatingSystemMXBean");
            ((OperatingSystemMXBean)OS_MXBEAN).getSystemCpuLoad();
            sunMXBean = true;
            LOG.debug("Oracle MXBean detected.");
        }
        catch (ClassNotFoundException e) {
            sunMXBean = false;
            LOG.debug("Oracle MXBean not detected.");
        }
        tickTime = System.currentTimeMillis();
        prevTicks = new long[4];
        curTicks = new long[4];
        CentralProcessor.updateSystemTicks();
        System.arraycopy(curTicks, 0, prevTicks, 0, curTicks.length);
        numCPU = 0;
        IntByReference size = new IntByReference(SystemB.INT_SIZE);
        Memory p = new Memory((long)size.getValue());
        if (0 != SystemB.INSTANCE.sysctlbyname("hw.logicalcpu", (Pointer)p, size, null, 0)) {
            LOG.error("Failed to get number of CPUs. Error code: " + Native.getLastError());
            numCPU = 1;
        } else {
            numCPU = p.getInt(0L);
        }
        allProcessorTicks = new long[numCPU][4];
        allProcTickTime = 0L;
    }
}

