/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac.local;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Memory;
import oshi.software.os.mac.local.SystemB;

public class GlobalMemory
implements Memory {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalMemory.class);
    long totalMemory = 0L;

    @Override
    public long getAvailable() {
        LongByReference pPageSize;
        long availableMemory = 0L;
        long pageSize = 4096L;
        int machPort = SystemB.INSTANCE.mach_host_self();
        if (0 != SystemB.INSTANCE.host_page_size(machPort, pPageSize = new LongByReference())) {
            LOG.error("Failed to get host page size. Error code: " + Native.getLastError());
            return 0L;
        }
        pageSize = pPageSize.getValue();
        SystemB.VMStatistics vmStats = new SystemB.VMStatistics();
        if (0 != SystemB.INSTANCE.host_statistics(machPort, 2, (Object)vmStats, new IntByReference(vmStats.size() / SystemB.INT_SIZE))) {
            LOG.error("Failed to get host VM info. Error code: " + Native.getLastError());
            return 0L;
        }
        availableMemory = (long)(vmStats.free_count + vmStats.inactive_count) * pageSize;
        return availableMemory;
    }

    @Override
    public long getTotal() {
        if (this.totalMemory == 0L) {
            com.sun.jna.Memory pMemSize = new com.sun.jna.Memory((long)SystemB.UINT64_SIZE);
            if (0 != SystemB.INSTANCE.sysctlbyname("hw.memsize", (Pointer)pMemSize, new IntByReference(SystemB.UINT64_SIZE), null, 0)) {
                LOG.error("Failed to get memory size. Error code: " + Native.getLastError());
                return 0L;
            }
            this.totalMemory = pMemSize.getLong(0L);
        }
        return this.totalMemory;
    }
}

