/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows.nt;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Processor;
import oshi.software.os.windows.nt.Kernel32;
import oshi.software.os.windows.nt.Pdh;
import oshi.util.ParseUtil;

public class CentralProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(CentralProcessor.class);
    private static final java.lang.management.OperatingSystemMXBean OS_MXBEAN = ManagementFactory.getOperatingSystemMXBean();
    private static boolean sunMXBean;
    private static long tickTime;
    private static long[] prevTicks;
    private static long[] curTicks;
    private long procTickTime = System.currentTimeMillis();
    private long[] prevProcTicks = new long[4];
    private long[] curProcTicks = new long[4];
    private static PointerByReference phQuery;
    private static final IntByReference zero;
    private static final int numCPU;
    private static PointerByReference uptimeQuery;
    private static final IntByReference one;
    private static int pdhOpenTickQueryError;
    private static int pdhAddTickCounterError;
    private static int pdhOpenUptimeQueryError;
    private static int pdhAddUptimeCounterError;
    private static PointerByReference[] phUserCounters;
    private static PointerByReference[] phIdleCounters;
    private static PointerByReference pUptime;
    private static long[][] allProcessorTicks;
    private static long allProcTickTime;
    private int processorNumber;
    private String cpuVendor;
    private String cpuName;
    private String cpuIdentifier;
    private Long cpuVendorFreq;

    public CentralProcessor(int procNo) {
        if (procNo >= numCPU) {
            throw new IllegalArgumentException("Processor number (" + procNo + ") must be less than the number of CPUs: " + numCPU);
        }
        this.processorNumber = procNo;
        this.updateProcessorTicks();
        System.arraycopy(allProcessorTicks[this.processorNumber], 0, this.curProcTicks, 0, this.curProcTicks.length);
        LOG.debug("Initialized Processor {}", (Object)procNo);
    }

    @Override
    public int getProcessorNumber() {
        return this.processorNumber;
    }

    @Override
    public String getVendor() {
        return this.cpuVendor;
    }

    @Override
    public void setVendor(String vendor) {
        this.cpuVendor = vendor;
    }

    @Override
    public String getName() {
        return this.cpuName;
    }

    @Override
    public void setName(String name) {
        this.cpuName = name;
    }

    @Override
    public long getVendorFreq() {
        if (this.cpuVendorFreq == null) {
            Pattern pattern = Pattern.compile("@ (.*)$");
            Matcher matcher = pattern.matcher(this.getName());
            if (matcher.find()) {
                String unit = matcher.group(1);
                this.cpuVendorFreq = ParseUtil.parseHertz(unit);
            } else {
                this.cpuVendorFreq = -1L;
            }
        }
        return this.cpuVendorFreq;
    }

    @Override
    public void setVendorFreq(long freq) {
        this.cpuVendorFreq = freq;
    }

    @Override
    public String getIdentifier() {
        return this.cpuIdentifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.cpuIdentifier = identifier;
    }

    @Override
    public boolean isCpu64bit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCpu64(boolean cpu64) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStepping() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStepping(String stepping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setModel(String model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFamily() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFamily(String family) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public float getLoad() {
        return (float)this.getSystemCpuLoadBetweenTicks() * 100.0f;
    }

    @Override
    public synchronized double getSystemCpuLoadBetweenTicks() {
        boolean update;
        long now = System.currentTimeMillis();
        LOG.trace("Current time: {}  Last tick time: {}", (Object)now, (Object)tickTime);
        boolean bl = update = now - tickTime > 950L;
        if (update) {
            CentralProcessor.updateSystemTicks();
            tickTime = now;
            LOG.debug("System Ticks Updated");
        }
        long total = 0L;
        for (int i = 0; i < curTicks.length; ++i) {
            total += curTicks[i] - prevTicks[i];
        }
        long idle = curTicks[3] - prevTicks[3];
        LOG.trace("Total ticks: {}  Idle ticks: {}", (Object)total, (Object)idle);
        if (update) {
            System.arraycopy(curTicks, 0, prevTicks, 0, curTicks.length);
        }
        if (total > 0L && idle >= 0L) {
            return (double)(total - idle) / (double)total;
        }
        return 0.0;
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        CentralProcessor.updateSystemTicks();
        long[] ticks = new long[curTicks.length];
        System.arraycopy(curTicks, 0, ticks, 0, curTicks.length);
        return ticks;
    }

    private static void updateSystemTicks() {
        LOG.trace("Updating System Ticks");
        WinBase.FILETIME lpIdleTime = new WinBase.FILETIME();
        WinBase.FILETIME lpKernelTime = new WinBase.FILETIME();
        WinBase.FILETIME lpUserTime = new WinBase.FILETIME();
        if (0 == Kernel32.INSTANCE.GetSystemTimes(lpIdleTime, lpKernelTime, lpUserTime)) {
            LOG.error("Failed to update system idle/kernel/user times. Error code: " + Native.getLastError());
            return;
        }
        CentralProcessor.curTicks[0] = lpUserTime.toLong() + 11644473600000L;
        CentralProcessor.curTicks[1] = 0L;
        CentralProcessor.curTicks[2] = lpKernelTime.toLong() - lpIdleTime.toLong();
        CentralProcessor.curTicks[3] = lpIdleTime.toLong() + 11644473600000L;
    }

    @Override
    public double getSystemCpuLoad() {
        if (sunMXBean) {
            return ((OperatingSystemMXBean)OS_MXBEAN).getSystemCpuLoad();
        }
        return this.getSystemCpuLoadBetweenTicks();
    }

    @Override
    public double getSystemLoadAverage() {
        return OS_MXBEAN.getSystemLoadAverage();
    }

    @Override
    public double getProcessorCpuLoadBetweenTicks() {
        long now = System.currentTimeMillis();
        LOG.trace("Current time: {}  Last processor tick time: {}", (Object)now, (Object)this.procTickTime);
        if (now - this.procTickTime > 950L) {
            this.updateProcessorTicks();
            System.arraycopy(this.curProcTicks, 0, this.prevProcTicks, 0, this.curProcTicks.length);
            System.arraycopy(allProcessorTicks[this.processorNumber], 0, this.curProcTicks, 0, this.curProcTicks.length);
            this.procTickTime = now;
        }
        long total = 0L;
        for (int i = 0; i < this.curProcTicks.length; ++i) {
            total += this.curProcTicks[i] - this.prevProcTicks[i];
        }
        long idle = this.curProcTicks[3] - this.prevProcTicks[3];
        LOG.trace("Total ticks: {}  Idle ticks: {}", (Object)total, (Object)idle);
        return total > 0L && idle >= 0L ? (double)(total - idle) / (double)total : 0.0;
    }

    @Override
    public long[] getProcessorCpuLoadTicks() {
        this.updateProcessorTicks();
        return allProcessorTicks[this.processorNumber];
    }

    private void updateProcessorTicks() {
        if (pdhOpenTickQueryError != 0 || pdhAddTickCounterError != 0) {
            LOG.warn("PDH Tick Counters not initialized. Processor ticks not updated.");
            return;
        }
        long now = System.currentTimeMillis();
        LOG.trace("Current time: {}  Last all processor tick time: {}", (Object)now, (Object)allProcTickTime);
        if (now - allProcTickTime < 100L) {
            return;
        }
        int ret = Pdh.INSTANCE.PdhCollectQueryData(phQuery.getValue());
        if (ret != 0) {
            LOG.warn("Failed to update Tick Counters. Error code: {}", (Object)String.format("0x%08X", ret));
            return;
        }
        long elapsed = now - allProcTickTime;
        for (int cpu = 0; cpu < numCPU; ++cpu) {
            Pdh.PdhFmtCounterValue phUserCounterValue = new Pdh.PdhFmtCounterValue();
            ret = Pdh.INSTANCE.PdhGetFormattedCounterValue(phUserCounters[cpu].getValue(), 9216, null, phUserCounterValue);
            if (ret != 0) {
                LOG.warn("Failed to get Uer Tick Counters. Error code: {}", (Object)String.format("0x%08X", ret));
                return;
            }
            Pdh.PdhFmtCounterValue phIdleCounterValue = new Pdh.PdhFmtCounterValue();
            ret = Pdh.INSTANCE.PdhGetFormattedCounterValue(phIdleCounters[cpu].getValue(), 9216, null, phIdleCounterValue);
            if (ret != 0) {
                LOG.warn("Failed to get idle Tick Counters. Error code: {}", (Object)String.format("0x%08X", ret));
                return;
            }
            long user = elapsed * phUserCounterValue.value.largeValue / 100000L;
            long idle = elapsed * phIdleCounterValue.value.largeValue / 100000L;
            long[] lArray = allProcessorTicks[cpu];
            lArray[0] = lArray[0] + user;
            long[] lArray2 = allProcessorTicks[cpu];
            lArray2[2] = lArray2[2] + (elapsed - user - idle);
            long[] lArray3 = allProcessorTicks[cpu];
            lArray3[3] = lArray3[3] + idle;
        }
        allProcTickTime = now;
    }

    @Override
    public long getSystemUptime() {
        if (pdhOpenUptimeQueryError != 0 || pdhAddUptimeCounterError != 0) {
            LOG.warn("Uptime Counters not initialized. Returning 0.");
            return 0L;
        }
        int ret = Pdh.INSTANCE.PdhCollectQueryData(uptimeQuery.getValue());
        if (ret != 0) {
            LOG.error("Failed to update Uptime Counters. Error code: {}", (Object)String.format("0x%08X", ret));
            return 0L;
        }
        Pdh.PdhFmtCounterValue uptimeCounterValue = new Pdh.PdhFmtCounterValue();
        ret = Pdh.INSTANCE.PdhGetFormattedCounterValue(pUptime.getValue(), 1024, null, uptimeCounterValue);
        if (ret != 0) {
            LOG.error("Failed to get Uptime Counters. Error code: {}", (Object)String.format("0x%08X", ret));
            return 0L;
        }
        return uptimeCounterValue.value.largeValue;
    }

    public String toString() {
        return this.getName();
    }

    static {
        try {
            Class.forName("com.sun.management.OperatingSystemMXBean");
            ((OperatingSystemMXBean)OS_MXBEAN).getSystemCpuLoad();
            sunMXBean = true;
            LOG.debug("Oracle MXBean detected.");
        }
        catch (ClassNotFoundException e) {
            sunMXBean = false;
            LOG.debug("Oracle MXBean not detected.");
        }
        tickTime = System.currentTimeMillis();
        prevTicks = new long[4];
        curTicks = new long[4];
        CentralProcessor.updateSystemTicks();
        System.arraycopy(curTicks, 0, prevTicks, 0, curTicks.length);
        phQuery = new PointerByReference();
        zero = new IntByReference(0);
        uptimeQuery = new PointerByReference();
        one = new IntByReference(1);
        pdhOpenTickQueryError = 0;
        pdhAddTickCounterError = 0;
        pdhOpenUptimeQueryError = 0;
        pdhAddUptimeCounterError = 0;
        WinBase.SYSTEM_INFO sysinfo = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetSystemInfo(sysinfo);
        numCPU = sysinfo.dwNumberOfProcessors.intValue();
        pdhOpenTickQueryError = Pdh.INSTANCE.PdhOpenQuery(null, zero, phQuery);
        if (pdhOpenTickQueryError != 0) {
            LOG.error("Failed to open PDH Tick Query. Error code: {}", (Object)String.format("0x%08X", pdhOpenTickQueryError));
        }
        pdhOpenUptimeQueryError = Pdh.INSTANCE.PdhOpenQuery(null, one, uptimeQuery);
        if (pdhOpenTickQueryError != 0) {
            LOG.error("Failed to open PDH Uptime Query. Error code: {}", (Object)String.format("0x%08X", pdhOpenUptimeQueryError));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Pdh.INSTANCE.PdhCloseQuery(phQuery.getValue());
                Pdh.INSTANCE.PdhCloseQuery(uptimeQuery.getValue());
            }
        });
        phUserCounters = new PointerByReference[numCPU];
        phIdleCounters = new PointerByReference[numCPU];
        if (pdhOpenTickQueryError == 0) {
            for (int p = 0; p < numCPU; ++p) {
                String counterPath = String.format("\\Processor(%d)\\%% user time", p);
                CentralProcessor.phUserCounters[p] = new PointerByReference();
                pdhAddTickCounterError = Pdh.INSTANCE.PdhAddEnglishCounterA(phQuery.getValue(), counterPath, zero, phUserCounters[p]);
                if (pdhAddTickCounterError != 0) {
                    LOG.error("Failed to add PDH User Tick Counter for processor {}. Error code: {}", (Object)p, (Object)String.format("0x%08X", pdhAddTickCounterError));
                    break;
                }
                counterPath = String.format("\\Processor(%d)\\%% idle time", p);
                CentralProcessor.phIdleCounters[p] = new PointerByReference();
                pdhAddTickCounterError = Pdh.INSTANCE.PdhAddEnglishCounterA(phQuery.getValue(), counterPath, zero, phIdleCounters[p]);
                if (pdhAddTickCounterError == 0) continue;
                LOG.error("Failed to add PDH Idle Tick Counter for processor {}. Error code: {}", (Object)p, (Object)String.format("0x%08X", pdhAddTickCounterError));
                break;
            }
            LOG.debug("Tick counter queries added.  Initializing with first query.");
            int ret = Pdh.INSTANCE.PdhCollectQueryData(phQuery.getValue());
            if (ret != 0) {
                LOG.warn("Failed to update Tick Counters. Error code: {}", (Object)String.format("0x%08X", ret));
            }
        }
        if (pdhOpenUptimeQueryError == 0) {
            String uptimePath = "\\System\\System Up Time";
            pUptime = new PointerByReference();
            pdhAddUptimeCounterError = Pdh.INSTANCE.PdhAddEnglishCounterA(uptimeQuery.getValue(), uptimePath, one, pUptime);
            if (pdhAddUptimeCounterError != 0) {
                LOG.error("Failed to add PDH Uptime Counter. Error code: {}", (Object)String.format("0x%08X", pdhAddUptimeCounterError));
            }
        }
        allProcessorTicks = new long[numCPU][4];
        allProcTickTime = System.currentTimeMillis() - 100L;
    }
}

