/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows.nt;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Memory;

public class GlobalMemory
implements Memory {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalMemory.class);
    private WinBase.MEMORYSTATUSEX _memory = new WinBase.MEMORYSTATUSEX();

    public GlobalMemory() {
        if (!Kernel32.INSTANCE.GlobalMemoryStatusEx(this._memory)) {
            LOG.error("Failed to Initialize MemoryStatusEx. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            this._memory = null;
        }
    }

    @Override
    public long getAvailable() {
        if (this._memory == null) {
            LOG.warn("MemoryStatusEx not initialized. No available memoroy data available");
            return 0L;
        }
        return this._memory.ullAvailPhys.longValue();
    }

    @Override
    public long getTotal() {
        if (this._memory == null) {
            LOG.warn("MemoryStatusEx not initialized. No total memory data available");
            return 0L;
        }
        return this._memory.ullTotalPhys.longValue();
    }
}

