/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.Arrays;
import org.hawkular.inventory.api.InventoryException;
import org.hawkular.inventory.api.filters.Filter;

public final class EntityNotFoundException
extends InventoryException {
    private final Class<?> entityType;
    private final Filter[][] filters;
    private final String msg;

    public EntityNotFoundException(Class<?> entityClass, Filter[][] filters) {
        this.entityType = entityClass;
        this.filters = filters;
        this.msg = null;
    }

    public EntityNotFoundException(Filter[][] filters) {
        this(null, filters);
    }

    public EntityNotFoundException(String msg) {
        this.msg = msg;
        this.entityType = null;
        this.filters = null;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public Filter[][] getFilters() {
        return this.filters;
    }

    @Override
    public String getMessage() {
        if (null != this.msg) {
            return this.msg;
        }
        return (this.entityType == null ? "Nothing" : "No " + this.entityType.getSimpleName()) + " found on any of the following paths: " + Arrays.deepToString((Object[])this.filters);
    }
}

