/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.filters;

import java.util.Objects;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.CanonicalPath;

public class Related
extends Filter {
    private final CanonicalPath entityPath;
    private final String relationshipName;
    private final String relationshipId;
    private final EntityRole entityRole;

    public static Related with(CanonicalPath entityPath, String relationship) {
        return new Related(entityPath, relationship, EntityRole.SOURCE);
    }

    public static Related with(CanonicalPath entityPath, Relationships.WellKnown relationship) {
        return new Related(entityPath, relationship.name(), EntityRole.SOURCE);
    }

    public static Related by(String relationshipName) {
        return new Related(null, relationshipName, EntityRole.SOURCE);
    }

    public static Related by(Relationships.WellKnown relationship) {
        return new Related(null, relationship.name(), EntityRole.SOURCE);
    }

    public static Related byRelationshipWithId(String relationshipId) {
        return new Related(null, relationshipId, EntityRole.SOURCE);
    }

    public static Related asTargetWith(CanonicalPath entityPath, String relationship) {
        return new Related(entityPath, relationship, EntityRole.TARGET);
    }

    public static Related asTargetWith(CanonicalPath entityPath, Relationships.WellKnown relationship) {
        return new Related(entityPath, relationship.name(), EntityRole.TARGET);
    }

    public static Related asTargetBy(String relationshipName) {
        return new Related(null, relationshipName, EntityRole.TARGET);
    }

    public static Related asTargetBy(Relationships.WellKnown relationship) {
        return new Related(null, relationship.name(), EntityRole.TARGET);
    }

    protected Related(CanonicalPath entityPath, String relationshipName, String relationshipId, EntityRole entityRole) {
        this.entityPath = entityPath;
        this.relationshipName = relationshipName;
        this.relationshipId = relationshipId;
        this.entityRole = entityRole;
    }

    protected Related(CanonicalPath entityPath, String relationshipName, EntityRole entityRole) {
        this(entityPath, relationshipName, null, entityRole);
    }

    public CanonicalPath getEntityPath() {
        return this.entityPath;
    }

    public String getRelationshipName() {
        return this.relationshipName;
    }

    public String getRelationshipId() {
        return this.relationshipId;
    }

    public EntityRole getEntityRole() {
        return this.entityRole;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + (this.entityPath != null ? "entity=" + String.valueOf(this.entityPath) : "") + ", rel='" + this.relationshipName + "', role=" + this.entityRole.name() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Related)) {
            return false;
        }
        Related related = (Related)o;
        if (!Objects.equals(this.entityPath, related.entityPath)) {
            return false;
        }
        if (!Objects.equals(this.relationshipName, related.relationshipName)) {
            return false;
        }
        if (!Objects.equals(this.relationshipId, related.relationshipId)) {
            return false;
        }
        return this.entityRole == related.entityRole;
    }

    public int hashCode() {
        int result = this.entityPath != null ? this.entityPath.hashCode() : 0;
        result = 31 * result + (this.relationshipName != null ? this.relationshipName.hashCode() : 0);
        result = 31 * result + (this.relationshipId != null ? this.relationshipId.hashCode() : 0);
        result = 31 * result + (this.entityRole != null ? this.entityRole.hashCode() : 0);
        return result;
    }

    public static enum EntityRole {
        TARGET,
        SOURCE,
        ANY;

    }
}

