/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.ArrayList;
import java.util.List;
import org.hawkular.inventory.base.DelegatingInventoryBackend;
import org.hawkular.inventory.base.PotentiallyCommittingPayload;
import org.hawkular.inventory.base.spi.CommitFailureException;
import org.hawkular.inventory.base.spi.InventoryBackend;

final class NoncommittingBackend<E>
extends DelegatingInventoryBackend<E> {
    private final PayloadRememberingTransaction transaction;

    public NoncommittingBackend(InventoryBackend<E> backend, boolean mutating) {
        super(backend);
        this.transaction = new PayloadRememberingTransaction(mutating);
    }

    @Override
    public InventoryBackend.Transaction startTransaction(boolean mutating) {
        return this.transaction;
    }

    @Override
    public void rollback(InventoryBackend.Transaction transaction) {
    }

    @Override
    public void commit(InventoryBackend.Transaction transaction) throws CommitFailureException {
    }

    public List<PotentiallyCommittingPayload<?>> getRecordedPayloads() {
        return this.transaction.payloads;
    }

    public void clearRecordedPayloads() {
        this.transaction.payloads.clear();
    }

    private static class PayloadRememberingTransaction
    extends InventoryBackend.Transaction {
        private final ArrayList<PotentiallyCommittingPayload<?>> payloads = new ArrayList();

        public PayloadRememberingTransaction(boolean mutating) {
            super(mutating);
        }

        @Override
        public <R> R execute(PotentiallyCommittingPayload<R> payload) throws CommitFailureException {
            this.payloads.add(payload);
            return super.execute(payload);
        }
    }
}

