/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common.consumer;

import java.io.IOException;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Session;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.consumer.AbstractBasicMessageListener;
import org.hawkular.bus.common.consumer.ConsumerConnectionContext;
import org.hawkular.bus.common.log.MsgLogger;
import org.hawkular.bus.common.producer.ProducerConnectionContext;

public abstract class RPCBasicMessageListener<T extends BasicMessage, U extends BasicMessage>
extends AbstractBasicMessageListener<T> {
    private final MsgLogger msglog = MsgLogger.LOGGER;
    private MessageProcessor messageSender;

    public RPCBasicMessageListener() {
        this.setMessageSender(new MessageProcessor());
    }

    public RPCBasicMessageListener(MessageProcessor messageSender) {
        this.setMessageSender(messageSender);
    }

    protected RPCBasicMessageListener(Class<T> jsonDecoderRing) {
        super(jsonDecoderRing);
        this.setMessageSender(new MessageProcessor());
    }

    protected RPCBasicMessageListener(Class<T> jsonDecoderRing, MessageProcessor messageSender) {
        super(jsonDecoderRing);
        this.setMessageSender(messageSender);
    }

    protected MessageProcessor getMessageSender() {
        return this.messageSender;
    }

    protected void setMessageSender(MessageProcessor messageSender) {
        this.messageSender = messageSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        BasicMessageWithExtraData msgWithExtraData = this.parseMessage(message);
        if (msgWithExtraData == null) {
            return;
        }
        U responseBasicMessage = this.onBasicMessage((T)msgWithExtraData);
        ConsumerConnectionContext consumerConnectionContext = null;
        try {
            Destination replyTo = message.getJMSReplyTo();
            if (replyTo != null) {
                this.getLog().debugf("RPC client asked to get response sent to [%s]", (Object)replyTo);
                MessageProcessor sender = this.getMessageSender();
                if (sender == null) {
                    this.msglog.errorNoMessageSenderInListener();
                    return;
                }
                consumerConnectionContext = this.getConsumerConnectionContext();
                if (consumerConnectionContext == null) {
                    this.msglog.errorNoConnectionContextInListener();
                    return;
                }
                ProducerConnectionContext producerContext = new ProducerConnectionContext();
                producerContext.copy(consumerConnectionContext);
                producerContext.setDestination(replyTo);
                Session session = producerContext.getSession();
                if (session == null) {
                    this.msglog.errorNoSessionInListener();
                } else {
                    producerContext.setMessageProducer(session.createProducer(replyTo));
                    sender.send(producerContext, (BasicMessage)responseBasicMessage);
                }
            } else {
                this.getLog().debug((Object)"Sender did not tell us where to reply - will not send any response back");
            }
        }
        catch (Exception e) {
            this.msglog.errorFailedToSendResponse(e);
            return;
        }
        finally {
            if (consumerConnectionContext != null) {
                try {
                    consumerConnectionContext.close();
                }
                catch (IOException e) {
                    this.msglog.errorFailedToCloseResourcesToRPCClient(e);
                }
            }
        }
    }

    protected U onBasicMessage(BasicMessageWithExtraData<T> msgWithExtraData) {
        return this.onBasicMessage(msgWithExtraData.getBasicMessage());
    }

    protected U onBasicMessage(T basicMessage) {
        return null;
    }
}

