/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Path;

public final class DetypedPathDeserializer
extends JsonDeserializer<Path> {
    private static ThreadLocal<CanonicalPath> CURRENT_CANONICAL_ORIGIN = new ThreadLocal();
    private static final ThreadLocal<CanonicalPath> CURRENT_RELATIVE_PATH_ORIGIN = new ThreadLocal();
    private static final ThreadLocal<Class<?>> CURRENT_ENTITY_TYPE = new ThreadLocal();

    public static void setCurrentCanonicalOrigin(CanonicalPath path) {
        CURRENT_CANONICAL_ORIGIN.set(path);
    }

    public static void setCurrentRelativePathOrigin(CanonicalPath path) {
        CURRENT_RELATIVE_PATH_ORIGIN.set(path);
    }

    public static void setCurrentEntityType(Class<?> entityType) {
        CURRENT_ENTITY_TYPE.set(entityType);
    }

    public Path deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String str = jp.getValueAsString();
        CanonicalPath co = CURRENT_CANONICAL_ORIGIN.get();
        CanonicalPath ro = CURRENT_RELATIVE_PATH_ORIGIN.get();
        Class<?> entityType = CURRENT_ENTITY_TYPE.get();
        return Path.fromPartiallyUntypedString((String)str, (CanonicalPath)co, (CanonicalPath)ro, entityType);
    }
}

