/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.dmr;

import java.io.IOException;
import java.util.List;
import org.hawkular.agent.monitor.diagnostics.ProtocolDiagnostics;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.ResourceTypeManager;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRDriver;
import org.hawkular.agent.monitor.protocol.dmr.DMRLocationResolver;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.agent.monitor.protocol.dmr.ModelControllerClientFactory;
import org.hawkular.dmr.api.OperationBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DMREndpointService
extends EndpointService<DMRNodeLocation, DMRSession> {
    private final ModelControllerClientFactory modelControllerClientFactory;

    public static String lookupServerIdentifier(ModelControllerClient client) throws IOException {
        ModelNode rootNode = OperationBuilder.readResource().includeRuntime().execute(client).assertSuccess().getResultNode();
        String lauchType = rootNode.get("launch-type").asString();
        boolean isDomainMode = "domain".equalsIgnoreCase(lauchType);
        String hostName = isDomainMode ? rootNode.get("host").asString() : null;
        String serverName = rootNode.get("name").asString();
        String uuid = rootNode.has("uuid") ? rootNode.get("uuid").asString() : null;
        List sysprops = ((OperationBuilder.ReadAttributeOperationBuilder)OperationBuilder.readAttribute().address().segment("core-service", "platform-mbean").segment("type", "runtime").parentBuilder()).name("system-properties").execute(client).assertSuccess().getResultNode().asPropertyList();
        String nodeName = null;
        for (Property prop : sysprops) {
            if (!"jboss.node.name".equals(prop.getName())) continue;
            nodeName = prop.getValue().asString();
            break;
        }
        return DMREndpointService.getServerIdentifier(hostName, serverName, nodeName, uuid);
    }

    static String getServerIdentifier(String hostName, String serverName, String nodeName, String uuid) {
        if (uuid != null) {
            return uuid;
        }
        StringBuilder fullId = new StringBuilder();
        if (hostName != null && !hostName.isEmpty()) {
            if (fullId.length() > 0) {
                fullId.append('.');
            }
            fullId.append(hostName);
        }
        if (serverName != null && !serverName.isEmpty()) {
            if (fullId.length() > 0) {
                fullId.append('.');
            }
            fullId.append(serverName);
        }
        if (nodeName != null && !nodeName.isEmpty() && !nodeName.equals(serverName)) {
            if (fullId.length() > 0) {
                fullId.append('.');
            }
            fullId.append(nodeName);
        }
        return fullId.toString();
    }

    public DMREndpointService(String feedId, MonitoredEndpoint endpoint, ResourceTypeManager<DMRNodeLocation> resourceTypeManager, ModelControllerClientFactory modelControllerClientFactory, ProtocolDiagnostics diagnostics) {
        super(feedId, endpoint, resourceTypeManager, new DMRLocationResolver(), diagnostics);
        this.modelControllerClientFactory = modelControllerClientFactory;
    }

    @Override
    public DMRSession openSession() {
        ModelControllerClient client = this.modelControllerClientFactory.createClient();
        DMRDriver driver = new DMRDriver(client, this.getEndpoint(), this.getDiagnostics());
        return new DMRSession(this.getFeedId(), this.getEndpoint(), this.getResourceTypeManager(), driver, this.getLocationResolver(), client);
    }
}

