/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.dmr;

import org.hawkular.agent.monitor.inventory.NodeLocation;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;

public class DMRNodeLocation
implements NodeLocation {
    private static final DMRNodeLocation EMPTY = new DMRNodeLocation(PathAddress.EMPTY_ADDRESS);
    protected final PathAddress pathAddress;

    public static DMRNodeLocation empty() {
        return EMPTY;
    }

    public static DMRNodeLocation of(ModelNode addressNode) {
        return new DMRNodeLocation(PathAddress.pathAddress((ModelNode)addressNode));
    }

    public DMRNodeLocation(PathAddress pathAddress) {
        if (pathAddress == null) {
            throw new IllegalArgumentException("Cannot create a new [" + this.getClass().getName() + "] with a null pathAddress");
        }
        this.pathAddress = pathAddress;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DMRNodeLocation other = (DMRNodeLocation)obj;
        return !(this.pathAddress == null ? other.pathAddress != null : !this.pathAddress.equals(other.pathAddress));
    }

    public PathAddress getPathAddress() {
        return this.pathAddress;
    }

    public int hashCode() {
        return this.pathAddress.hashCode();
    }

    public String toString() {
        return this.pathAddress.toCLIStyleString();
    }

    public static DMRNodeLocation of(String path) {
        return new DMRNodeLocation("/".equals(path) ? PathAddress.EMPTY_ADDRESS : PathAddress.parseCLIStyleAddress((String)path));
    }
}

